/*
 * Decompiled with CFR 0.152.
 */
package levelup2.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import levelup2.config.OreChunkStorage;
import levelup2.skills.SkillRegistry;
import levelup2.util.JsonTransfer;
import levelup2.util.Library;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class LevelUpConfig {
    public static boolean resetClassOnDeath = false;
    public static boolean furnaceEjection = false;
    private static boolean resetJsonFiles = false;
    public static boolean damageScaling = false;
    public static List<String> cropBlacklist;
    private static Configuration cfg;
    private static Property[] serverProperties;
    public static int rareChance;
    public static int uncommonChance;
    public static int commonChance;
    public static int combinedChance;
    public static int reclassCost;
    public static double refundValue;
    public static List<String> oreBlocks;
    public static List<Ingredient> blacklistOutputs;
    public static boolean giveSkillBook;
    public static int levelCost;
    private static String[] oreBlockList;
    private static String[] surfaceOresDefault;
    private static String[] netherOresDefault;
    private static Property resetJson;
    private static Map<String, Property> PROP_SYNC;
    private static Path configDir;
    public static Path jsonDir;
    public static Path lootDir;
    public static Path skillDir;
    public static Path classDir;

    public static void init(File file) {
        configDir = file.getParentFile().toPath().resolve("levelup2");
        jsonDir = configDir.resolve("json");
        lootDir = jsonDir.resolve("loot_tables");
        skillDir = jsonDir.resolve("skills").resolve("playerskill");
        classDir = jsonDir.resolve("skills").resolve("playerclass");
        cfg = new Configuration(file);
        PROP_SYNC.put("classreset", cfg.get("general", "Reset class on death", resetClassOnDeath, "Does the player lose all levels on death?"));
        PROP_SYNC.put("furnaceeject", cfg.get("general", "Furnace ejects bonus items", furnaceEjection, "Does the furnace eject doubled items?"));
        PROP_SYNC.put("skillrefund", cfg.get("general", "Skill refund cost", refundValue, "The refund value of lowering skill levels."));
        PROP_SYNC.put("levelcost", cfg.get("general", "Skill level cost", levelCost, "The amount of levels needed to gain a skill point.", 1, 30));
        PROP_SYNC.put("skillbook", cfg.get("general", "Spawn with book", giveSkillBook, "If the player spawns with a skill book."));
        oreBlocks = Arrays.asList(cfg.getStringList("Special ore cases", "Whitelist", oreBlockList, "Blocks that don't have their own OreDict entry, but still drop registered ores."));
        cropBlacklist = Arrays.asList(cfg.getStringList("Crops for farming", "Blacklist", new String[]{""}, "Crops that won't be affected by farming growth skill, uses internal block name. No sync to client required."));
        LevelUpConfig.assembleOreChunks(Library.SURFACE_ORES, cfg.getStringList("surfaceores", "general", surfaceOresDefault, "Ores that split into chunks. (String build: Ore name, color, experience yield, smelting result, (optional) defined chunk"));
        LevelUpConfig.assembleOreChunks(Library.NETHER_ORES, cfg.getStringList("netherores", "general", netherOresDefault, "Ores that split into chunks. (String build: Ore name, color, experience yield, smelting result, (optional) defined chunk"));
        LevelUpConfig.assembleOreChunks(Library.END_ORES, cfg.getStringList("endores", "general", new String[0], "Ores that split into chunks. (String build: Ore name, color, experience yield, smelting result, (optional) defined chunk"));
        resetJson = cfg.get("debug", "Reset json files", resetJsonFiles, "Forces Level Up! to restore external json files to default");
        resetJsonFiles = resetJson.getBoolean();
        rareChance = cfg.getInt("Rare Digging Loot Chance", "digloot", rareChance, 0, 100, "Chances that a rare loot drop will appear");
        uncommonChance = cfg.getInt("Uncommon Digging Loot Chance", "digloot", uncommonChance, 0, 100, "Chances that an uncommon loot drop will appear");
        commonChance = cfg.getInt("Common Digging Loot Chance", "digloot", commonChance, 0, 100, "Chances that a common loot drop will appear");
        combinedChance = rareChance + uncommonChance + commonChance;
        if (cfg.hasChanged()) {
            cfg.save();
        }
        LevelUpConfig.useServerProperties();
        LevelUpConfig.transferLootTables();
        if (resetJsonFiles) {
            resetJson.set(false);
            cfg.save();
        }
    }

    private static void assembleOreChunks(List<OreChunkStorage> chunkItem, String[] ores) {
        if (ores.length > 0) {
            for (int i = 0; i < ores.length; ++i) {
                String[] parts = ores[i].split(",");
                String oreName = parts[0];
                int color = Integer.decode(parts[1]);
                int experience = Integer.parseInt(parts[2]);
                String stack = parts[3];
                if (parts.length == 5) {
                    chunkItem.add(new OreChunkStorage(oreName, stack, color, experience, i, parts[4]));
                    continue;
                }
                chunkItem.add(new OreChunkStorage(oreName, stack, color, experience, i));
            }
        }
    }

    public static ItemStack getStackFromString(String str) {
        String[] parts = str.split(":");
        int meta = parts.length == 3 ? Integer.parseInt(parts[2]) : 0;
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(parts[0], parts[1]));
        if (item != null && item != Items.field_190931_a) {
            return new ItemStack(item, 1, meta);
        }
        return ItemStack.field_190927_a;
    }

    public static void getBlacklistOutputs() {
        String[] items = cfg.getStringList("CraftingOutputs", "blacklist", new String[0], "Which items, if any, do not give experience upon crafting. Format: modid:item OR modid:item:metadata");
        ArrayList ing = Lists.newArrayList();
        if (items.length > 0) {
            for (String str : items) {
                String[] parts = str.split(":");
                int meta = parts.length == 3 ? Integer.parseInt(parts[2]) : Short.MAX_VALUE;
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(parts[0], parts[1]));
                if (item == null || item == Items.field_190931_a) continue;
                ing.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(item, 1, meta)}));
            }
        }
        if (cfg.hasChanged()) {
            cfg.save();
        }
        blacklistOutputs = ing;
    }

    public static NBTTagCompound getServerProperties() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("classreset", PROP_SYNC.get("classreset").getBoolean());
        tag.func_74757_a("furnaceeject", PROP_SYNC.get("furnaceeject").getBoolean());
        tag.func_74780_a("skillrefund", PROP_SYNC.get("skillrefund").getDouble());
        tag.func_74768_a("levelcost", PROP_SYNC.get("levelcost").getInt());
        tag.func_74757_a("skillbook", PROP_SYNC.get("skillbook").getBoolean());
        return tag;
    }

    public static void useServerProperties() {
        resetClassOnDeath = PROP_SYNC.get("classreset").getBoolean();
        furnaceEjection = PROP_SYNC.get("furnaceeject").getBoolean();
        refundValue = PROP_SYNC.get("skillrefund").getDouble();
        levelCost = PROP_SYNC.get("levelcost").getInt();
        giveSkillBook = PROP_SYNC.get("skillbook").getBoolean();
    }

    public static void useServerProperties(NBTTagCompound tag) {
        resetClassOnDeath = tag.func_74767_n("classreset");
        furnaceEjection = tag.func_74767_n("furnaceeject");
        refundValue = tag.func_74769_h("skillrefund");
        levelCost = tag.func_74762_e("levelcost");
        giveSkillBook = tag.func_74767_n("skillbook");
        SkillRegistry.resetForNewProps();
    }

    private static List<Integer> getColorsFromProperty(Property prop) {
        int[] colors = prop.getIntList();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < colors.length; ++i) {
            list.add(colors[i]);
        }
        return list;
    }

    private static void transferLootTables() {
        HashSet<String> files = new HashSet<String>();
        files.add("fishing/fishing_loot");
        files.add("digging/common_dig");
        files.add("digging/uncommon_dig");
        files.add("digging/rare_dig");
        JsonTransfer.findResources("json/loot_tables", files).stream().forEach(r -> JsonTransfer.copyResource(r, configDir.resolve((String)r), resetJsonFiles));
        Library.registerLootTableLocations(files);
    }

    public static void registerSkillProperties() {
        JsonTransfer.findResources("json/skills/playerskill", Library.SKILLS).stream().forEach(r -> JsonTransfer.copyResource(r, configDir.resolve((String)r), resetJsonFiles));
        JsonTransfer.findResources("json/skills/playerclass", Library.CLASSES).stream().forEach(r -> JsonTransfer.copyResource(r, configDir.resolve((String)r), resetJsonFiles));
        SkillRegistry.registerSkillProperties();
    }

    static {
        rareChance = 1;
        uncommonChance = 15;
        commonChance = 85;
        reclassCost = 30;
        refundValue = 0.5;
        giveSkillBook = true;
        levelCost = 5;
        oreBlockList = new String[]{"geolosys:ore_vanilla", "geolosys:ore"};
        surfaceOresDefault = new String[]{"oreCoal,0x343434,1,minecraft:coal", "oreIron,0xBC9980,1,minecraft:iron_ingot", "oreGold,0xFCEE4B,2,minecraft:gold_ingot", "oreDiamond,0x5DECF5,4,minecraft:diamond", "oreEmerald,0x17DD62,4,minecraft:emerald", "oreRedstone,0xFF0000,2,minecraft:redstone", "oreLapis,0x193CB4,2,minecraft:dye:4", "oreCopper,0xFF6D11,1,thermalfoundation:material:128", "oreTin,0x8FB0CE,1,thermalfoundation:material:129", "oreSilver,0xA9CDDC,2,thermalfoundation:material:130", "oreLead,0x515C73,2,thermalfoundation:material:131", "oreAluminum,0xE2CEE1,2,thermalfoundation:material:132", "oreNickel,0xAAA37B,2,thermalfoundation:material:133", "orePlatinum,0xA1DCFF,3,thermalfoundation:material:134", "oreIridium,0xB7BFDC,4,thermalfoundation:material:135", "oreMithril,0x64B9D8,4,thermalfoundation:material:136"};
        netherOresDefault = new String[]{"oreQuartz,0xE5DED5,2,minecraft:quartz", "oreCobalt,0x2979e7,4,tconstruct:ingots", "oreArdite,0xFFBD24,5,tconstruct:ingots:1"};
        PROP_SYNC = Maps.newHashMap();
    }
}

