/*
 * Decompiled with CFR 0.152.
 */
package levelup2.event;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import levelup2.api.IProcessor;
import levelup2.capability.CapabilityBrewingStand;
import levelup2.capability.CapabilityFurnace;
import levelup2.capability.PlayerCapability;
import levelup2.config.LevelUpConfig;
import levelup2.skills.SkillRegistry;
import levelup2.util.Library;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockMelon;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class CraftingSkillHandler {
    public static final CraftingSkillHandler INSTANCE = new CraftingSkillHandler();
    private Random rand = new Random();
    private static final ResourceLocation FURNACEMODS = new ResourceLocation("levelup", "furnacemods");
    private static final ResourceLocation FISHBONUS = new ResourceLocation("levelup", "fishbonus");
    private static final ResourceLocation CROPGROWTH = new ResourceLocation("levelup", "cropgrowth");
    private static final ResourceLocation HARVESTBONUS = new ResourceLocation("levelup", "harvestbonus");
    private static final ResourceLocation CRAFTBONUS = new ResourceLocation("levelup", "craft_bonus");
    private Map<Integer, List<TileEntity>> processors = Maps.newHashMap();
    private Map<Integer, List<TileEntity>> toAdd = Maps.newHashMap();
    private Map<Integer, List<TileEntity>> toRemove = Maps.newHashMap();

    private CraftingSkillHandler() {
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent evt) {
        int craftingChances;
        if (SkillRegistry.getSkillLevel(evt.player, CRAFTBONUS) > 0 && !this.isBlacklistedOutput(evt.crafting) && this.isNotOneItemCrafting(evt.craftMatrix) && (craftingChances = this.getCraftingItems(evt.craftMatrix)) > 0) {
            int experienceGain = 0;
            for (int i = 0; i < this.getCraftingItems(evt.craftMatrix); ++i) {
                if (!(this.rand.nextFloat() < 0.55f)) continue;
                ++experienceGain;
            }
            if (experienceGain > 0) {
                SkillRegistry.addExperience(evt.player, experienceGain);
            }
        }
    }

    private boolean isBlacklistedOutput(ItemStack stack) {
        if (!LevelUpConfig.blacklistOutputs.isEmpty()) {
            for (Ingredient ing : LevelUpConfig.blacklistOutputs) {
                if (!ing.apply(stack)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNotOneItemCrafting(IInventory inv) {
        boolean notSame = false;
        ItemStack firstStack = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || inv.func_70301_a(i).func_77973_b().hasContainerItem(inv.func_70301_a(i))) continue;
            if (firstStack.func_190926_b()) {
                firstStack = inv.func_70301_a(i).func_77946_l();
                continue;
            }
            if (firstStack.func_77969_a(inv.func_70301_a(i))) continue;
            notSame = true;
        }
        return notSame;
    }

    private int getCraftingItems(IInventory inv) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || inv.func_70301_a(i).func_77973_b().hasContainerItem(inv.func_70301_a(i))) continue;
            ItemStack stack = inv.func_70301_a(i).func_77946_l();
            stack.func_190920_e(1);
            if (items.isEmpty()) {
                items.add(stack);
                continue;
            }
            if (SkillRegistry.listContains(stack, items)) continue;
            items.add(stack);
        }
        return items.size();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onBlockBroken(BlockEvent.BreakEvent evt) {
        if (!evt.getWorld().field_72995_K && evt.getPlayer() != null && SkillRegistry.getPlayer(evt.getPlayer()).isActive()) {
            if (evt.getState().func_177230_c() instanceof BlockCrops || evt.getState().func_177230_c() instanceof BlockStem) {
                if (!((IGrowable)evt.getState().func_177230_c()).func_176473_a(evt.getWorld(), evt.getPos(), evt.getState(), false)) {
                    this.doCropDrops(evt);
                }
            } else if (evt.getState().func_177230_c() instanceof BlockMelon) {
                this.doCropDrops(evt);
            }
        }
    }

    private void doCropDrops(BlockEvent.BreakEvent evt) {
        Random rand = evt.getPlayer().func_70681_au();
        int skill = SkillRegistry.getSkillLevel(evt.getPlayer(), HARVESTBONUS);
        if (skill > 0 && rand.nextInt(10) < skill) {
            Item item = evt.getState().func_177230_c().func_180660_a(evt.getState(), rand, 0);
            if (item == Items.field_190931_a || item == null) {
                if (evt.getState().func_177230_c() == Blocks.field_150393_bb) {
                    item = Items.field_151080_bb;
                } else if (evt.getState().func_177230_c() == Blocks.field_150394_bc) {
                    item = Items.field_151081_bc;
                }
            }
            if (item != Items.field_190931_a && item != null) {
                evt.getWorld().func_72838_d((Entity)new EntityItem(evt.getWorld(), (double)evt.getPos().func_177958_n(), (double)evt.getPos().func_177956_o(), (double)evt.getPos().func_177952_p(), new ItemStack(item, Math.max(1, evt.getState().func_177230_c().quantityDropped(evt.getState(), 0, rand)), evt.getState().func_177230_c().func_180651_a(evt.getState()))));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent evt) {
        EntityPlayer player;
        if (evt.phase == TickEvent.Phase.START && SkillRegistry.getPlayer(evt.player).isActive() && (player = evt.player) != null) {
            int skillLevel = SkillRegistry.getSkillLevel(player, CROPGROWTH);
            if (!player.field_70170_p.field_72995_K && skillLevel > 0 && player.func_70681_au().nextFloat() <= (float)skillLevel / 500.0f) {
                this.growCropsAround(player.field_70170_p, skillLevel, player);
            }
        }
    }

    private void growCropsAround(World world, int range, EntityPlayer player) {
        int posX = (int)player.field_70165_t;
        int posY = (int)player.field_70163_u;
        int posZ = (int)player.field_70161_v;
        int dist = range / 2 + 2;
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos(posX - dist, posY - dist, posZ - dist), (BlockPos)new BlockPos(posX + dist + 1, posY + dist + 1, posZ + dist + 1))) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!(block instanceof IPlantable) || SkillRegistry.getCropBlacklist().contains(block)) continue;
            world.func_175684_a(pos, block, block.func_149738_a(world));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onFishInteract(PlayerInteractEvent.RightClickItem evt) {
        ItemStack loot;
        EntityFishHook hook;
        if (evt.getResult() != Event.Result.DENY && SkillRegistry.getPlayer(evt.getEntityPlayer()).isActive() && (hook = evt.getEntityPlayer().field_71104_cf) != null && hook.field_146043_c == null && hook.field_146045_ax > 0 && !(loot = this.getFishingLoot(evt.getWorld(), evt.getEntityPlayer())).func_190926_b()) {
            ItemStack stack = evt.getEntityPlayer().field_71071_by.func_70448_g();
            int i = stack.func_190916_E();
            int j = stack.func_77952_i();
            stack.func_77972_a(1, (EntityLivingBase)evt.getEntityPlayer());
            evt.getEntityPlayer().func_184609_a(evt.getHand());
            evt.getEntityPlayer().field_71071_by.func_70299_a(evt.getEntityPlayer().field_71071_by.field_70461_c, stack);
            if (evt.getEntityPlayer().field_71075_bZ.field_75098_d) {
                stack.func_190917_f(i);
                if (stack.func_77984_f()) {
                    stack.func_77964_b(j);
                }
            }
            if (stack.func_190916_E() <= 0) {
                evt.getEntityPlayer().field_71071_by.func_70299_a(evt.getEntityPlayer().field_71071_by.field_70461_c, ItemStack.field_190927_a);
                MinecraftForge.EVENT_BUS.post((Event)new PlayerDestroyItemEvent(evt.getEntityPlayer(), stack, evt.getHand()));
            }
            if (!evt.getEntityPlayer().func_184587_cr() && evt.getEntityPlayer() instanceof EntityPlayerMP) {
                ((EntityPlayerMP)evt.getEntityPlayer()).func_71120_a(evt.getEntityPlayer().field_71069_bz);
            }
            evt.setResult(Event.Result.DENY);
            if (!hook.field_70170_p.field_72995_K) {
                EntityItem item = new EntityItem(hook.field_70170_p, hook.field_70165_t, hook.field_70163_u, hook.field_70161_v, loot);
                double d5 = hook.func_190619_l().field_70165_t - hook.field_70165_t;
                double d6 = hook.func_190619_l().field_70163_u - hook.field_70163_u;
                double d7 = hook.func_190619_l().field_70161_v - hook.field_70161_v;
                double d8 = MathHelper.func_76133_a((double)(d5 * d5 + d6 * d6 + d7 * d7));
                double d9 = 0.1;
                item.field_70159_w = d5 * d9;
                item.field_70181_x = d6 * d9 + (double)MathHelper.func_76133_a((double)d8) * 0.08;
                item.field_70179_y = d7 * d9;
                hook.field_70170_p.func_72838_d((Entity)item);
                hook.func_190619_l().field_70170_p.func_72838_d((Entity)new EntityXPOrb(hook.func_190619_l().field_70170_p, hook.func_190619_l().field_70165_t, hook.func_190619_l().field_70163_u + 0.5, hook.func_190619_l().field_70161_v + 0.5, evt.getEntityPlayer().func_70681_au().nextInt(6) + 1));
            }
        }
    }

    private ItemStack getFishingLoot(World world, EntityPlayer player) {
        if (!world.field_72995_K && player.func_70681_au().nextDouble() <= (double)SkillRegistry.getSkillLevel(player, FISHBONUS) * 0.05) {
            LootContext.Builder build = new LootContext.Builder((WorldServer)world);
            build.func_186469_a((float)EnchantmentHelper.func_185284_a((Enchantment)Enchantment.func_180305_b((String)"luck_of_the_sea"), (EntityLivingBase)player) + player.func_184817_da());
            return ((ItemStack)Library.getLootManager().getLootTableFromLocation(new ResourceLocation("levelup", "fishing/fishing_loot")).func_186462_a(player.func_70681_au(), build.func_186471_a()).get(0)).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    @SubscribeEvent
    public void registerTileCapability(AttachCapabilitiesEvent<TileEntity> evt) {
        if (evt.getObject() instanceof TileEntityFurnace) {
            final TileEntityFurnace furnace = (TileEntityFurnace)evt.getObject();
            evt.addCapability(FURNACEMODS, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IProcessor instance;
                {
                    this.instance = new CapabilityFurnace(furnace);
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == PlayerCapability.MACHINE_PROCESSING;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == PlayerCapability.MACHINE_PROCESSING ? PlayerCapability.MACHINE_PROCESSING.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)PlayerCapability.MACHINE_PROCESSING.getStorage().writeNBT(PlayerCapability.MACHINE_PROCESSING, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound tag) {
                    PlayerCapability.MACHINE_PROCESSING.getStorage().readNBT(PlayerCapability.MACHINE_PROCESSING, (Object)this.instance, null, (NBTBase)tag);
                }
            });
        } else if (evt.getObject() instanceof TileEntityBrewingStand) {
            final TileEntityBrewingStand stand = (TileEntityBrewingStand)evt.getObject();
            evt.addCapability(FURNACEMODS, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                IProcessor instance;
                {
                    this.instance = new CapabilityBrewingStand(stand);
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == PlayerCapability.MACHINE_PROCESSING;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == PlayerCapability.MACHINE_PROCESSING ? PlayerCapability.MACHINE_PROCESSING.cast((Object)this.instance) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)PlayerCapability.MACHINE_PROCESSING.getStorage().writeNBT(PlayerCapability.MACHINE_PROCESSING, (Object)this.instance, null);
                }

                public void deserializeNBT(NBTTagCompound tag) {
                    PlayerCapability.MACHINE_PROCESSING.getStorage().readNBT(PlayerCapability.MACHINE_PROCESSING, (Object)this.instance, null, (NBTBase)tag);
                }
            });
        }
    }

    @SubscribeEvent
    public void onTileInteracted(PlayerInteractEvent.RightClickBlock evt) {
        if (!evt.getWorld().field_72995_K && evt.getEntityPlayer() != null) {
            IProcessor cap;
            EntityPlayer player = evt.getEntityPlayer();
            if (player instanceof FakePlayer || !player.func_70093_af() || !evt.getItemStack().func_190926_b()) {
                return;
            }
            TileEntity tile = evt.getWorld().func_175625_s(evt.getPos());
            if (tile != null && tile.hasCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP) && (cap = (IProcessor)tile.getCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP)) != null) {
                String name = UsernameCache.getLastKnownUsername((UUID)player.func_146103_bH().getId());
                if (cap.getPlayerFromUUID() == null) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("levelup.interact.register", new Object[]{name}), true);
                    cap.setUUID(player.func_146103_bH().getId());
                } else if (cap.getPlayerFromUUID().func_146103_bH().getId() == player.func_146103_bH().getId()) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("levelup.interact.unregister", new Object[]{name}), true);
                    cap.setUUID(null);
                } else {
                    name = UsernameCache.getLastKnownUsername((UUID)cap.getPlayerFromUUID().func_146103_bH().getId());
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("levelup.interact.notowned", new Object[]{name}), true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load evt) {
        if (!evt.getWorld().field_72995_K) {
            Map tiles = evt.getChunk().func_177434_r();
            List<TileEntity> toAdd = this.toAdd.get(evt.getWorld().field_73011_w.getDimension());
            for (BlockPos pos : tiles.keySet()) {
                TileEntity tile = evt.getWorld().func_175625_s(pos);
                if (tile == null || !tile.hasCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP)) continue;
                toAdd.add(tile);
            }
        }
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload evt) {
        if (!evt.getWorld().field_72995_K) {
            Map tiles = evt.getChunk().func_177434_r();
            List<TileEntity> toRemove = this.toRemove.get(evt.getWorld().field_73011_w.getDimension());
            List<TileEntity> processors = this.processors.get(evt.getWorld().field_73011_w.getDimension());
            for (TileEntity tile : tiles.values()) {
                if (!processors.contains(tile)) continue;
                toRemove.add(tile);
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load evt) {
        if (!evt.getWorld().field_72995_K) {
            this.processors.put(evt.getWorld().field_73011_w.getDimension(), Lists.newArrayList());
            this.toAdd.put(evt.getWorld().field_73011_w.getDimension(), Lists.newArrayList());
            this.toRemove.put(evt.getWorld().field_73011_w.getDimension(), Lists.newArrayList());
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload evt) {
        if (!evt.getWorld().field_72995_K) {
            this.processors.remove(evt.getWorld().field_73011_w.getDimension());
            this.toAdd.remove(evt.getWorld().field_73011_w.getDimension());
            this.toRemove.remove(evt.getWorld().field_73011_w.getDimension());
        }
    }

    @SubscribeEvent
    public void doFurnaceTicks(TickEvent.WorldTickEvent evt) {
        if (evt.world.field_72995_K || evt.phase == TickEvent.Phase.END || evt.side != Side.SERVER) {
            return;
        }
        if (this.processors.containsKey(evt.world.field_73011_w.getDimension())) {
            List<TileEntity> processors = this.processors.get(evt.world.field_73011_w.getDimension());
            if (evt.world.func_72820_D() % 100L == 0L) {
                List loadedTiles = evt.world.field_147482_g.stream().filter(t -> t.hasCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP)).collect(Collectors.toList());
                for (TileEntity tile : processors) {
                    if (loadedTiles.contains(tile)) continue;
                    this.toRemove.get(evt.world.field_73011_w.getDimension()).add(tile);
                }
                for (TileEntity tile : loadedTiles) {
                    if (processors.contains(tile)) continue;
                    processors.add(tile);
                }
            }
            if (this.toAdd.containsKey(evt.world.field_73011_w.getDimension()) && !this.toAdd.get(evt.world.field_73011_w.getDimension()).isEmpty()) {
                List<TileEntity> toAdd = this.toAdd.get(evt.world.field_73011_w.getDimension());
                processors.addAll(toAdd);
                toAdd.clear();
            }
            if (this.toRemove.containsKey(evt.world.field_73011_w.getDimension()) && !this.toRemove.get(evt.world.field_73011_w.getDimension()).isEmpty()) {
                List<TileEntity> toRemove = this.toRemove.get(evt.world.field_73011_w.getDimension());
                processors.removeAll(toRemove);
                toRemove.clear();
            }
            if (!processors.isEmpty()) {
                for (TileEntity tile : processors) {
                    if (tile == null || !tile.func_145831_w().func_175726_f(tile.func_174877_v()).func_177410_o()) continue;
                    IProcessor p = (IProcessor)tile.getCapability(PlayerCapability.MACHINE_PROCESSING, EnumFacing.UP);
                    this.processTick(p);
                }
            }
        }
    }

    private void processTick(IProcessor tile) {
        if (tile != null && tile.getPlayerFromUUID() != null) {
            tile.extraProcessing(tile.getPlayerFromUUID());
        }
    }
}

