/*
 * Decompiled with CFR 0.152.
 */
package tamaized.tammodized;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tamaized.tammodized.proxy.AbstractProxy;

public abstract class TamModBase {
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;
    public Logger logger;
    private int modEntityID = 0;

    protected abstract AbstractProxy getProxy();

    public abstract String getModID();

    public void FMLpreInit(FMLPreInitializationEvent event) {
        this.logger = LogManager.getLogger((String)this.getModID());
        this.getProxy().preRegisters();
        this.preInit(event);
        this.getProxy().preInit();
    }

    public void FMLinit(FMLInitializationEvent event) {
        this.init(event);
        this.getProxy().init();
    }

    public void FMLpostInit(FMLPostInitializationEvent event) {
        this.postInit(event);
        this.getProxy().postInit();
    }

    protected abstract void preInit(FMLPreInitializationEvent var1);

    protected abstract void init(FMLInitializationEvent var1);

    protected abstract void postInit(FMLPostInitializationEvent var1);

    protected void registerEntity(Class<? extends Entity> entityClass, String entityName, Object mod, String modid, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(modid, entityName), entityClass, (String)(modid + "." + entityName), (int)this.modEntityID, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        ++this.modEntityID;
    }

    protected void registerEntityWithEgg(Class<? extends Entity> entityClass, String entityName, Object mod, String modid, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimaryColor, int eggSecondaryColor) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(modid, entityName), entityClass, (String)(modid + "." + entityName), (int)this.modEntityID, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)eggPrimaryColor, (int)eggSecondaryColor);
        ++this.modEntityID;
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }
}

