/*
 * Decompiled with CFR 0.152.
 */
package tamaized.tammodized.common.blocks;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.registries.IForgeRegistryEntry;
import tamaized.tammodized.registry.ITamRegistry;

public abstract class TamBlockCrops
extends BlockBush
implements IGrowable,
ITamRegistry {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    private final String name;

    public TamBlockCrops(CreativeTabs tab, Material material, String n, float hardness, SoundType sound) {
        this.name = n;
        ModContainer container = Loader.instance().activeModContainer();
        this.func_149663_c(container == null ? this.name : container.getModId().toLowerCase() + "." + this.name);
        this.func_149711_c(hardness);
        this.setRegistryName(this.name);
        this.func_149647_a(tab);
        this.func_149672_a(sound);
    }

    protected static float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, blockpos.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (iblockstate.func_177230_c().isFertile(worldIn, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public String getModelDir() {
        return "crops";
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getBounds()[(Integer)state.func_177229_b((IProperty)this.getAgeProperty())];
    }

    protected abstract AxisAlignedBB[] getBounds();

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(worldIn, pos) && this.func_185514_i(soil) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    protected boolean func_185514_i(IBlockState state) {
        return this.plantableBlocks().contains(state.func_177230_c());
    }

    protected abstract ArrayList<Block> plantableBlocks();

    protected PropertyInteger getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
    }

    public IBlockState withAge(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAgeProperty()) >= this.getMaxAge();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        float f;
        int i;
        super.func_180650_b(worldIn, pos, state, rand);
        if (this.isCorrectLightLevel(worldIn, pos) && (i = this.getAge(state)) < this.getMaxAge() && rand.nextInt((int)(25.0f / (f = TamBlockCrops.getGrowthChance((Block)this, worldIn, pos))) + 1) == 0) {
            worldIn.func_180501_a(pos, this.withAge(i + 1), 2);
        }
    }

    private boolean isCorrectLightLevel(World world, BlockPos pos) {
        int light = 0;
        int a = world.func_175699_k(pos.func_177977_b());
        light = a > light ? a : light;
        a = world.func_175699_k(pos.func_177984_a());
        light = a > light ? a : light;
        a = world.func_175699_k(pos.func_177978_c());
        light = a > light ? a : light;
        a = world.func_175699_k(pos.func_177968_d());
        light = a > light ? a : light;
        a = world.func_175699_k(pos.func_177974_f());
        light = a > light ? a : light;
        a = world.func_175699_k(pos.func_177976_e());
        light = a > light ? a : light;
        return this.isCorrectLightLevel(light);
    }

    protected abstract boolean isCorrectLightLevel(int var1);

    public void grow(World worldIn, BlockPos pos, IBlockState state) {
        int j;
        int i = this.getAge(state) + this.getBonemealAgeIncrease(worldIn, pos, state);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.withAge(i), 2);
    }

    protected int getBonemealAgeIncrease(World worldIn, BlockPos pos, IBlockState state) {
        return this.isCorrectLightLevel(worldIn, pos) ? MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5) : 0;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return this.func_185514_i(soil) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    protected abstract Item getSeed();

    protected abstract Item getCrop();

    @Nullable
    public abstract Item func_180660_a(IBlockState var1, Random var2, int var3);

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.getSeed());
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public abstract boolean func_180670_a(World var1, Random var2, BlockPos var3, IBlockState var4);

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    @Override
    public void registerBlock(RegistryEvent.Register<Block> e) {
        e.getRegistry().register((IForgeRegistryEntry)this);
    }

    @Override
    public void registerItem(RegistryEvent.Register<Item> e) {
        e.getRegistry().register(new ItemBlock((Block)this).setRegistryName(this.name));
    }

    @Override
    public void registerModel(ModelRegistryEvent e) {
        if (this.getRegistryName() != null) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(this.getRegistryName().func_110624_b(), this.getModelDir() + "/" + this.getRegistryName().func_110623_a()), "inventory"));
        }
    }
}

