/*
 * Decompiled with CFR 0.152.
 */
package notenoughroofs.blocks;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import notenoughroofs.ConfigFile;
import notenoughroofs.blocks.BasicBlock;
import notenoughroofs.blocks.OrientableBlock;
import notenoughroofs.blocks.StdBlockInterface;
import notenoughroofs.blocks.TurnableBlock;

public class ModBlocks {
    public static BasicBlock slate = new BasicBlock(Material.field_151576_e, "slate", 8.0f);
    public static BasicBlock copperOre = new BasicBlock(Material.field_151576_e, "copper_ore", 8.0f);
    public static BasicBlock slateTile = new BasicBlock(Material.field_151576_e, "slate_tile", 8.0f);
    public static BasicBlock chimney = new BasicBlock(Material.field_151576_e, "chimney", 8.0f);
    private static String[] roofNames = new String[]{"iron_tiles", "slate_tiles", "terracotta", "copper_tiles"};
    private static String[] basicNames = new String[]{"brick", "planks_acacia", "planks_big_oak", "planks_birch", "planks_jungle", "planks_oak", "planks_spruce", "stonebrick"};
    private static String[] vanillaNames = new String[]{"bone_block_side", "bookshelf", "clay", "coal_block", "coarse_dirt", "cobblestone", "cobblestone_mossy", "diamond_block", "dirt", "dirt_podzol_side", "emerald_block", "end_bricks", "end_stone", "gold_block", "gravel", "hardened_clay", "hardened_clay_stained_black", "hardened_clay_stained_blue", "hardened_clay_stained_brown", "hardened_clay_stained_cyan", "hardened_clay_stained_gray", "hardened_clay_stained_green", "hardened_clay_stained_light_blue", "hardened_clay_stained_lime", "hardened_clay_stained_magenta", "hardened_clay_stained_orange", "hardened_clay_stained_pink", "hardened_clay_stained_purple", "hardened_clay_stained_red", "hardened_clay_stained_silver", "hardened_clay_stained_white", "hardened_clay_stained_yellow", "iron_block", "lapis_block", "log_acacia", "log_big_oak", "log_birch", "log_jungle", "log_oak", "log_spruce", "nether_brick", "netherrack", "obsidian", "prismarine_bricks", "prismarine_dark", "purpur_block", "quartz_block_side", "red_nether_brick", "red_sand", "red_sandstone_carved", "red_sandstone_normal", "red_sandstone_smooth", "sand", "sandstone_carved", "sandstone_normal", "sandstone_smooth", "soul_sand", "sponge", "stone", "stone_andesite", "stone_andesite_smooth", "stone_diorite", "stone_diorite_smooth", "stone_granite", "stone_granite_smooth", "stonebrick_mossy", "wool_colored_black", "wool_colored_blue", "wool_colored_brown", "wool_colored_cyan", "wool_colored_gray", "wool_colored_green", "wool_colored_light_blue", "wool_colored_lime", "wool_colored_magenta", "wool_colored_orange", "wool_colored_pink", "wool_colored_purple", "wool_colored_red", "wool_colored_silver", "wool_colored_white", "wool_colored_yellow"};
    private static Map<String, Block> basicStringMapping = new HashMap<String, Block>();
    private static Map<String, Block> vanillaStringMapping = new HashMap<String, Block>();
    private static List<Block> blocks;

    public static void init() {
        for (String top : roofNames) {
            for (String base : basicNames) {
                blocks.add((Block)new OrientableBlock(basicStringMapping.get(base).func_176223_P(), top + "_" + base));
                blocks.add(new TurnableBlock(basicStringMapping.get(base).func_176223_P(), top + "_conn_" + base));
            }
        }
        if (ConfigFile.genVanillaMinecraftBases) {
            for (String top : roofNames) {
                for (String base : vanillaNames) {
                    blocks.add((Block)new OrientableBlock(vanillaStringMapping.get(base).func_176223_P(), top + "_" + base));
                    blocks.add(new TurnableBlock(vanillaStringMapping.get(base).func_176223_P(), top + "_conn_" + base));
                }
            }
        }
    }

    public static void register(IForgeRegistry<Block> registry) {
        registry.register((IForgeRegistryEntry)slate);
        registry.register((IForgeRegistryEntry)copperOre);
        registry.register((IForgeRegistryEntry)slateTile);
        registry.register((IForgeRegistryEntry)chimney);
        Block[] blockArray = new Block[blocks.size()];
        for (int i = 0; i < blocks.size(); ++i) {
            blockArray[i] = blocks.get(i);
        }
        registry.registerAll((IForgeRegistryEntry[])blockArray);
    }

    public static void registerItemBlocks(IForgeRegistry<Item> registry) {
        registry.register((IForgeRegistryEntry)slate.createItemBlock());
        registry.register((IForgeRegistryEntry)copperOre.createItemBlock());
        registry.register((IForgeRegistryEntry)slateTile.createItemBlock());
        registry.register((IForgeRegistryEntry)chimney.createItemBlock());
        Item[] itemBlocks = new Item[blocks.size()];
        for (int i = 0; i < itemBlocks.length; ++i) {
            itemBlocks[i] = ((StdBlockInterface)blocks.get(i)).createItemBlock();
        }
        registry.registerAll((IForgeRegistryEntry[])itemBlocks);
    }

    public static void registerModels() {
        slate.registerItemModel(Item.func_150898_a((Block)slate));
        copperOre.registerItemModel(Item.func_150898_a((Block)copperOre));
        slateTile.registerItemModel(Item.func_150898_a((Block)slateTile));
        chimney.registerItemModel(Item.func_150898_a((Block)chimney));
        for (int i = 0; i < blocks.size(); ++i) {
            StdBlockInterface block = (StdBlockInterface)blocks.get(i);
            block.registerItemModel(Item.func_150898_a((Block)blocks.get(i)));
        }
    }

    static {
        basicStringMapping.put("brick", Blocks.field_150336_V);
        basicStringMapping.put("planks_acacia", Blocks.field_150344_f);
        basicStringMapping.put("planks_big_oak", Blocks.field_150344_f);
        basicStringMapping.put("planks_birch", Blocks.field_150344_f);
        basicStringMapping.put("planks_jungle", Blocks.field_150344_f);
        basicStringMapping.put("planks_oak", Blocks.field_150344_f);
        basicStringMapping.put("planks_spruce", Blocks.field_150344_f);
        basicStringMapping.put("stonebrick", Blocks.field_150417_aV);
        vanillaStringMapping.put("bone_block_side", Blocks.field_189880_di);
        vanillaStringMapping.put("bookshelf", Blocks.field_150342_X);
        vanillaStringMapping.put("clay", Blocks.field_150435_aG);
        vanillaStringMapping.put("coal_block", Blocks.field_150402_ci);
        vanillaStringMapping.put("coarse_dirt", Blocks.field_150346_d);
        vanillaStringMapping.put("cobblestone", Blocks.field_150347_e);
        vanillaStringMapping.put("cobblestone_mossy", Blocks.field_150341_Y);
        vanillaStringMapping.put("diamond_block", Blocks.field_150484_ah);
        vanillaStringMapping.put("dirt", Blocks.field_150346_d);
        vanillaStringMapping.put("dirt_podzol_side", Blocks.field_150346_d);
        vanillaStringMapping.put("emerald_block", Blocks.field_150475_bE);
        vanillaStringMapping.put("end_bricks", Blocks.field_185772_cY);
        vanillaStringMapping.put("end_stone", Blocks.field_150377_bs);
        vanillaStringMapping.put("gold_block", Blocks.field_150340_R);
        vanillaStringMapping.put("gravel", Blocks.field_150351_n);
        vanillaStringMapping.put("hardened_clay", Blocks.field_150405_ch);
        vanillaStringMapping.put("hardened_clay_stained_black", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_blue", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_brown", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_cyan", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_gray", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_green", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_light_blue", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_lime", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_magenta", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_orange", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_pink", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_purple", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_red", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_silver", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_white", Blocks.field_150406_ce);
        vanillaStringMapping.put("hardened_clay_stained_yellow", Blocks.field_150406_ce);
        vanillaStringMapping.put("iron_block", Blocks.field_150339_S);
        vanillaStringMapping.put("lapis_block", Blocks.field_150368_y);
        vanillaStringMapping.put("log_acacia", Blocks.field_150364_r);
        vanillaStringMapping.put("log_big_oak", Blocks.field_150364_r);
        vanillaStringMapping.put("log_birch", Blocks.field_150364_r);
        vanillaStringMapping.put("log_jungle", Blocks.field_150364_r);
        vanillaStringMapping.put("log_oak", Blocks.field_150364_r);
        vanillaStringMapping.put("log_spruce", Blocks.field_150364_r);
        vanillaStringMapping.put("nether_brick", Blocks.field_150385_bj);
        vanillaStringMapping.put("netherrack", Blocks.field_150424_aL);
        vanillaStringMapping.put("obsidian", Blocks.field_150343_Z);
        vanillaStringMapping.put("prismarine_bricks", Blocks.field_180397_cI);
        vanillaStringMapping.put("prismarine_dark", Blocks.field_180397_cI);
        vanillaStringMapping.put("purpur_block", Blocks.field_185767_cT);
        vanillaStringMapping.put("quartz_block_side", Blocks.field_150371_ca);
        vanillaStringMapping.put("red_nether_brick", Blocks.field_189879_dh);
        vanillaStringMapping.put("red_sand", (Block)Blocks.field_150354_m);
        vanillaStringMapping.put("red_sandstone_carved", Blocks.field_180395_cM);
        vanillaStringMapping.put("red_sandstone_normal", Blocks.field_180395_cM);
        vanillaStringMapping.put("red_sandstone_smooth", Blocks.field_180395_cM);
        vanillaStringMapping.put("sand", (Block)Blocks.field_150354_m);
        vanillaStringMapping.put("sandstone_carved", Blocks.field_150322_A);
        vanillaStringMapping.put("sandstone_normal", Blocks.field_150322_A);
        vanillaStringMapping.put("sandstone_smooth", Blocks.field_150322_A);
        vanillaStringMapping.put("soul_sand", Blocks.field_150425_aM);
        vanillaStringMapping.put("sponge", Blocks.field_150360_v);
        vanillaStringMapping.put("stone", Blocks.field_150348_b);
        vanillaStringMapping.put("stone_andesite", Blocks.field_150348_b);
        vanillaStringMapping.put("stone_andesite_smooth", Blocks.field_150348_b);
        vanillaStringMapping.put("stone_diorite", Blocks.field_150348_b);
        vanillaStringMapping.put("stone_diorite_smooth", Blocks.field_150348_b);
        vanillaStringMapping.put("stone_granite", Blocks.field_150348_b);
        vanillaStringMapping.put("stone_granite_smooth", Blocks.field_150348_b);
        vanillaStringMapping.put("stonebrick_mossy", Blocks.field_150417_aV);
        vanillaStringMapping.put("wool_colored_black", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_blue", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_brown", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_cyan", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_gray", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_green", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_light_blue", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_lime", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_magenta", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_orange", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_pink", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_purple", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_red", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_silver", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_white", Blocks.field_150325_L);
        vanillaStringMapping.put("wool_colored_yellow", Blocks.field_150325_L);
        blocks = new LinkedList<Block>();
    }
}

