/*
 * Decompiled with CFR 0.152.
 */
package notenoughroofs.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import notenoughroofs.blocks.BasicBlock;

public class TurnableBlock
extends BasicBlock {
    public static final PropertyEnum<EnumAttachPosition> NORTH = PropertyEnum.func_177709_a((String)"north", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> EAST = PropertyEnum.func_177709_a((String)"east", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> SOUTH = PropertyEnum.func_177709_a((String)"south", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> WEST = PropertyEnum.func_177709_a((String)"west", EnumAttachPosition.class);
    protected static final AxisAlignedBB AABB_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private final Block baseBlock;

    protected TurnableBlock(IBlockState blockState, String name) {
        super(blockState.func_177230_c().func_149688_o(blockState), name, blockState.func_177230_c().func_176195_g(blockState, null, null));
        this.baseBlock = blockState.func_177230_c();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(NORTH, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(EAST, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(SOUTH, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(WEST, (Comparable)((Object)EnumAttachPosition.NONE)));
        this.field_149786_r = 0;
        this.field_149783_u = false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_BOX;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = state.func_177226_a(WEST, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.WEST)));
        state = state.func_177226_a(EAST, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.EAST)));
        state = state.func_177226_a(NORTH, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.NORTH)));
        state = state.func_177226_a(SOUTH, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.SOUTH)));
        return state;
    }

    private EnumAttachPosition getAttachPosition(IBlockAccess worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        if (TurnableBlock.canConnectTo(worldIn.func_180495_p(blockpos), direction, worldIn, blockpos)) {
            return EnumAttachPosition.SIDE;
        }
        return EnumAttachPosition.NONE;
    }

    protected static boolean canConnectTo(IBlockState blockState, @Nullable EnumFacing side, IBlockAccess world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return block != Blocks.field_150350_a && blockState.func_185915_l() || block.getClass() == TurnableBlock.class;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyTurnableNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                    this.notifyTurnableNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyTurnableNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyTurnableNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                    this.notifyTurnableNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyTurnableNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    private void notifyTurnableNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_175685_c(pos, (Block)this, false);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && !this.func_176196_c(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a(NORTH, state.func_177229_b(SOUTH)).func_177226_a(EAST, state.func_177229_b(WEST)).func_177226_a(SOUTH, state.func_177229_b(NORTH)).func_177226_a(WEST, state.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a(NORTH, state.func_177229_b(EAST)).func_177226_a(EAST, state.func_177229_b(SOUTH)).func_177226_a(SOUTH, state.func_177229_b(WEST)).func_177226_a(WEST, state.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a(NORTH, state.func_177229_b(WEST)).func_177226_a(EAST, state.func_177229_b(NORTH)).func_177226_a(SOUTH, state.func_177229_b(EAST)).func_177226_a(WEST, state.func_177229_b(SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a(NORTH, state.func_177229_b(SOUTH)).func_177226_a(SOUTH, state.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a(EAST, state.func_177229_b(WEST)).func_177226_a(WEST, state.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST});
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Item.func_150898_a((Block)state.func_177230_c());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    static enum EnumAttachPosition implements IStringSerializable
    {
        SIDE("side"),
        NONE("none");

        private final String name;

        private EnumAttachPosition(String name) {
            this.name = name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

