/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.block.multiblock;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.block.multiblock.IMultiBlockComponent;
import com.infinityraider.infinitylib.block.multiblock.IMultiBlockManager;
import com.infinityraider.infinitylib.block.multiblock.MultiBlockPartData;
import com.infinityraider.infinitylib.utility.CoordinateIterator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MultiBlockManager
implements IMultiBlockManager<MultiBlockPartData> {
    public static final MultiBlockManager INSTANCE = new MultiBlockManager();

    @Override
    public void onBlockPlaced(World world, BlockPos pos, IMultiBlockComponent component) {
        boolean flag = false;
        for (EnumFacing dir : EnumFacing.values()) {
            IMultiBlockComponent componentAt;
            TileEntity te = world.func_175625_s(pos.func_177972_a(dir));
            if (te == null || !(te instanceof IMultiBlockComponent) || !component.isValidComponent((IMultiBlockComponent)te) || !this.canCheckForMultiBlock(componentAt = (IMultiBlockComponent)te)) continue;
            if (this.checkForMultiBlock(world, pos.func_177972_a(dir), componentAt)) {
                return;
            }
            flag = true;
        }
        if (!flag) {
            this.checkForMultiBlock(world, pos, component);
        }
    }

    @Override
    public void onBlockBroken(World world, BlockPos pos, IMultiBlockComponent<? extends IMultiBlockManager<MultiBlockPartData>, MultiBlockPartData> component) {
        component.getMainComponent().preMultiBlockBreak();
        MultiBlockPartData data = component.getMultiBlockData();
        this.breakAllMultiBlocksInRange(world, pos.func_177958_n() - data.posX(), pos.func_177956_o() - data.posY(), pos.func_177952_p() - data.posZ(), pos.func_177958_n() + data.sizeX(), pos.func_177956_o() + data.sizeY(), pos.func_177952_p() + data.sizeZ());
    }

    @Override
    public void createMultiBlock(World world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        this.createMultiBlock(world, new BlockPos(xMin, yMin, zMin), xMax - xMin, yMax - yMin, zMax - zMin);
    }

    public void createMultiBlock(World world, BlockPos pos, int sizeX, int sizeY, int sizeZ) {
        IMultiBlockComponent component = (IMultiBlockComponent)world.func_175625_s(pos);
        component.preMultiBlockCreation(sizeX, sizeY, sizeZ);
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    component = (IMultiBlockComponent)world.func_175625_s(pos.func_177982_a(x, y, z));
                    component.setMultiBlockPartData(new MultiBlockPartData(x, y, z, sizeX, sizeY, sizeZ));
                }
            }
        }
        if (world.field_72995_K) {
            world.func_175704_b(pos, pos.func_177982_a(sizeX, sizeY, sizeZ));
        }
        component = (IMultiBlockComponent)world.func_175625_s(pos);
        component.postMultiBlockCreation();
    }

    private boolean canCheckForMultiBlock(IMultiBlockComponent component) {
        return component.getMultiBlockData().size() > 1;
    }

    private boolean checkForMultiBlock(World world, BlockPos pos, IMultiBlockComponent component) {
        IMultiBlockComponent rootComponent = component.getMainComponent();
        if (rootComponent != component) {
            Object data = component.getMultiBlockData();
            return this.checkForMultiBlock(world, pos.func_177982_a(-data.posX(), -data.posY(), -data.posZ()), rootComponent);
        }
        CoordinateIterator iterator = new CoordinateIterator();
        int xOffsetMin = this.calculateDimensionOffsetBackwards(world, pos, component, iterator.setX());
        int yOffsetMin = this.calculateDimensionOffsetBackwards(world, pos, component, iterator.setY());
        int zOffsetMin = this.calculateDimensionOffsetBackwards(world, pos, component, iterator.setZ());
        int xOffsetPlus = this.calculateDimensionOffsetForwards(world, pos, component, iterator.setX());
        int yOffsetPlus = this.calculateDimensionOffsetForwards(world, pos, component, iterator.setY());
        int zOffsetPlus = this.calculateDimensionOffsetForwards(world, pos, component, iterator.setZ());
        if (!this.areAllBlocksInRangeValidComponents(world, pos.func_177958_n() - xOffsetMin, pos.func_177956_o() - yOffsetMin, pos.func_177952_p() - zOffsetMin, pos.func_177958_n() + xOffsetPlus, pos.func_177956_o() + yOffsetPlus, pos.func_177952_p() + zOffsetPlus, component)) {
            return false;
        }
        IMultiBlockComponent newRoot = (IMultiBlockComponent)world.func_175625_s(pos.func_177982_a(-xOffsetMin, -yOffsetMin, -zOffsetMin));
        int xSizeNew = xOffsetPlus + xOffsetMin;
        int ySizeNew = yOffsetPlus + yOffsetMin;
        int zSizeNew = zOffsetPlus + zOffsetMin;
        Object data = component.getMultiBlockData();
        if (component == newRoot && xSizeNew == data.sizeX() && ySizeNew == data.sizeY() && zSizeNew == data.sizeZ()) {
            return false;
        }
        this.createMultiBlock(world, pos.func_177958_n() - xOffsetMin, pos.func_177956_o() - yOffsetMin, pos.func_177952_p() - zOffsetMin, pos.func_177958_n() + xOffsetPlus, pos.func_177956_o() + yOffsetPlus, pos.func_177952_p() + zOffsetPlus);
        return true;
    }

    private int calculateDimensionOffsetBackwards(World world, BlockPos pos, IMultiBlockComponent component, CoordinateIterator it) {
        if (!it.isActive()) {
            InfinityLib.instance.getLogger().debug("ERROR WHEN ITERATING COORDINATES: ITERATOR NOT ACTIVE", new Object[0]);
            return 0;
        }
        Object data = component.getMultiBlockData();
        int x = pos.func_177958_n() - data.posX();
        int y = pos.func_177956_o() - data.posY();
        int z = pos.func_177952_p() - data.posZ();
        do {
            it.increment();
        } while (this.isValidComponent(world, x - it.x(), y - it.y(), z - it.z(), component));
        return it.getOffset() - 1;
    }

    private int calculateDimensionOffsetForwards(World world, BlockPos pos, IMultiBlockComponent component, CoordinateIterator it) {
        if (!it.isActive()) {
            InfinityLib.instance.getLogger().debug("ERROR WHEN ITERATING COORDINATES: ITERATOR NOT ACTIVE", new Object[0]);
            return 0;
        }
        Object data = component.getMultiBlockData();
        int x = pos.func_177958_n() - data.posX();
        int y = pos.func_177956_o() - data.posY();
        int z = pos.func_177952_p() - data.posZ();
        do {
            it.increment();
        } while (this.isValidComponent(world, x + it.x(), y + it.y(), z + it.z(), component));
        return it.getOffset();
    }

    private boolean areAllBlocksInRangeValidComponents(World world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IMultiBlockComponent component) {
        for (int x = xMin; x < xMax; ++x) {
            for (int y = yMin; y < yMax; ++y) {
                for (int z = zMin; z < zMax; ++z) {
                    if (this.isValidComponent(world, x, y, z, component)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isValidComponent(World world, int x, int y, int z, IMultiBlockComponent component) {
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        return te != null && te instanceof IMultiBlockComponent && component.isValidComponent((IMultiBlockComponent)te);
    }

    private void breakAllMultiBlocksInRange(World world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        for (int x = xMin; x < xMax; ++x) {
            for (int y = yMin; y < yMax; ++y) {
                for (int z = zMin; z < zMax; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    TileEntity te = world.func_175625_s(pos);
                    if (te == null || !(te instanceof IMultiBlockComponent)) continue;
                    IMultiBlockComponent component = (IMultiBlockComponent)te;
                    component.setMultiBlockPartData(new MultiBlockPartData(0, 0, 0, 1, 1, 1));
                    component.postMultiBlockBreak();
                }
            }
        }
    }
}

