/*
 * Decompiled with CFR 0.152.
 */
package scavengePlugins.reSkillable;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.skill.Skill;
import com.google.gson.JsonObject;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import scavenge.api.autodoc.BaseElement;
import scavenge.api.autodoc.ChoiceElement;
import scavenge.api.autodoc.IntElement;
import scavenge.api.autodoc.MapElement;
import scavenge.api.autodoc.TextElement;
import scavenge.api.block.IResourceCondition;
import scavenge.api.block.IResourceFactory;
import scavenge.api.block.IResourceProperty;
import scavenge.api.block.impl.BaseResourceFactory;
import scavenge.api.block.impl.BaseResourceProperty;
import scavenge.api.math.IMathOperation;
import scavenge.api.utils.JsonUtil;
import scavenge.core.math.operation.BiggerEqualsOperation;

public class PropPlayerHasSkill
extends BaseResourceProperty
implements IResourceCondition {
    Skill skill;
    IMathOperation operation;

    public PropPlayerHasSkill(JsonObject obj) {
        super(obj, "require_re_Skill");
        this.skill = (Skill)ReskillableRegistries.SKILLS.getValue(new ResourceLocation(obj.get("name").getAsString()));
        if (this.skill == null) {
            throw new RuntimeException("Skill [" + obj.get("name").getAsString() + "] returns a Null. That is not allowed");
        }
        if (obj.has("operations")) {
            this.operation = JsonUtil.getMathOperation((String)"operations", (JsonObject)obj);
            this.setJEIInfo(JsonUtil.getOrDefault((JsonObject)obj, (String)"jeiDesc", (String)""));
        } else {
            int level = JsonUtil.getOrDefault((JsonObject)obj, (String)"level", (int)0);
            this.operation = new BiggerEqualsOperation((long)level);
            this.setJEIInfo("Players [" + this.skill.getName() + "] has to be bigger then Level " + level);
        }
    }

    public boolean canInteract(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean leftClick, EnumFacing side, String resourceID, boolean client) {
        return this.operation.matches((long)PlayerDataHandler.get((EntityPlayer)player).getSkillInfo(this.skill).getLevel());
    }

    public static class PlayerHasSkillFactory
    extends BaseResourceFactory {
        public PlayerHasSkillFactory() {
            super("require_re_Skill", IResourceFactory.PropertyType.Condition);
        }

        public IResourceProperty createObject(JsonObject obj) {
            return new PropPlayerHasSkill(obj);
        }

        public void addExample(JsonObject obj) {
            obj.addProperty("name", "attack");
            obj.addProperty("level", (Number)10);
        }

        public MapElement getDocumentation() {
            MapElement map = super.getDocumentation();
            map.setDescription("Allows to check if a Player has a Certain Skill");
            map.addElement(new TextElement("name", "").setDescription("The Skill that is being checkt for"));
            ChoiceElement choice = new ChoiceElement("", 2);
            choice.addElement(0, (BaseElement)new IntElement("level", 0, "Which level or bigger is required"));
            this.addDefaultOperationText(choice, 1);
            return map;
        }
    }
}

