/*
 * Decompiled with CFR 0.152.
 */
package me.ferdz.placeableitems.block;

import me.ferdz.placeableitems.block.BlockBiEdible;
import me.ferdz.placeableitems.block.BlockBiPosition;
import me.ferdz.placeableitems.block.IBlockBiPosition;
import me.ferdz.placeableitems.state.EnumUpDown;
import me.ferdz.placeableitems.tileentity.TEEdibleBiPosition;
import me.ferdz.placeableitems.utils.BiPositionUtils;
import me.ferdz.placeableitems.utils.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBiPositionBiEdible
extends BlockBiEdible
implements IBlockBiPosition {
    public BlockBiPositionBiEdible(String name, Item rawItem, int rawFoodLevel, float rawSaturation, Item cookedItem, int cookedFoodLevel, float cookedSaturation) {
        super(name, rawItem, rawFoodLevel, rawSaturation, cookedItem, cookedFoodLevel, cookedSaturation);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB box = super.func_185496_a(state, source, pos);
        TileEntity te = source.func_175625_s(pos);
        if (te instanceof TEEdibleBiPosition) {
            return BiPositionUtils.getReverseBound(box, ((TEEdibleBiPosition)te).getPosition());
        }
        return box;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return true;
        }
        return Utils.isValidBlock((IBlockAccess)worldIn, pos.func_177973_b(new Vec3i(0, 1, 0)));
    }

    @Override
    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        EnumUpDown upDown = BiPositionUtils.getPosition(te, state);
        return BiPositionUtils.canBlockStay(upDown, (IBlockAccess)world, pos);
    }

    @Override
    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    @Override
    public void onBlockPlacedBySide(EnumFacing side, BlockPos pos, EntityPlayer player, World world) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TEEdibleBiPosition) {
            if (side == EnumFacing.DOWN) {
                ((TEEdibleBiPosition)te).setPosition(EnumUpDown.UP);
            } else {
                ((TEEdibleBiPosition)te).setPosition(EnumUpDown.DOWN);
            }
        }
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = super.func_176221_a(state, worldIn, pos);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TEEdibleBiPosition) {
            TEEdibleBiPosition te2 = (TEEdibleBiPosition)te;
            return state.func_177226_a(BlockBiPosition.POSITION, (Comparable)((Object)te2.getPosition()));
        }
        return state;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PLATED, BlockBiPosition.POSITION, TYPE, FACING});
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TEEdibleBiPosition();
    }
}

