/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.command;

import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.cli.CommandLine;
import com.someguyssoftware.treasure2.cli.DefaultParser;
import com.someguyssoftware.treasure2.cli.Options;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.enums.WorldGenerators;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.chest.IChestGenerator;
import com.someguyssoftware.treasure2.worldgen.SurfaceChestWorldGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnPitCommand
extends CommandBase {
    private static final String RARITY_ARG = "rarity";

    public String func_71517_b() {
        return "t2-pit";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/t2-pit <x> <y> <z> [-rarity <rarity>]: spawns a Treasure! pit at location (x,y,z)";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) {
        Treasure.logger.debug("Starting to build Treasure! pit ...");
        try {
            int z = 0;
            int x = Integer.parseInt(args[0]);
            int y = Integer.parseInt(args[1]);
            z = Integer.parseInt(args[2]);
            String[] parserArgs = Arrays.copyOfRange(args, 3, args.length);
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption(RARITY_ARG, true, "");
            CommandLine line = parser.parse(options, parserArgs);
            Rarity rarity = Rarity.COMMON;
            if (line.hasOption(RARITY_ARG)) {
                String rarityArg = line.getOptionValue(RARITY_ARG);
                rarity = Rarity.valueOf(rarityArg.toUpperCase());
            }
            Treasure.logger.debug("Rarity:" + rarity + "; " + rarity.ordinal());
            World world = commandSender.func_130014_f_();
            Random random = new Random();
            GeneratorResult<ChestGeneratorData> result = SurfaceChestWorldGenerator.generatePit(world, random, rarity, new Coords(x, y, z), TreasureConfig.CHESTS.surfaceChests.configMap.get(rarity));
            if (result.isSuccess()) {
                SurfaceChestWorldGenerator chestGens = (SurfaceChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.SURFACE_CHEST);
                IChestGenerator gen = chestGens.getChestGenMap().get(rarity).next();
                ICoords chestCoords = result.getData().getChestContext().getCoords();
                if (chestCoords != null) {
                    GeneratorResult<ChestGeneratorData> generatorResult = gen.generate(world, random, chestCoords, rarity, result.getData().getChestContext().getState());
                }
            }
        }
        catch (Exception e) {
            Treasure.logger.error("Error generating Treasure! chest:", (Throwable)e);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length > 3 && args[args.length - 2].equals("-rarity")) {
            return SpawnPitCommand.func_175762_a((String[])args, Rarity.getNames());
        }
        return Collections.emptyList();
    }
}

