/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.command;

import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.cli.CommandLine;
import com.someguyssoftware.treasure2.cli.DefaultParser;
import com.someguyssoftware.treasure2.cli.Options;
import com.someguyssoftware.treasure2.enums.PitTypes;
import com.someguyssoftware.treasure2.enums.Pits;
import com.someguyssoftware.treasure2.generator.pit.IPitGenerator;
import com.someguyssoftware.treasure2.worldgen.SurfaceChestWorldGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpawnPitStructureOnlyCommand
extends CommandBase {
    private static final String PIT_TYPE_ARG = "pit";

    public String func_71517_b() {
        return "t2-pitstructureonly";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/t2-pitstructureonly <x> <y> <z> [-pit <type>]: spawns a Treasure! pit structure at location (x,y,z)";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) {
        Treasure.logger.debug("Starting to build Treasure! pit structure only...");
        World world = commandSender.func_130014_f_();
        Random random = new Random();
        try {
            int z = 0;
            int x = Integer.parseInt(args[0]);
            int y = Integer.parseInt(args[1]);
            z = Integer.parseInt(args[2]);
            String[] parserArgs = Arrays.copyOfRange(args, 3, args.length);
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption(PIT_TYPE_ARG, true, "");
            CommandLine line = parser.parse(options, parserArgs);
            Pits pit = null;
            if (line.hasOption(PIT_TYPE_ARG)) {
                String pitType = line.getOptionValue(PIT_TYPE_ARG);
                pit = Pits.valueOf(pitType.toUpperCase());
            } else {
                pit = Pits.values()[random.nextInt(Pits.values().length)];
            }
            Treasure.logger.debug("pit -> {}", (Object)pit);
            Coords spawnCoords = new Coords(x, y, z);
            ICoords surfaceCoords = WorldInfo.getDryLandSurfaceCoords(world, new Coords(x, WorldInfo.getHeightValue(world, spawnCoords), z));
            Treasure.logger.debug("spawn coords -> {}", (Object)spawnCoords.toShortString());
            Treasure.logger.debug("surface coords -> {}", (Object)surfaceCoords.toShortString());
            Map pitGenMap = SurfaceChestWorldGenerator.pitGens.row((Object)PitTypes.STRUCTURE);
            Treasure.logger.debug("pitGenMap.size -> {}", (Object)pitGenMap.size());
            IPitGenerator pitGenerator = (IPitGenerator)pitGenMap.get(pit);
            Treasure.logger.debug("pitGen -> {}", (Object)pitGenerator);
            pitGenerator.generate(world, random, surfaceCoords, spawnCoords);
        }
        catch (Exception e) {
            Treasure.logger.error("Error generating Treasure! pit structure:", (Throwable)e);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length > 3 && args[args.length - 2].equals("-pit")) {
            return SpawnPitStructureOnlyCommand.func_175762_a((String[])args, Pits.getNames());
        }
        return Collections.emptyList();
    }
}

