/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.command;

import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.cli.CommandLine;
import com.someguyssoftware.treasure2.cli.DefaultParser;
import com.someguyssoftware.treasure2.cli.Options;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.generator.GeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.IGeneratorResult;
import com.someguyssoftware.treasure2.generator.well.WellGenerator;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SpawnWellStructureCommand
extends CommandBase {
    private static final String MOD_ID_ARG = "modid";
    private static final String NAME_ARG = "name";

    public String func_71517_b() {
        return "t2-well";
    }

    public String func_71518_a(ICommandSender var1) {
        return "/t2-well <x> <y> <z> [-modid <mod id> -name <name>]: spawns a Treasure! wishing well at location (x,y,z)";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) {
        Treasure.logger.debug("Starting to build Treasure! well ...");
        World world = commandSender.func_130014_f_();
        Random random = new Random();
        try {
            String name;
            int z = 0;
            int x = Integer.parseInt(args[0]);
            int y = Integer.parseInt(args[1]);
            z = Integer.parseInt(args[2]);
            String[] parserArgs = Arrays.copyOfRange(args, 3, args.length);
            DefaultParser parser = new DefaultParser();
            Options options = new Options();
            options.addOption(MOD_ID_ARG, true, "");
            options.addOption(NAME_ARG, true, "");
            CommandLine line = parser.parse(options, parserArgs);
            String modID = "treasure2";
            if (line.hasOption(MOD_ID_ARG)) {
                modID = line.getOptionValue(MOD_ID_ARG);
            }
            if ((name = line.getOptionValue(NAME_ARG)) != null && !name.contains(".nbt")) {
                name = name + ".nbt";
            }
            Coords coords = new Coords(x, y, z);
            WellGenerator gen = new WellGenerator();
            IGeneratorResult result = null;
            if (modID != null && name != null) {
                ResourceLocation templateKey = new ResourceLocation("treasure2:" + Treasure.TEMPLATE_MANAGER.getBaseResourceFolder() + "/" + modID + "/wells/" + name);
                TemplateHolder holder = Treasure.TEMPLATE_MANAGER.getTemplatesByResourceLocationMap().get(templateKey);
                if (holder == null) {
                    Treasure.logger.debug("Unable to locate well template by key -> {}", (Object)templateKey.toString());
                    return;
                }
                result = gen.generate(world, random, coords, holder, TreasureConfig.WELL);
            } else {
                result = gen.generate(world, random, coords, TreasureConfig.WELL);
            }
            Treasure.logger.debug("Well start coords at -> {}", (Object)((GeneratorData)((GeneratorResult)result).getData()).getSpawnCoords().toShortString());
        }
        catch (Exception e) {
            Treasure.logger.error("Error generating Treasure! well:", (Throwable)e);
        }
    }
}

