/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.config;

import com.someguyssoftware.gottschcore.biome.BiomeTypeHolder;
import com.someguyssoftware.treasure2.config.BiomesConfig;
import com.someguyssoftware.treasure2.config.IChestConfig;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.config.Config;

public class ChestConfig
implements IChestConfig {
    @Config.Comment(value={"Enable/Disable generating chests associated with this rarity."})
    @Config.Name(value="00. Enable chests for rarity.")
    @Config.RequiresWorldRestart
    public boolean enableChest = true;
    @Config.Comment(value={"The number of chunks generated before the chest spawn is attempted."})
    @Config.Name(value="01. Chunks per chest spawn:")
    @Config.RangeInt(min=50, max=32000)
    public int chunksPerChest = 75;
    @Config.Comment(value={"The probability that a chest will spawn."})
    @Config.Name(value="02. Probability of chest spawn:")
    @Config.RangeDouble(min=0.0, max=100.0)
    public double genProbability = 50.0;
    @Config.Comment(value={"The minimum depth (y-axis) that a chest can generate at."})
    @Config.Name(value="03. Min. y-value for spawn location:")
    @Config.RangeInt(min=5, max=250)
    public int minYSpawn = 25;
    @Config.Comment(value={"The probability that a chest will be a mimic.", "NOTE: only common Wooden ChestConfig have mimics avaiable."})
    @Config.Name(value="04. Mimic probability:")
    @Config.RangeDouble(min=0.0, max=100.0)
    public double mimicProbability = 0.0;
    @Config.Name(value="05. Enable surface spawn:")
    public boolean surfaceAllowed = true;
    @Config.Name(value="06. Enable subterranean spawn:")
    public boolean subterraneanAllowed = true;
    @Config.Name(value="biomes")
    @Config.Comment(value={"Biome white and black list properties."})
    public BiomesConfig biomes = new BiomesConfig(new String[0], new String[]{"ocean", "deep_ocean", "deep_frozen_ocean", "cold_ocean", "deep_cold_ocean", "lukewarm_ocean", "warm_ocean"}, new String[0], new String[]{"ocean", "deep_ocean"});

    public ChestConfig(boolean isAllowed, int chunksPer, double probability, int minYSpawn, String[] whiteList, String[] blackList, String[] typeWhiteList, String[] typeBlackList) {
        this.enableChest = isAllowed;
        this.chunksPerChest = chunksPer;
        this.genProbability = probability;
        this.minYSpawn = minYSpawn;
        this.biomes = new BiomesConfig(whiteList, blackList, typeWhiteList, typeBlackList);
    }

    @Override
    public void init() {
        this.biomes.init();
    }

    @Override
    public boolean isEnableChest() {
        return this.enableChest;
    }

    @Override
    public int getChunksPerChest() {
        return this.chunksPerChest;
    }

    @Override
    public double getGenProbability() {
        return this.genProbability;
    }

    @Override
    public int getMinYSpawn() {
        return this.minYSpawn;
    }

    @Override
    public boolean isSurfaceAllowed() {
        return this.surfaceAllowed;
    }

    @Override
    public boolean isSubterraneanAllowed() {
        return this.subterraneanAllowed;
    }

    @Override
    public List<BiomeTypeHolder> getBiomeTypeWhiteList() {
        return this.biomes.getTypeWhiteList();
    }

    @Override
    public List<BiomeTypeHolder> getBiomeTypeBlackList() {
        return this.biomes.getTypeBlackList();
    }

    @Override
    public double getMimicProbability() {
        return this.mimicProbability;
    }

    @Override
    public List<Biome> getBiomeWhiteList() {
        return this.biomes.getWhiteList();
    }

    @Override
    public List<Biome> getBiomeBlackList() {
        return this.biomes.getBlackList();
    }
}

