/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.entity.monster;

import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.enums.Rarity;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MimicEntity
extends EntityMob {
    public float lidAngle = 0.0f;
    public float prevLidAngle = 0.0f;
    public boolean isOpening = true;

    public MimicEntity(World world) {
        super(world);
        this.func_70105_a(0.9f, 0.9f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(45.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lidAngle <= 0.0f) {
            this.lidAngle = 0.0f;
            this.isOpening = true;
        }
        if (this.lidAngle >= 1.0f) {
            this.lidAngle = 1.0f;
            this.isOpening = false;
        }
        this.lidAngle = this.isOpening ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187875_gN;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187651_T;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187654_U, 0.15f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        ResourceLocation lootTableResourceLocation = this.selectLootTableResourceLocation(new Random(), Rarity.SCARCE);
        if (lootTableResourceLocation == null) {
            Treasure.logger.warn("Unable to select a lootTable resource location.");
            return null;
        }
        Treasure.logger.debug("Selected loot table resource location -> {}", (Object)lootTableResourceLocation.toString());
        return lootTableResourceLocation;
    }

    protected ResourceLocation selectLootTableResourceLocation(Random random, Rarity chestRarity) {
        ResourceLocation location = null;
        List<ResourceLocation> locations = Treasure.LOOT_TABLES.getLootTableResourceByRarity(chestRarity);
        if (locations != null && !locations.isEmpty()) {
            int index = 0;
            if (locations.size() == 1) {
                location = locations.get(0);
            } else {
                index = RandomHelper.randomInt(random, 0, locations.size() - 1);
                location = locations.get(index);
            }
            Treasure.logger.debug("Selected resource location index --> {}", (Object)index);
        }
        return location;
    }
}

