/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.eventhandler;

import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.block.FogBlock;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.FogType;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerEventHandler {
    private static final String FIRST_JOIN_NBT_KEY = "treasure2.firstjoin";
    private static final String PATCHOULI_MODID = "patchouli";
    private static final String PATCHOULI_GUIDE_BOOK_ID = "patchouli:guide_book";
    private static final String PATCHOULI_GUIDE_TAG_ID = "patchouli:book";
    private static final String TREASURE2_GUIDE_TAG_VALUE = "treasure2:guide";
    private IMod mod;

    public PlayerEventHandler(IMod mod) {
        this.setMod(mod);
    }

    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        NBTTagCompound persistent;
        if (!TreasureConfig.MOD.enableStartingBook) {
            return;
        }
        if (event.player.func_184812_l_()) {
            return;
        }
        NBTTagCompound data = event.player.getEntityData();
        if (!data.func_74764_b("PlayerPersisted")) {
            persistent = new NBTTagCompound();
            data.func_74782_a("PlayerPersisted", (NBTBase)persistent);
        } else {
            persistent = data.func_74775_l("PlayerPersisted");
        }
        if (Loader.isModLoaded((String)PATCHOULI_MODID) && !persistent.func_74764_b(FIRST_JOIN_NBT_KEY)) {
            persistent.func_74757_a(FIRST_JOIN_NBT_KEY, true);
            Item guideBook = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(PATCHOULI_GUIDE_BOOK_ID));
            ItemStack stack = new ItemStack(guideBook);
            if (!stack.func_77942_o()) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a(PATCHOULI_GUIDE_TAG_ID, TREASURE2_GUIDE_TAG_VALUE);
                stack.func_77982_d(tag);
            }
            event.player.field_71071_by.func_70441_a(stack);
        }
    }

    @SubscribeEvent
    public void checkFogInteraction(LivingEvent.LivingUpdateEvent event) {
        if (WorldInfo.isClientSide(event.getEntity().func_130014_f_())) {
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            BlockPos pos = player.func_180425_c();
            Block block = event.getEntity().func_130014_f_().func_180495_p(pos).func_177230_c();
            if (block instanceof FogBlock) {
                PotionEffect potionEffect;
                if (((FogBlock)block).getFogType() == FogType.WITHER) {
                    PotionEffect potionEffect2 = ((EntityLivingBase)event.getEntity()).func_70660_b(MobEffects.field_82731_v);
                    if (potionEffect2 == null) {
                        ((EntityLivingBase)event.getEntity()).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 300, 0));
                    }
                } else if (((FogBlock)block).getFogType() == FogType.POISON && (potionEffect = ((EntityLivingBase)event.getEntity()).func_70660_b(MobEffects.field_76436_u)) == null) {
                    ((EntityLivingBase)event.getEntity()).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 300, 0));
                }
            }
        }
    }

    public IMod getMod() {
        return this.mod;
    }

    public void setMod(IMod mod) {
        this.mod = mod;
    }
}

