/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.chest;

import com.someguyssoftware.gottschcore.loot.LootTable;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.gen.structure.BlockContext;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.IMimicBlock;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.chest.TreasureChestType;
import com.someguyssoftware.treasure2.config.IChestConfig;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.marker.GravestoneMarkerGenerator;
import com.someguyssoftware.treasure2.generator.marker.StructureMarkerGenerator;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public interface IChestGenerator {
    default public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords coords, Rarity rarity, IBlockState state) {
        GeneratorResult<ChestGeneratorData> result = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        result.getData().setSpawnCoords(coords);
        LootTable lootTable = this.selectLootTable(random, rarity);
        if (lootTable == null) {
            Treasure.logger.warn("Unable to select a lootTable.");
            return result.fail();
        }
        AbstractChestBlock chest = this.selectChest(random, rarity);
        if (chest == null) {
            Treasure.logger.warn("Unable to select a chest for rarity {}.", (Object)rarity);
            return result.fail();
        }
        TileEntity te = null;
        te = state != null ? this.placeInWorld(world, random, coords, chest, state) : this.placeInWorld(world, random, chest, coords);
        if (te == null) {
            Treasure.logger.debug("Unable to locate tile entity for chest -> {}", (Object)coords);
            return result.fail();
        }
        if (!(chest instanceof IMimicBlock)) {
            Treasure.logger.debug("Generating loot from loot table for rarity {}", (Object)rarity);
            lootTable.fillInventory(((AbstractTreasureChestTileEntity)te).getInventoryProxy(), random, Treasure.LOOT_TABLES.getContext());
        }
        this.addLocks(random, chest, (AbstractTreasureChestTileEntity)te, rarity);
        result.getData().setChestContext(new BlockContext(coords, state));
        return result.success();
    }

    default public List<LootTable> buildLootTableList(Rarity rarity) {
        return Treasure.LOOT_TABLES.getLootTableByRarity(rarity);
    }

    default public AbstractChestBlock selectChest(Random random, Rarity rarity) {
        List chestList = (List)TreasureBlocks.chests.get((Object)rarity);
        AbstractChestBlock chest = (AbstractChestBlock)chestList.get(RandomHelper.randomInt(random, 0, chestList.size() - 1));
        IChestConfig config = TreasureConfig.CHESTS.surfaceChests.configMap.get(rarity);
        if (chest == TreasureBlocks.WOOD_CHEST) {
            if (RandomHelper.checkProbability(random, config.getMimicProbability())) {
                chest = (AbstractChestBlock)TreasureBlocks.WOOD_MIMIC;
                Treasure.logger.debug("Selecting a WOOD MIMIC chest!");
            }
        } else if (chest == TreasureBlocks.PIRATE_CHEST && RandomHelper.checkProbability(random, config.getMimicProbability())) {
            chest = (AbstractChestBlock)TreasureBlocks.PIRATE_MIMIC;
            Treasure.logger.debug("Selecting a PIRATE MIMIC chest!");
        }
        return chest;
    }

    default public LootTable selectLootTable(Random random, Rarity rarity) {
        LootTable table = null;
        List<LootTable> tables = this.buildLootTableList(rarity);
        if (tables != null && !tables.isEmpty()) {
            int index = 0;
            if (tables.size() == 1) {
                table = tables.get(0);
            } else {
                index = RandomHelper.randomInt(random, 0, tables.size() - 1);
                table = tables.get(index);
            }
            Treasure.logger.debug("Selected loot table index --> {}", (Object)index);
        }
        return table;
    }

    default public void addLocks(Random random, AbstractChestBlock chest, AbstractTreasureChestTileEntity te, Rarity rarity) {
        ArrayList<LockItem> locks = new ArrayList<LockItem>();
        locks.addAll(TreasureItems.locks.get((Object)rarity));
        this.addLocks(random, chest, te, locks);
        locks.clear();
    }

    default public void addLocks(Random random, AbstractChestBlock chest, AbstractTreasureChestTileEntity te, List<LockItem> locks) {
        int numLocks = this.randomizedNumberOfLocksByChestType(random, chest.getChestType());
        List<LockState> lockStates = te.getLockStates();
        for (int i = 0; i < numLocks; ++i) {
            LockItem lock = locks.get(RandomHelper.randomInt(random, 0, locks.size() - 1));
            Treasure.logger.debug("adding lock: {}", (Object)lock);
            lockStates.get(i).setLock(lock);
        }
    }

    default public int randomizedNumberOfLocksByChestType(Random random, TreasureChestType type) {
        int numLocks = RandomHelper.randomInt(random, 0, type.getMaxLocks());
        Treasure.logger.debug("# of locks to use: {})", (Object)numLocks);
        return numLocks;
    }

    default public void addMarkers(World world, Random random, ICoords coords, boolean isSurfaceChest) {
        if (!isSurfaceChest && TreasureConfig.WORLD_GEN.getMarkerProperties().isMarkerStructuresAllowed && RandomHelper.checkProbability(random, TreasureConfig.WORLD_GEN.getMarkerProperties().markerStructureProbability)) {
            Treasure.logger.debug("generating a random structure marker -> {}", (Object)coords.toShortString());
            new StructureMarkerGenerator().generate(world, random, coords);
        } else {
            new GravestoneMarkerGenerator().generate(world, random, coords);
        }
    }

    default public TileEntity placeInWorld(World world, Random random, AbstractChestBlock chest, ICoords chestCoords) {
        boolean isPlaced = GenUtil.replaceBlockWithChest(world, random, chest, chestCoords);
        TileEntity te = world.func_175625_s(chestCoords.toPos());
        if (!isPlaced || !(world.func_180495_p(chestCoords.toPos()).func_177230_c() instanceof AbstractChestBlock)) {
            Treasure.logger.debug("Unable to place chest @ {}", (Object)chestCoords.toShortString());
            if (te != null && te instanceof AbstractTreasureChestTileEntity) {
                world.func_175713_t(chestCoords.toPos());
            }
            return null;
        }
        if (te == null || !(te instanceof AbstractTreasureChestTileEntity)) {
            world.func_175698_g(chestCoords.toPos());
            Treasure.logger.debug("Unable to create TileEntityChest, removing BlockChest");
            return null;
        }
        return te;
    }

    default public TileEntity placeInWorld(World world, Random random, ICoords chestCoords, AbstractChestBlock chest, IBlockState state) {
        boolean isPlaced = GenUtil.replaceBlockWithChest(world, random, chestCoords, chest, state);
        Treasure.logger.debug("isPlaced -> {}", (Object)isPlaced);
        TileEntity te = world.func_175625_s(chestCoords.toPos());
        if (!isPlaced || !(world.func_180495_p(chestCoords.toPos()).func_177230_c() instanceof AbstractChestBlock)) {
            Treasure.logger.debug("Unable to place chest @ {}", (Object)chestCoords.toShortString());
            if (te != null && te instanceof AbstractTreasureChestTileEntity) {
                world.func_175713_t(chestCoords.toPos());
            }
            return null;
        }
        if (te == null || !(te instanceof AbstractTreasureChestTileEntity)) {
            world.func_175698_g(chestCoords.toPos());
            Treasure.logger.debug("Unable to create TileEntityChest, removing BlockChest");
            return null;
        }
        return te;
    }
}

