/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.chest;

import com.someguyssoftware.gottschcore.loot.LootTable;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.block.TreasureChestBlock;
import com.someguyssoftware.treasure2.chest.TreasureChestType;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.chest.IChestGenerator;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.item.TreasureItems;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.loot.TreasureLootTableMaster;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class WitherChestGenerator
implements IChestGenerator {
    @Override
    public LootTable selectLootTable(Random random, Rarity chestRarity) {
        return Treasure.LOOT_TABLES.getSpecialLootTable(TreasureLootTableMaster.SpecialLootTables.WITHER_CHEST);
    }

    @Override
    public TreasureChestBlock selectChest(Random random, Rarity rarity) {
        TreasureChestBlock chest = (TreasureChestBlock)TreasureBlocks.WITHER_CHEST;
        return chest;
    }

    @Override
    public int randomizedNumberOfLocksByChestType(Random random, TreasureChestType type) {
        int numLocks = RandomHelper.randomInt(random, 1, type.getMaxLocks());
        Treasure.logger.debug("# of locks to use: {})", (Object)numLocks);
        return numLocks;
    }

    @Override
    public void addLocks(Random random, AbstractChestBlock chest, AbstractTreasureChestTileEntity te, Rarity rarity) {
        TreasureChestType type = chest.getChestType();
        List<LockState> lockStates = te.getLockStates();
        int numLocks = RandomHelper.randomInt(random, 1, type.getMaxLocks());
        for (int i = 0; i < numLocks; ++i) {
            LockItem lock = TreasureItems.WITHER_LOCK;
            lockStates.get(i).setLock(lock);
        }
    }

    @Override
    public void addMarkers(World world, Random random, ICoords coords, boolean isSurfaceChest) {
    }

    @Override
    public TileEntity placeInWorld(World world, Random random, AbstractChestBlock chest, ICoords chestCoords) {
        TileEntity te;
        GenUtil.replaceBlockWithChest(world, random, chest, chestCoords);
        if (world.func_180495_p(chestCoords.toPos()).func_177230_c() == TreasureBlocks.WITHER_CHEST) {
            world.func_175656_a(chestCoords.up(1).toPos(), TreasureBlocks.WITHER_CHEST_TOP.func_176223_P());
        }
        if ((te = world.func_175625_s(chestCoords.toPos())) == null || !(te instanceof AbstractTreasureChestTileEntity)) {
            world.func_175698_g(chestCoords.toPos());
            Treasure.logger.debug("Unable to create TileEntityChest, removing BlockChest");
            return null;
        }
        return te;
    }

    @Override
    public TileEntity placeInWorld(World world, Random random, ICoords chestCoords, AbstractChestBlock chest, IBlockState state) {
        TileEntity te;
        GenUtil.replaceBlockWithChest(world, random, chestCoords, chest, state);
        if (world.func_180495_p(chestCoords.toPos()).func_177230_c() == TreasureBlocks.WITHER_CHEST) {
            world.func_175656_a(chestCoords.up(1).toPos(), TreasureBlocks.WITHER_CHEST_TOP.func_176223_P());
        }
        if ((te = world.func_175625_s(chestCoords.toPos())) == null || !(te instanceof AbstractTreasureChestTileEntity)) {
            world.func_175698_g(chestCoords.toPos());
            Treasure.logger.debug("Unable to create TileEntityChest, removing BlockChest");
            return null;
        }
        return te;
    }
}

