/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.pit;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomWeightedCollection;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.pit.IPitGenerator;
import com.someguyssoftware.treasure2.generator.pit.SimpleShortPitGenerator;
import com.someguyssoftware.treasure2.tileentity.ProximitySpawnerTileEntity;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.DungeonHooks;

public abstract class AbstractPitGenerator
implements IPitGenerator<GeneratorResult<ChestGeneratorData>> {
    protected static final int OFFSET_Y = 5;
    protected static final int SURFACE_OFFSET_Y = 6;
    private RandomWeightedCollection<Block> blockLayers = new RandomWeightedCollection();
    private int offsetY = 5;

    public AbstractPitGenerator() {
        this.getBlockLayers().add(50, Blocks.field_150350_a);
        this.getBlockLayers().add(25, (Block)Blocks.field_150354_m);
        this.getBlockLayers().add(15, Blocks.field_150351_n);
        this.getBlockLayers().add(10, Blocks.field_150364_r);
    }

    @Override
    public boolean generateBase(World world, Random random, ICoords surfaceCorods, ICoords spawnCoords) {
        this.buildLayer(world, spawnCoords, Blocks.field_150350_a);
        this.buildAboveChestLayers(world, random, spawnCoords);
        return true;
    }

    @Override
    public boolean generatePit(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        this.buildPit(world, random, spawnCoords, surfaceCoords, this.getBlockLayers());
        return true;
    }

    @Override
    public boolean generateEntrance(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        this.buildLogLayer(world, random, surfaceCoords.add(0, -3, 0), Blocks.field_150364_r);
        this.buildLayer(world, surfaceCoords.add(0, -4, 0), (Block)Blocks.field_150354_m);
        this.buildLogLayer(world, random, surfaceCoords.add(0, -5, 0), Blocks.field_150364_r);
        return true;
    }

    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        GeneratorResult<ChestGeneratorData> result = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        result.getData().setSpawnCoords(spawnCoords);
        result.getData().getChestContext().setCoords(spawnCoords);
        boolean inCavern = false;
        IBlockState blockState = world.func_180495_p(spawnCoords.add(0, 1, 0).toPos());
        if (blockState == null || blockState.func_185904_a() == Material.field_151579_a) {
            Treasure.logger.debug("Spawn coords is in cavern.");
            inCavern = true;
        }
        if (inCavern) {
            Treasure.logger.debug("Shaft is in cavern... finding ceiling.");
            spawnCoords = GenUtil.findUndergroundCeiling(world, spawnCoords.add(0, 1, 0));
            if (spawnCoords == null) {
                Treasure.logger.warn("Exiting: Unable to locate cavern ceiling.");
                return result.fail();
            }
            result.getData().setSpawnCoords(spawnCoords);
            result.getData().getChestContext().setCoords(spawnCoords);
        }
        int yDist = surfaceCoords.getY() - spawnCoords.getY() - 2;
        Treasure.logger.debug("Distance to ySurface =" + yDist);
        if (yDist > 6) {
            Treasure.logger.debug("Generating shaft @ " + spawnCoords.toShortString());
            this.generateBase(world, random, surfaceCoords, spawnCoords);
            this.generateEntrance(world, random, surfaceCoords, spawnCoords);
            this.generatePit(world, random, surfaceCoords, spawnCoords);
        } else if (yDist >= 2) {
            result = new SimpleShortPitGenerator().generate(world, random, surfaceCoords, spawnCoords);
        }
        return result.success();
    }

    public void buildAboveChestLayers(World world, Random random, ICoords spawnCoords) {
        this.buildLayer(world, spawnCoords.add(0, 1, 0), Blocks.field_150350_a);
        this.buildLayer(world, spawnCoords.add(0, 2, 0), Blocks.field_150350_a);
        this.buildLogLayer(world, random, spawnCoords.add(0, 3, 0), Blocks.field_150364_r);
        this.buildLayer(world, spawnCoords.add(0, 4, 0), (Block)Blocks.field_150354_m);
    }

    public ICoords buildPit(World world, Random random, ICoords coords, ICoords surfaceCoords, RandomWeightedCollection<Block> col) {
        ICoords nextCoords = null;
        ICoords expectedCoords = null;
        for (int yIndex = coords.getY() + this.getOffsetY(); yIndex <= surfaceCoords.getY() - 6; ++yIndex) {
            Cube cube = new Cube(world, new Coords(coords.getX(), yIndex, coords.getZ()));
            if (cube.isAir()) continue;
            Block block = col.next();
            nextCoords = block == Blocks.field_150364_r ? this.buildLogLayer(world, random, cube.getCoords(), block) : this.buildLayer(world, cube.getCoords(), block);
            expectedCoords = cube.getCoords().add(0, 1, 0);
            yIndex = this.autoCorrectIndex(yIndex, nextCoords, expectedCoords);
        }
        return nextCoords;
    }

    protected int autoCorrectIndex(int index, ICoords coords, ICoords expectedCoords) {
        int newIndex = index;
        if (!coords.equals(expectedCoords)) {
            Treasure.logger.debug("Next coords does not equal expected coords. next: {}; expected: {}", (Object)coords.toShortString(), (Object)expectedCoords.toShortString());
            int diff = coords.getY() - expectedCoords.getY() - 1;
            if (diff > 0) {
                newIndex = coords.getY();
                Treasure.logger.debug("Difference of: {}. Updating yIndex to {}", (Object)diff, (Object)newIndex);
            }
        }
        return newIndex;
    }

    public ICoords buildLayer(World world, ICoords coords, Block block) {
        GenUtil.replaceWithBlock(world, coords, block);
        GenUtil.replaceWithBlock(world, coords.add(1, 0, 0), block);
        GenUtil.replaceWithBlock(world, coords.add(0, 0, 1), block);
        GenUtil.replaceWithBlock(world, coords.add(1, 0, 1), block);
        return coords.add(0, 1, 0);
    }

    public ICoords buildLogLayer(World world, Random random, ICoords coords, Block block) {
        if (block != Blocks.field_150364_r && block != Blocks.field_150363_s) {
            return coords;
        }
        int meta = random.nextInt() % 2 == 0 ? 8 : 4;
        IBlockState blockState = block.func_176203_a(meta);
        GenUtil.replaceWithBlockState(world, coords, blockState);
        GenUtil.replaceWithBlockState(world, coords.add(1, 0, 0), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(0, 0, 1), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(1, 0, 1), blockState);
        if (meta == 8) {
            GenUtil.replaceWithBlockState(world, coords.add(0, 0, -1), blockState);
            GenUtil.replaceWithBlockState(world, coords.add(1, 0, -1), blockState);
            GenUtil.replaceWithBlockState(world, coords.add(0, 0, 2), blockState);
            GenUtil.replaceWithBlockState(world, coords.add(1, 0, 2), blockState);
        } else {
            GenUtil.replaceWithBlockState(world, coords.add(-1, 0, 0), blockState);
            GenUtil.replaceWithBlockState(world, coords.add(-1, 0, 1), blockState);
            GenUtil.replaceWithBlockState(world, coords.add(2, 0, 0), blockState);
            GenUtil.replaceWithBlockState(world, coords.add(2, 0, 1), blockState);
        }
        return coords.add(0, 1, 0);
    }

    public void spawnMob(World world, ICoords spawnCoords, String mobName) {
        EntityZombie mob = null;
        switch (mobName) {
            case "zombie": {
                mob = new EntityZombie(world);
                break;
            }
            case "skeleton": {
                mob = new EntitySkeleton(world);
            }
        }
        mob.func_70012_b((double)spawnCoords.getX() + 0.5, (double)spawnCoords.getY(), (double)spawnCoords.getZ() + 0.5, 0.0f, 0.0f);
        world.func_72838_d((Entity)mob);
    }

    public void spawnRandomMob(World world, Random random, ICoords spawnCoords) {
        world.func_175656_a(spawnCoords.toPos(), TreasureBlocks.PROXIMITY_SPAWNER.func_176223_P());
        ProximitySpawnerTileEntity te = (ProximitySpawnerTileEntity)world.func_175625_s(spawnCoords.toPos());
        ResourceLocation r = DungeonHooks.getRandomDungeonMob((Random)random);
        te.setMobName(r);
        te.setMobNum(new Quantity(1.0, 1.0));
        te.setProximity(3.0);
    }

    public RandomWeightedCollection<Block> getBlockLayers() {
        return this.blockLayers;
    }

    public void setBlockLayers(RandomWeightedCollection<Block> blockLayers) {
        this.blockLayers = blockLayers;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    @Override
    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }
}

