/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.pit;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomWeightedCollection;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.pit.AbstractPitGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class LavaTrapPitGenerator
extends AbstractPitGenerator {
    public LavaTrapPitGenerator() {
        this.getBlockLayers().add(50, Blocks.field_150350_a);
        this.getBlockLayers().add(25, (Block)Blocks.field_150354_m);
        this.getBlockLayers().add(15, Blocks.field_150347_e);
        this.getBlockLayers().add(15, Blocks.field_150351_n);
        this.getBlockLayers().add(10, Blocks.field_150364_r);
    }

    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords surfaceCoords, ICoords spawnCoords) {
        GeneratorResult<ChestGeneratorData> result = super.generate(world, random, surfaceCoords, spawnCoords);
        if (result.isSuccess()) {
            Treasure.logger.debug("Generated Lava Trap Pit at " + spawnCoords.toShortString());
        }
        return result;
    }

    @Override
    public ICoords buildPit(World world, Random random, ICoords coords, ICoords surfaceCoords, RandomWeightedCollection<Block> col) {
        int yIndex;
        ICoords nextCoords = null;
        ICoords expectedCoords = null;
        int midY = (surfaceCoords.getY() + coords.getY()) / 2;
        this.buildLavaBaseLayer(world, coords.down(1));
        this.build3WideLayer(world, random, coords, Blocks.field_150350_a);
        for (yIndex = coords.getY() + 5; yIndex <= midY; ++yIndex) {
            nextCoords = this.build3WideLayer(world, random, new Coords(coords.getX(), yIndex, coords.getZ()), Blocks.field_150350_a);
        }
        nextCoords = this.build3WideLayer(world, random, new Coords(coords.getX(), midY + 1, coords.getZ()), Blocks.field_150364_r);
        for (yIndex = nextCoords.getY(); yIndex <= surfaceCoords.getY() - 6; ++yIndex) {
            Cube cube = new Cube(world, new Coords(coords.getX(), yIndex, coords.getZ()));
            if (cube.isAir()) continue;
            Block block = col.next();
            nextCoords = block == Blocks.field_150364_r ? this.buildLogLayer(world, random, cube.getCoords(), block) : this.buildLayer(world, cube.getCoords(), block);
            expectedCoords = cube.getCoords().add(0, 1, 0);
            yIndex = this.autoCorrectIndex(yIndex, nextCoords, expectedCoords);
        }
        return nextCoords;
    }

    @Override
    public void buildAboveChestLayers(World world, Random random, ICoords spawnCoords) {
        this.build3WideLayer(world, random, spawnCoords.add(0, 1, 0), Blocks.field_150350_a);
        this.build3WideLayer(world, random, spawnCoords.add(0, 2, 0), Blocks.field_150350_a);
        this.build3WideLayer(world, random, spawnCoords.add(0, 3, 0), Blocks.field_150350_a);
        this.build3WideLayer(world, random, spawnCoords.add(0, 4, 0), Blocks.field_150350_a);
    }

    private ICoords build3WideLayer(World world, Random random, ICoords coords, Block block) {
        IBlockState blockState = block.func_176223_P();
        if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
            int meta = random.nextInt() % 2 == 0 ? 8 : 4;
            blockState = block.func_176203_a(meta);
        }
        GenUtil.replaceWithBlockState(world, coords, blockState);
        GenUtil.replaceWithBlockState(world, coords.add(1, 0, 0), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(-1, 0, 0), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(0, 0, 1), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(0, 0, -1), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(-1, 0, 1), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(1, 0, 1), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(-1, 0, -1), blockState);
        GenUtil.replaceWithBlockState(world, coords.add(1, 0, -1), blockState);
        return coords.add(0, 1, 0);
    }

    private void buildLavaBaseLayer(World world, ICoords coords) {
        Treasure.logger.debug("Building lava baselayer from @ {} ", (Object)coords.toShortString());
        GenUtil.replaceWithBlock(world, coords.add(1, 0, 0), (Block)Blocks.field_150353_l);
        GenUtil.replaceWithBlock(world, coords.add(-1, 0, 0), (Block)Blocks.field_150353_l);
        GenUtil.replaceWithBlock(world, coords.add(0, 0, 1), (Block)Blocks.field_150353_l);
        GenUtil.replaceWithBlock(world, coords.add(0, 0, -1), (Block)Blocks.field_150353_l);
        GenUtil.replaceWithBlock(world, coords.add(-1, 0, 1), (Block)Blocks.field_150353_l);
        GenUtil.replaceWithBlock(world, coords.add(1, 0, 1), (Block)Blocks.field_150353_l);
        GenUtil.replaceWithBlock(world, coords.add(-1, 0, -1), (Block)Blocks.field_150353_l);
        GenUtil.replaceWithBlock(world, coords.add(1, 0, -1), (Block)Blocks.field_150353_l);
    }
}

