/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.ruins;

import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.gen.structure.BlockContext;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayRuleSet;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.TreasureBlocks;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.IGeneratorResult;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureType;
import com.someguyssoftware.treasure2.tileentity.ProximitySpawnerTileEntity;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DungeonHooks;

public interface IRuinGenerator<RESULT extends IGeneratorResult<?>> {
    public GeneratorResult<ChestGeneratorData> generate(World var1, Random var2, ICoords var3);

    public GeneratorResult<ChestGeneratorData> generate(World var1, Random var2, ICoords var3, IDecayRuleSet var4);

    public GeneratorResult<ChestGeneratorData> generate(World var1, Random var2, ICoords var3, TemplateHolder var4);

    public GeneratorResult<ChestGeneratorData> generate(World var1, Random var2, ICoords var3, TemplateHolder var4, IDecayRuleSet var5);

    default public TemplateHolder selectTemplate(World world, Random random, ICoords coords, StructureArchetype archetype, StructureType type) {
        Biome biome = world.func_180494_b(coords.toPos());
        TemplateHolder holder = Treasure.TEMPLATE_MANAGER.getTemplate(world, random, archetype, type, biome);
        return holder;
    }

    default public void buildOneTimeSpawners(World world, Random random, List<BlockContext> proximityContexts, Quantity quantity, double d) {
        for (BlockContext c : proximityContexts) {
            Treasure.logger.debug("placing proximity spawner at -> {}", (Object)c.getCoords().toShortString());
            world.func_175656_a(c.getCoords().toPos(), TreasureBlocks.PROXIMITY_SPAWNER.func_176223_P());
            ProximitySpawnerTileEntity te = (ProximitySpawnerTileEntity)world.func_175625_s(c.getCoords().toPos());
            ResourceLocation r = DungeonHooks.getRandomDungeonMob((Random)random);
            Treasure.logger.debug("using mob -> {} for poximity spawner.", (Object)r.toString());
            te.setMobName(r);
            te.setMobNum(new Quantity(1.0, 2.0));
            te.setProximity(5.0);
        }
    }

    default public void buildVanillaSpawners(World world, Random random, List<BlockContext> spawnerContexts) {
        for (BlockContext c : spawnerContexts) {
            world.func_175656_a(c.getCoords().toPos(), Blocks.field_150474_ac.func_176223_P());
            TileEntityMobSpawner te = (TileEntityMobSpawner)world.func_175625_s(c.getCoords().toPos());
            ResourceLocation r = DungeonHooks.getRandomDungeonMob((Random)random);
            te.func_145881_a().func_190894_a(r);
        }
    }
}

