/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.generator.ruins;

import com.someguyssoftware.gottschcore.cube.Cube;
import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.gottschcore.world.gen.structure.BlockContext;
import com.someguyssoftware.gottschcore.world.gen.structure.DecayProcessor;
import com.someguyssoftware.gottschcore.world.gen.structure.IDecayRuleSet;
import com.someguyssoftware.gottschcore.world.gen.structure.StructureMarkers;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GenUtil;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.TemplateGeneratorData;
import com.someguyssoftware.treasure2.generator.ruins.IRuinGenerator;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureMeta;
import com.someguyssoftware.treasure2.meta.StructureType;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateGenerator;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.util.Rotation;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;

public class SurfaceRuinGenerator
implements IRuinGenerator<GeneratorResult<ChestGeneratorData>> {
    private static final double REQUIRED_BASE_SIZE = 45.0;
    private static final double REQUIRED_AIR_SIZE = 30.0;

    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords) {
        return this.generate(world, random, originalSpawnCoords, null, null);
    }

    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords, IDecayRuleSet decayRuleSet) {
        return this.generate(world, random, originalSpawnCoords, null, decayRuleSet);
    }

    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords, TemplateHolder holder) {
        return this.generate(world, random, originalSpawnCoords, holder, null);
    }

    @Override
    public GeneratorResult<ChestGeneratorData> generate(World world, Random random, ICoords originalSpawnCoords, TemplateHolder holder, IDecayRuleSet decayRuleSet) {
        GeneratorResult<TemplateGeneratorData> genResult;
        GeneratorResult<ChestGeneratorData> result = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        TemplateGenerator generator = new TemplateGenerator();
        if (holder == null) {
            holder = this.selectTemplate(world, random, originalSpawnCoords, StructureArchetype.SURFACE, StructureType.RUIN);
        }
        if (holder == null) {
            return result.fail();
        }
        Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
        Treasure.logger.debug("rotation used -> {}", (Object)rotation);
        PlacementSettings placement = new PlacementSettings();
        placement.func_186220_a(rotation).func_189950_a(random);
        Coords templateSize = new Coords(holder.getTemplate().func_186257_a(placement.func_186215_c()));
        ICoords actualSpawnCoords = generator.getTransformedSpawnCoords(originalSpawnCoords, templateSize, placement);
        Treasure.logger.debug("original coords -> {}", (Object)originalSpawnCoords.toShortString());
        Treasure.logger.debug("actual coords -> {}", (Object)actualSpawnCoords.toShortString());
        actualSpawnCoords = WorldInfo.getDryLandSurfaceCoords(world, actualSpawnCoords);
        Treasure.logger.debug("surface coords -> {}", (Object)actualSpawnCoords.toShortString());
        if (actualSpawnCoords == WorldInfo.EMPTY_COORDS) {
            return result.fail();
        }
        for (int i = 0; i < 3; ++i) {
            Treasure.logger.debug("finding solid base index -> {} at coords -> {}", (Object)i, (Object)actualSpawnCoords.toShortString());
            if (WorldInfo.isSolidBase(world, actualSpawnCoords, templateSize.getX(), templateSize.getZ(), 45.0)) break;
            if (i == 2) {
                Treasure.logger.debug("Coords -> [{}] does not meet {}% solid base requirements for size -> {} x {}", (Object)originalSpawnCoords.toShortString(), (Object)45.0, (Object)templateSize.getX(), (Object)templateSize.getZ());
                return result.fail();
            }
            actualSpawnCoords = actualSpawnCoords.add(0, -1, 0);
            Treasure.logger.debug("move actual spawn coords down for solid base check -> {}", (Object)actualSpawnCoords.toShortString());
        }
        Treasure.logger.debug("using solid base coords -> {}", (Object)actualSpawnCoords.toShortString());
        Treasure.logger.debug("checking for {} % air at coords -> {} for dimensions -> {} x {}", (Object)30.0, (Object)actualSpawnCoords.add(0, 1, 0), (Object)templateSize.getX(), (Object)templateSize.getZ());
        if (!WorldInfo.isAirBase(world, actualSpawnCoords.add(0, 1, 0), templateSize.getX(), templateSize.getZ(), 30.0)) {
            Treasure.logger.debug("Coords -> [{}] does not meet {} % air base requirements for size -> {} x {}", (Object)originalSpawnCoords.toShortString(), (Object)30.0, (Object)templateSize.getX(), (Object)templateSize.getZ());
            return result.fail();
        }
        originalSpawnCoords = new Coords(originalSpawnCoords.getX(), actualSpawnCoords.getY(), originalSpawnCoords.getZ());
        StructureMeta meta = (StructureMeta)Treasure.META_MANAGER.getMetaMap().get(holder.getMetaLocation().toString());
        if (meta == null) {
            Treasure.logger.debug("Unable to locate meta data for template -> {}", (Object)holder.getLocation());
            return result.fail();
        }
        DecayProcessor decayProcessor = null;
        if (decayRuleSet == null && holder.getDecayRuleSetLocation() != null && holder.getDecayRuleSetLocation().size() > 0) {
            decayRuleSet = Treasure.DECAY_MANAGER.getRuleSetMap().get(holder.getDecayRuleSetLocation().get(random.nextInt(holder.getDecayRuleSetLocation().size())).toString());
            Treasure.logger.debug("decayRuleSet -> {}", (Object)decayRuleSet.getName());
        }
        if (decayRuleSet != null) {
            decayProcessor = new DecayProcessor(Treasure.instance.getInstance(), decayRuleSet);
        }
        if (!(genResult = generator.generate(world, random, decayProcessor, holder, placement, originalSpawnCoords)).isSuccess()) {
            return result.fail();
        }
        Treasure.logger.debug("surface gen result -> {}", genResult);
        List bossChestContexts = (List)genResult.getData().getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.BOSS_CHEST));
        List chestContexts = (List)genResult.getData().getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.CHEST));
        List spawnerContexts = (List)genResult.getData().getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.SPAWNER));
        List proximityContexts = (List)genResult.getData().getMap().get((Object)GenUtil.getMarkerBlock(StructureMarkers.PROXIMITY_SPAWNER));
        BlockContext chestContext = null;
        if (bossChestContexts != null && bossChestContexts.size() > 0) {
            chestContext = bossChestContexts.size() > 1 ? (BlockContext)bossChestContexts.get(random.nextInt(bossChestContexts.size())) : (BlockContext)bossChestContexts.get(0);
        }
        if (chestContext == null && chestContexts != null && chestContexts.size() > 0) {
            chestContext = chestContexts.size() > 1 ? (BlockContext)chestContexts.get(random.nextInt(chestContexts.size())) : (BlockContext)chestContexts.get(0);
        }
        ICoords chestCoords = null;
        if (chestContext != null) {
            chestCoords = SurfaceRuinGenerator.getSolidSurfaceCoords(world, chestContext.getCoords());
            if (chestCoords == WorldInfo.EMPTY_COORDS) {
                chestCoords = null;
            }
            chestContext.setCoords(chestCoords);
        }
        if (chestCoords == null) {
            return result.fail();
        }
        if (proximityContexts != null) {
            Treasure.logger.debug("Proximity spawners size -> {}", (Object)proximityContexts.size());
        } else {
            Treasure.logger.debug("No proximity spawners found.");
        }
        this.buildVanillaSpawners(world, random, spawnerContexts);
        this.buildOneTimeSpawners(world, random, proximityContexts, new Quantity(1.0, 2.0), 5.0);
        result.getData().setSpawnCoords(genResult.getData().getSpawnCoords());
        result.getData().setChestContext(chestContext);
        return result.success();
    }

    public static ICoords getSolidSurfaceCoords(World world, ICoords coords) {
        boolean isSurfaceBlock = false;
        ICoords newCoords = coords;
        while (!isSurfaceBlock) {
            Cube cube = new Cube(world, newCoords.down(1));
            if (!WorldInfo.isValidY(cube.getCoords())) {
                return WorldInfo.EMPTY_COORDS;
            }
            if (cube.equalsMaterial(Material.field_151579_a) || cube.isReplaceable() || cube.equalsMaterial(Material.field_151584_j) || cube.isLiquid() || cube.isBurning(world)) {
                newCoords = newCoords.down(1);
                continue;
            }
            isSurfaceBlock = true;
        }
        return newCoords;
    }
}

