/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.item;

import com.someguyssoftware.gottschcore.item.ModItem;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.block.AbstractChestBlock;
import com.someguyssoftware.treasure2.block.ITreasureChestProxy;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Category;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.item.LockItem;
import com.someguyssoftware.treasure2.lock.LockState;
import com.someguyssoftware.treasure2.tileentity.AbstractTreasureChestTileEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class KeyItem
extends ModItem {
    public static final int DEFAULT_MAX_USES = 25;
    private Category category;
    private Rarity rarity;
    private boolean craftable;
    private boolean breakable;
    private boolean damageable;
    private double successProbability;

    public KeyItem(String modID, String name) {
        this.setItemName(modID, name);
        this.func_77637_a(Treasure.TREASURE_TAB);
        this.setCategory(Category.BASIC);
        this.setRarity(Rarity.COMMON);
        this.setBreakable(true);
        this.setDamageable(true);
        this.setCraftable(false);
        this.setMaxDamage(25);
        this.setSuccessProbability(90.0);
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.rarity", (Object[])new Object[]{TextFormatting.DARK_BLUE + this.getRarity().toString()}));
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.category", (Object[])new Object[]{this.getCategory()}));
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.max_uses", (Object[])new Object[]{this.func_77612_l()}));
        String breakable = "";
        breakable = this.isBreakable() ? TextFormatting.DARK_RED + I18n.func_74838_a((String)"tooltip.yes") : TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.no");
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.breakable", (Object[])new Object[]{breakable}));
        String craftable = "";
        craftable = this.isCraftable() ? TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.yes") : TextFormatting.DARK_RED + I18n.func_74838_a((String)"tooltip.no");
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.craftable", (Object[])new Object[]{craftable}));
        String damageable = "";
        damageable = this.func_77645_m() ? TextFormatting.DARK_RED + I18n.func_74838_a((String)"tooltip.yes") : TextFormatting.GREEN + I18n.func_74838_a((String)"tooltip.no");
        tooltip.add(I18n.func_74837_a((String)"tooltip.label.damageable", (Object[])new Object[]{damageable}));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos chestPos = pos;
        Block block = worldIn.func_180495_p(chestPos).func_177230_c();
        if (block instanceof ITreasureChestProxy) {
            chestPos = ((ITreasureChestProxy)block).getChestPos(chestPos);
            block = worldIn.func_180495_p(chestPos).func_177230_c();
        }
        if (block instanceof AbstractChestBlock) {
            TileEntity te = worldIn.func_175625_s(chestPos);
            if (te == null || !(te instanceof AbstractTreasureChestTileEntity)) {
                Treasure.logger.warn("Null or incorrect TileEntity");
                return EnumActionResult.FAIL;
            }
            AbstractTreasureChestTileEntity tcte = (AbstractTreasureChestTileEntity)te;
            if (WorldInfo.isClientSide(worldIn)) {
                return EnumActionResult.FAIL;
            }
            if (!tcte.hasLocks()) {
                return EnumActionResult.SUCCESS;
            }
            try {
                ItemStack heldItem = player.func_184586_b(hand);
                boolean breakKey = true;
                boolean fitsLock = false;
                LockState lockState = null;
                boolean isKeyBroken = false;
                lockState = this.fitsFirstLock(tcte.getLockStates());
                if (lockState != null) {
                    fitsLock = true;
                }
                if (fitsLock && this.unlock(lockState.getLock())) {
                    LockItem lock = lockState.getLock();
                    lockState.setLock(null);
                    worldIn.func_184133_a(player, chestPos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
                    tcte.sendUpdates();
                    if (TreasureConfig.KEYS_LOCKS.enableLockDrops) {
                        InventoryHelper.func_180173_a((World)worldIn, (double)chestPos.func_177958_n(), (double)chestPos.func_177956_o(), (double)chestPos.func_177952_p(), (ItemStack)new ItemStack((Item)lock));
                    }
                    breakKey = false;
                }
                if (breakKey) {
                    if (this.isBreakable() && TreasureConfig.KEYS_LOCKS.enableKeyBreaks) {
                        heldItem.func_190918_g(1);
                        player.func_145747_a((ITextComponent)new TextComponentString("Key broke."));
                        worldIn.func_184133_a(player, chestPos, SoundEvents.field_187766_dk, SoundCategory.BLOCKS, 0.3f, 0.6f);
                        isKeyBroken = true;
                        if (heldItem.func_190916_E() > 0) {
                            heldItem.func_77964_b(0);
                        }
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString("Failed to unlock."));
                    }
                }
                if (this.func_77645_m() && !isKeyBroken) {
                    heldItem.func_77972_a(1, (EntityLivingBase)player);
                    if (heldItem.func_77952_i() == heldItem.func_77958_k()) {
                        heldItem.func_190918_g(1);
                    }
                }
            }
            catch (Exception e) {
                Treasure.logger.error("error: ", (Throwable)e);
            }
        }
        return super.func_180614_a(player, worldIn, chestPos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean fitsLock(LockItem lockItem) {
        return false;
    }

    public LockState fitsFirstLock(List<LockState> lockStates) {
        LockState lockState = null;
        for (LockState ls : lockStates) {
            if (ls.getLock() == null || !(lockState = ls).getLock().acceptsKey(this) && !this.fitsLock(lockState.getLock())) continue;
            return ls;
        }
        return null;
    }

    public boolean unlock(LockItem lockItem) {
        if (lockItem.acceptsKey(this) || this.fitsLock(lockItem)) {
            Treasure.logger.debug("Lock -> {} accepts key -> {}", (Object)lockItem.getRegistryName(), (Object)this.getRegistryName());
            if (RandomHelper.checkProbability(new Random(), this.getSuccessProbability())) {
                Treasure.logger.debug("Unlock attempt met probability");
                return true;
            }
        }
        return false;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public KeyItem setRarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public boolean isCraftable() {
        return this.craftable;
    }

    public KeyItem setCraftable(boolean craftable) {
        this.craftable = craftable;
        return this;
    }

    public String toString() {
        return "KeyItem [rarity=" + this.rarity + ", craftable=" + this.craftable + "]";
    }

    public Category getCategory() {
        return this.category;
    }

    public KeyItem setCategory(Category category) {
        this.category = category;
        return this;
    }

    public boolean isBreakable() {
        return this.breakable;
    }

    public KeyItem setBreakable(boolean breakable) {
        this.breakable = breakable;
        return this;
    }

    public KeyItem setMaxDamage(int damage) {
        super.func_77656_e(damage);
        return this;
    }

    public double getSuccessProbability() {
        return this.successProbability;
    }

    public KeyItem setSuccessProbability(double successProbability) {
        this.successProbability = successProbability;
        return this;
    }

    public boolean func_77645_m() {
        return this.damageable;
    }

    public void setDamageable(boolean damageable) {
        this.damageable = damageable;
    }
}

