/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.particle;

import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.network.WitherMistMessageToServer;
import com.someguyssoftware.treasure2.particle.AbstractMistParticle;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class WitherMistParticle
extends AbstractMistParticle {
    protected static final int MAX_AGE = 450;
    protected static final float ALPHA_VALUE = 0.5f;
    protected static final float MAX_SCALE_VALUE = 12.0f;
    private static ResourceLocation[] mistParticlesSprites = new ResourceLocation[4];

    public WitherMistParticle(World world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, ICoords parentCoords) {
        super(world, x, y, z);
        this.setParentEmitterCoords(parentCoords);
        Random random = new Random();
        int index = random.nextInt(4);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(mistParticlesSprites[index].toString());
        this.func_187117_a(sprite);
    }

    @Override
    public void inflictEffectOnPlayer(EntityPlayer player) {
        if (WorldInfo.isServerSide((World)Minecraft.func_71410_x().field_71441_e)) {
            return;
        }
        PotionEffect potionEffect = player.func_70660_b(MobEffects.field_82731_v);
        if (potionEffect == null) {
            WitherMistMessageToServer messageToServer = new WitherMistMessageToServer(player.func_70005_c_());
            Treasure.simpleNetworkWrapper.sendToServer((IMessage)messageToServer);
        }
    }

    @Override
    public int provideMaxAge() {
        return 450;
    }

    @Override
    public float provideMaxScale() {
        return 12.0f;
    }

    @Override
    public float provideAlpha() {
        return 0.5f;
    }

    static {
        WitherMistParticle.mistParticlesSprites[0] = new ResourceLocation("treasure2", "particle/wither_mist_particle");
        WitherMistParticle.mistParticlesSprites[1] = new ResourceLocation("treasure2", "particle/wither_mist_particle2");
        WitherMistParticle.mistParticlesSprites[2] = new ResourceLocation("treasure2", "particle/wither_mist_particle3");
        WitherMistParticle.mistParticlesSprites[3] = new ResourceLocation("treasure2", "particle/wither_mist_particle4");
    }
}

