/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.persistence;

import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.chest.ChestInfo;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.enums.WorldGenerators;
import com.someguyssoftware.treasure2.registry.ChestRegistry;
import com.someguyssoftware.treasure2.worldgen.GemOreWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.SubmergedChestWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.SurfaceChestWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.WellWorldGenerator;
import com.someguyssoftware.treasure2.worldgen.WitherTreeWorldGenerator;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class GenDataPersistence
extends WorldSavedData {
    private static final String TREASURE_GEN_TAG_NAME = "treasureGenerator";
    public static final String GEN_DATA_KEY = "treasureGenData";
    private static final String SURFACE_CHEST_GEN_TAG_NAME = "surfaceChestGen";
    private static final String SUBMERGED_CHEST_GEN_TAG_NAME = "submergedChestGen";
    private static final String KEY_TAG_NAME = "key";
    private static final String COUNT_TAG_NAME = "count";
    private static final String CHUNKS_SINCE_LAST_CHEST_TAG_NAME = "chunksSinceLastChest";
    private static final String CHUNKS_SINCE_LAST_RARITY_CHEST_TAG_NAME = "chunksSinceLastRarityChest";
    private static final String CHEST_REGISTRY_TAG_NAME = "chestRegistry";
    private static final String COORDS_TAG_NAME = "coords";
    private static final String RARITY_TAG_NAME = "rarity";

    public GenDataPersistence() {
        super(GEN_DATA_KEY);
    }

    public GenDataPersistence(String key) {
        super(key);
    }

    public void func_76184_a(NBTTagCompound tag) {
        String key;
        int count;
        NBTTagCompound chunkTag;
        int i;
        NBTTagList chunksSinceTagList;
        Treasure.logger.debug("Loading Treasure! saved gen data...");
        SurfaceChestWorldGenerator surfaceChestGen = (SurfaceChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.SURFACE_CHEST);
        SubmergedChestWorldGenerator submergedChestGen = (SubmergedChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.SUBMERGED_CHEST);
        WellWorldGenerator wellGen = (WellWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.WELL);
        WitherTreeWorldGenerator witherGen = (WitherTreeWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.WITHER_TREE);
        GemOreWorldGenerator gemGen = (GemOreWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.GEM);
        NBTTagCompound treasureGen = tag.func_74775_l(TREASURE_GEN_TAG_NAME);
        NBTTagCompound surfaceTag = treasureGen.func_74775_l(SURFACE_CHEST_GEN_TAG_NAME);
        NBTTagCompound submergedTag = treasureGen.func_74775_l(SUBMERGED_CHEST_GEN_TAG_NAME);
        if (surfaceTag != null) {
            surfaceChestGen.setChunksSinceLastChest(surfaceTag.func_74762_e(CHUNKS_SINCE_LAST_CHEST_TAG_NAME));
            chunksSinceTagList = surfaceTag.func_150295_c(CHUNKS_SINCE_LAST_RARITY_CHEST_TAG_NAME, 10);
            for (i = 0; i < chunksSinceTagList.func_74745_c(); ++i) {
                chunkTag = chunksSinceTagList.func_150305_b(i);
                count = chunkTag.func_74762_e(COUNT_TAG_NAME);
                key = chunkTag.func_74779_i(KEY_TAG_NAME);
                surfaceChestGen.getChunksSinceLastRarityChest().put(Rarity.valueOf(key), count);
            }
        }
        if (submergedTag != null) {
            submergedChestGen.setChunksSinceLastChest(submergedTag.func_74762_e(CHUNKS_SINCE_LAST_CHEST_TAG_NAME));
            chunksSinceTagList = submergedTag.func_150295_c(CHUNKS_SINCE_LAST_RARITY_CHEST_TAG_NAME, 10);
            for (i = 0; i < chunksSinceTagList.func_74745_c(); ++i) {
                chunkTag = chunksSinceTagList.func_150305_b(i);
                count = chunkTag.func_74762_e(COUNT_TAG_NAME);
                key = chunkTag.func_74779_i(KEY_TAG_NAME);
                submergedChestGen.getChunksSinceLastRarityChest().put(Rarity.valueOf(key), count);
            }
        }
        wellGen.setChunksSinceLastWell(treasureGen.func_74762_e("chunksSinceLastWell"));
        witherGen.setChunksSinceLastTree(treasureGen.func_74762_e("chunksSinceLastTree"));
        gemGen.setChunksSinceLastOre(treasureGen.func_74762_e("chunksSinceLastOre"));
        ChestRegistry chestRegistry = ChestRegistry.getInstance();
        Treasure.logger.debug("ChestConfig Registry size before loading -> {}", (Object)chestRegistry.getValues().size());
        chestRegistry.clear();
        NBTTagList chestRegistryTagList = treasureGen.func_150295_c(CHEST_REGISTRY_TAG_NAME, 10);
        for (int i2 = 0; i2 < chestRegistryTagList.func_74745_c(); ++i2) {
            NBTTagCompound chunkTag2 = chestRegistryTagList.func_150305_b(i2);
            key = chunkTag2.func_74779_i(KEY_TAG_NAME);
            String rarity = chunkTag2.func_74779_i(RARITY_TAG_NAME);
            NBTTagCompound coords = chunkTag2.func_74775_l(COORDS_TAG_NAME);
            int x = coords.func_74762_e("x");
            int y = coords.func_74762_e("y");
            int z = coords.func_74762_e("z");
            chestRegistry.register(key, new ChestInfo(Rarity.getByValue(rarity), new Coords(x, y, z)));
        }
        Treasure.logger.debug("ChestConfig Registry size after loading -> {}", (Object)chestRegistry.getValues().size());
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        try {
            NBTTagInt count;
            NBTTagString key;
            NBTTagCompound entry;
            NBTTagCompound treasureGen = new NBTTagCompound();
            tag.func_74782_a(TREASURE_GEN_TAG_NAME, (NBTBase)treasureGen);
            SurfaceChestWorldGenerator surfaceChestGen = (SurfaceChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.SURFACE_CHEST);
            SubmergedChestWorldGenerator submergedChestGen = (SubmergedChestWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.SUBMERGED_CHEST);
            NBTTagCompound surfaceTag = new NBTTagCompound();
            NBTTagCompound submergedTag = new NBTTagCompound();
            surfaceTag.func_74768_a(CHUNKS_SINCE_LAST_CHEST_TAG_NAME, surfaceChestGen.getChunksSinceLastChest());
            NBTTagList chunksSinceTagList = new NBTTagList();
            for (Map.Entry<Rarity, Integer> since : surfaceChestGen.getChunksSinceLastRarityChest().entrySet()) {
                entry = new NBTTagCompound();
                key = new NBTTagString(since.getKey().name());
                count = new NBTTagInt(since.getValue().intValue());
                entry.func_74782_a(KEY_TAG_NAME, (NBTBase)key);
                entry.func_74782_a(COUNT_TAG_NAME, (NBTBase)count);
                chunksSinceTagList.func_74742_a((NBTBase)entry);
            }
            surfaceTag.func_74782_a(CHUNKS_SINCE_LAST_RARITY_CHEST_TAG_NAME, (NBTBase)chunksSinceTagList);
            submergedTag.func_74768_a(CHUNKS_SINCE_LAST_CHEST_TAG_NAME, submergedChestGen.getChunksSinceLastChest());
            chunksSinceTagList = new NBTTagList();
            for (Map.Entry<Rarity, Integer> since : submergedChestGen.getChunksSinceLastRarityChest().entrySet()) {
                entry = new NBTTagCompound();
                key = new NBTTagString(since.getKey().name());
                count = new NBTTagInt(since.getValue().intValue());
                entry.func_74782_a(KEY_TAG_NAME, (NBTBase)key);
                entry.func_74782_a(COUNT_TAG_NAME, (NBTBase)count);
                chunksSinceTagList.func_74742_a((NBTBase)entry);
            }
            submergedTag.func_74782_a(CHUNKS_SINCE_LAST_RARITY_CHEST_TAG_NAME, (NBTBase)chunksSinceTagList);
            treasureGen.func_74782_a(SURFACE_CHEST_GEN_TAG_NAME, (NBTBase)surfaceTag);
            treasureGen.func_74782_a(SUBMERGED_CHEST_GEN_TAG_NAME, (NBTBase)submergedTag);
            WellWorldGenerator wellGen = (WellWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.WELL);
            treasureGen.func_74768_a("chunksSinceLastWell", wellGen.getChunksSinceLastWell());
            WitherTreeWorldGenerator witherGen = (WitherTreeWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.WITHER_TREE);
            treasureGen.func_74768_a("chunksSinceLastTree", witherGen.getChunksSinceLastTree());
            GemOreWorldGenerator gemGen = (GemOreWorldGenerator)Treasure.WORLD_GENERATORS.get((Object)WorldGenerators.GEM);
            treasureGen.func_74768_a("chunksSinceLastOre", gemGen.getChunksSinceLastOre());
            NBTTagList chestRegistryTagList = new NBTTagList();
            ChestRegistry chestRegistry = ChestRegistry.getInstance();
            for (ChestInfo element : chestRegistry.getValues()) {
                NBTTagCompound entry2 = new NBTTagCompound();
                NBTTagString key2 = new NBTTagString(element.getCoords().toShortString());
                NBTTagString rarity = new NBTTagString(element.getRarity().getValue());
                NBTTagCompound coords = new NBTTagCompound();
                NBTTagInt x = new NBTTagInt(element.getCoords().getX());
                NBTTagInt y = new NBTTagInt(element.getCoords().getY());
                NBTTagInt z = new NBTTagInt(element.getCoords().getZ());
                coords.func_74782_a("x", (NBTBase)x);
                coords.func_74782_a("y", (NBTBase)y);
                coords.func_74782_a("z", (NBTBase)z);
                entry2.func_74782_a(KEY_TAG_NAME, (NBTBase)key2);
                entry2.func_74782_a(RARITY_TAG_NAME, (NBTBase)rarity);
                entry2.func_74782_a(COORDS_TAG_NAME, (NBTBase)coords);
                chestRegistryTagList.func_74742_a((NBTBase)entry2);
            }
            treasureGen.func_82580_o(CHEST_REGISTRY_TAG_NAME);
            treasureGen.func_74782_a(CHEST_REGISTRY_TAG_NAME, (NBTBase)chestRegistryTagList);
        }
        catch (Exception e) {
            e.printStackTrace();
            Treasure.logger.error("An exception occurred:", (Throwable)e);
        }
        return tag;
    }

    public static GenDataPersistence get(World world) {
        GenDataPersistence data = (GenDataPersistence)world.func_72943_a(GenDataPersistence.class, GEN_DATA_KEY);
        if (data == null) {
            data = new GenDataPersistence();
            world.func_72823_a(GEN_DATA_KEY, (WorldSavedData)data);
        }
        return data;
    }
}

