/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.tileentity;

import com.someguyssoftware.gottschcore.GottschCore;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.tileentity.AbstractModTileEntity;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.tileentity.IProximityTileEntity;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;

public abstract class AbstractProximityTileEntity
extends AbstractModTileEntity
implements IProximityTileEntity,
ITickable {
    private double proximity;
    private boolean isDead = false;

    public AbstractProximityTileEntity() {
    }

    public AbstractProximityTileEntity(double proximity) {
        this.setProximity(proximity);
    }

    public void func_145839_a(NBTTagCompound parentNBT) {
        super.func_145839_a(parentNBT);
        try {
            if (parentNBT.func_150297_b("proximity", 8)) {
                this.proximity = parentNBT.func_74769_h("proximity");
            }
        }
        catch (Exception e) {
            Treasure.logger.error("Error reading AbstractProximity properties from NBT:", (Throwable)e);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74780_a("proximity", this.getProximity());
        return tag;
    }

    public void func_73660_a() {
        if (WorldInfo.isClientSide()) {
            return;
        }
        EntityPlayer player = null;
        boolean isTriggered = false;
        double proximitySq = this.getProximity() * this.getProximity();
        if (proximitySq < 1.0) {
            proximitySq = 1.0;
        }
        for (int playerIndex = 0; playerIndex < this.func_145831_w().field_73010_i.size(); ++playerIndex) {
            player = (EntityPlayer)this.func_145831_w().field_73010_i.get(playerIndex);
            double distanceSq = player.func_174818_b(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5));
            if (!isTriggered && !this.isDead && distanceSq < proximitySq) {
                GottschCore.logger.debug("PTE proximity was met.");
                isTriggered = true;
                this.execute(this.func_145831_w(), new Random(), new Coords(this.func_174877_v()), new Coords(player.func_180425_c()));
            }
            if (this.isDead) break;
        }
    }

    @Override
    public abstract void execute(World var1, Random var2, Coords var3, Coords var4);

    @Override
    public double getProximity() {
        return this.proximity;
    }

    @Override
    public void setProximity(double proximity) {
        this.proximity = proximity;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public void setDead(boolean isDead) {
        this.isDead = isDead;
    }
}

