/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.tileentity;

import com.someguyssoftware.gottschcore.tileentity.AbstractModTileEntity;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.inventory.InventoryProxy;
import com.someguyssoftware.treasure2.lock.LockState;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class AbstractTreasureChestTileEntity
extends AbstractModTileEntity
implements ITickable {
    private List<LockState> lockStates;
    private int facing;
    private InventoryProxy inventoryProxy;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    public int ticksSinceSync;
    private int numberOfSlots = 27;
    private NonNullList<ItemStack> items = NonNullList.func_191197_a((int)this.getNumberOfSlots(), (Object)ItemStack.field_190927_a);
    private String customName;

    public AbstractTreasureChestTileEntity() {
        this.setFacing(EnumFacing.NORTH.func_176745_a());
        this.setInventoryProxy(new InventoryProxy(this));
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (WorldInfo.isServerSide(this.func_145831_w()) && this.numPlayersUsing != 0 && (this.ticksSinceSync + i + j + k) % 200 == 0) {
            this.numPlayersUsing = 0;
            float f = 5.0f;
            for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)i - 5.0f), (double)((float)j - 5.0f), (double)((float)k - 5.0f), (double)((float)(i + 1) + 5.0f), (double)((float)(j + 1) + 5.0f), (double)((float)(k + 1) + 5.0f)))) {
                IInventory iinventory;
                if (!(entityplayer.field_71070_bA instanceof ContainerChest) || (iinventory = ((ContainerChest)entityplayer.field_71070_bA).func_85151_d()) != this.getInventoryProxy()) continue;
                ++this.numPlayersUsing;
            }
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)i + 0.5;
            double d2 = (double)k + 0.5;
            this.field_145850_b.func_184148_a((EntityPlayer)null, d1, (double)j + 0.5, d2, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            float f3 = 0.5f;
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                double d3 = (double)i + 0.5;
                double d0 = (double)k + 0.5;
                this.field_145850_b.func_184148_a((EntityPlayer)null, d3, (double)j + 0.5, d0, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound parentNBT) {
        try {
            parentNBT = super.func_189515_b(parentNBT);
            this.writeLockStatesToNBT(parentNBT);
            this.writeInventoryToNBT(parentNBT);
            this.writePropertiesToNBT(parentNBT);
        }
        catch (Exception e) {
            Treasure.logger.error("Error writing to NBT:", (Throwable)e);
        }
        return parentNBT;
    }

    public NBTTagCompound writeLockStatesToNBT(NBTTagCompound parentNBT) {
        try {
            if (this.getLockStates() != null && !this.getLockStates().isEmpty()) {
                NBTTagList list = new NBTTagList();
                for (LockState state : this.getLockStates()) {
                    NBTTagCompound stateNBT = new NBTTagCompound();
                    state.writeToNBT(stateNBT);
                    list.func_74742_a((NBTBase)stateNBT);
                }
                parentNBT.func_74782_a("lockStates", (NBTBase)list);
            }
        }
        catch (Exception e) {
            Treasure.logger.error("Error writing LockStates to NBT:", (Throwable)e);
        }
        return parentNBT;
    }

    public NBTTagCompound writePropertiesToNBT(NBTTagCompound parentNBT) {
        try {
            if (this.hasCustomName()) {
                parentNBT.func_74778_a("CustomName", this.customName);
            }
            parentNBT.func_74768_a("facing", this.getFacing());
        }
        catch (Exception e) {
            Treasure.logger.error("Error writing Properties to NBT:", (Throwable)e);
        }
        return parentNBT;
    }

    public NBTTagCompound writeInventoryToNBT(NBTTagCompound parentNBT) {
        try {
            ItemStackHelper.func_191282_a((NBTTagCompound)parentNBT, this.getItems());
        }
        catch (Exception e) {
            Treasure.logger.error("Error writing Inventory to NBT:", (Throwable)e);
        }
        return parentNBT;
    }

    public void readInventoryFromNBT(NBTTagCompound parentNBT) {
        try {
            ItemStackHelper.func_191283_b((NBTTagCompound)parentNBT, this.getItems());
        }
        catch (Exception e) {
            Treasure.logger.error("Error reading Properties from NBT:", (Throwable)e);
        }
    }

    public void readLockStatesFromNBT(NBTTagCompound parentNBT) {
        try {
            if (parentNBT.func_74764_b("lockStates")) {
                if (this.getLockStates() == null) {
                    this.setLockStates(new LinkedList<LockState>());
                }
                LinkedList<LockState> states = new LinkedList<LockState>();
                NBTTagList list = parentNBT.func_150295_c("lockStates", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound c = list.func_150305_b(i);
                    LockState lockState = LockState.readFromNBT(c);
                    states.add(lockState.getSlot().getIndex(), lockState);
                }
                this.setLockStates(states);
            }
        }
        catch (Exception e) {
            Treasure.logger.error("Error reading Lock States from NBT:", (Throwable)e);
        }
    }

    public void readPropertiesFromNBT(NBTTagCompound parentNBT) {
        try {
            if (parentNBT.func_150297_b("CustomName", 8)) {
                this.customName = parentNBT.func_74779_i("CustomName");
            }
            if (parentNBT.func_74764_b("facing")) {
                this.setFacing(parentNBT.func_74762_e("facing"));
            }
        }
        catch (Exception e) {
            Treasure.logger.error("Error reading Properties from NBT:", (Throwable)e);
        }
    }

    public void func_145839_a(NBTTagCompound parentNBT) {
        super.func_145839_a(parentNBT);
        try {
            this.readLockStatesFromNBT(parentNBT);
            this.readInventoryFromNBT(parentNBT);
            this.readPropertiesFromNBT(parentNBT);
        }
        catch (Exception e) {
            Treasure.logger.error("Error reading to NBT:", (Throwable)e);
        }
    }

    public void readFromItemStackNBT(NBTTagCompound nbt) {
        try {
            this.readLockStatesFromNBT(nbt);
            this.readInventoryFromNBT(nbt);
            this.readPropertiesFromNBT(nbt);
        }
        catch (Exception e) {
            Treasure.logger.error("Error reading to NBT:", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void sendUpdates() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        this.func_70296_d();
    }

    private IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public List<LockState> getLockStates() {
        return this.lockStates;
    }

    public void setLockStates(List<LockState> lockStates) {
        this.lockStates = lockStates;
    }

    public boolean hasLocks() {
        if (this.getLockStates() == null || this.getLockStates().isEmpty()) {
            return false;
        }
        for (LockState state : this.getLockStates()) {
            if (state.getLock() == null) continue;
            return true;
        }
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public String getName() {
        return this.hasCustomName() ? this.getCustomName() : "container.chest";
    }

    public boolean hasCustomName() {
        return this.getCustomName() != null && this.getCustomName().length() > 0;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public int getNumberOfSlots() {
        return this.numberOfSlots;
    }

    public void setNumberOfSlots(int numberOfSlots) {
        this.numberOfSlots = numberOfSlots;
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(NonNullList<ItemStack> chestContents) {
        this.items = chestContents;
    }

    public InventoryProxy getInventoryProxy() {
        return this.inventoryProxy;
    }

    public void setInventoryProxy(InventoryProxy inventoryProxy) {
        this.inventoryProxy = inventoryProxy;
    }

    public int getFacing() {
        return this.facing;
    }

    public void setFacing(int facing) {
        this.facing = facing;
    }
}

