/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.tileentity;

import com.someguyssoftware.gottschcore.measurement.Quantity;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.entity.monster.BoundSoulEntity;
import com.someguyssoftware.treasure2.tileentity.ProximitySpawnerTileEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class GravestoneProximitySpawnerTileEntity
extends ProximitySpawnerTileEntity {
    private boolean hasEntity;

    public GravestoneProximitySpawnerTileEntity() {
        this.setProximity(20.0);
        this.setMobName(new ResourceLocation("treasure2", "bound_soul"));
        this.setMobNum(new Quantity(1.0, 1.0));
        this.setSpawnRange(2.0);
        this.setHasEntity(false);
    }

    @Override
    public void func_73660_a() {
        boolean hasEntity = this.hasEntity();
        if (hasEntity && TreasureConfig.WORLD_GEN.getMarkerProperties().isGravestoneSpawnMobAllowed) {
            super.func_73660_a();
        }
    }

    @Override
    public void execute(World world, Random random, Coords blockCoords, Coords playerCoords) {
        int mobCount = RandomHelper.randomInt(random, this.getMobNum().getMinInt(), this.getMobNum().getMaxInt());
        for (int i = 0; i < mobCount; ++i) {
            BoundSoulEntity entity = (BoundSoulEntity)EntityList.func_188429_b((ResourceLocation)this.getMobName(), (World)world);
            if (entity == null) {
                Treasure.logger.debug("unable to create entity -> {}", (Object)this.getMobName());
                this.selfDestruct();
                return;
            }
            entity.func_175449_a(blockCoords.toPos(), 10);
            double x = (double)blockCoords.getX() + world.field_73012_v.nextDouble() * this.getSpawnRange() - this.getSpawnRange() / 2.0 + 0.5;
            double y = blockCoords.getY();
            double z = (double)blockCoords.getZ() + world.field_73012_v.nextDouble() * this.getSpawnRange() - this.getSpawnRange() / 2.0 + 0.5;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            if (!(entity instanceof EntityLiving)) continue;
            BoundSoulEntity entityLiving = entity;
            if (entityLiving.func_70601_bi() && entityLiving.func_70058_J()) {
                ((EntityLiving)entityLiving).field_70759_as = ((EntityLiving)entityLiving).field_70177_z;
                ((EntityLiving)entityLiving).field_70761_aq = ((EntityLiving)entityLiving).field_70177_z;
                entityLiving.func_180482_a(world.func_175649_E(new BlockPos((Entity)entityLiving)), null);
                world.func_72838_d((Entity)entity);
                entityLiving.func_70642_aH();
            }
            this.setHasEntity(false);
        }
        this.selfDestruct();
    }

    private void selfDestruct() {
        Treasure.logger.debug("self destructing.");
        this.setDead(true);
    }

    @Override
    public void func_145839_a(NBTTagCompound parentNBT) {
        super.func_145839_a(parentNBT);
        try {
            if (parentNBT.func_150297_b("hasEntity", 8)) {
                this.hasEntity = parentNBT.func_74767_n("hasEntity");
                Treasure.logger.debug("value of nbt entity -> {}", (Object)parentNBT.func_74767_n("hasEntity"));
            }
        }
        catch (Exception e) {
            Treasure.logger.error("Error reading AbstractProximity properties from NBT:", (Throwable)e);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("hasEntity", this.hasEntity());
        return tag;
    }

    public boolean hasEntity() {
        return this.hasEntity;
    }

    public void setHasEntity(boolean hasEntity) {
        this.hasEntity = hasEntity;
    }
}

