/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.world.gen.structure;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.someguyssoftware.gottschcore.meta.IMetaArchetype;
import com.someguyssoftware.gottschcore.meta.IMetaType;
import com.someguyssoftware.gottschcore.mod.IMod;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.gottschcore.world.gen.structure.GottschTemplateManager;
import com.someguyssoftware.gottschcore.world.gen.structure.StructureMarkers;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.meta.StructureArchetype;
import com.someguyssoftware.treasure2.meta.StructureMeta;
import com.someguyssoftware.treasure2.meta.StructureType;
import com.someguyssoftware.treasure2.world.gen.structure.TemplateHolder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.io.IOUtils;

public class TreasureTemplateManager
extends GottschTemplateManager {
    private final Map<ResourceLocation, TemplateHolder> templatesByResourceLocation = new HashMap<ResourceLocation, TemplateHolder>();
    private final Table<IMetaArchetype, IMetaType, List<TemplateHolder>> templatesByArchetypeType = HashBasedTable.create();
    private final Table<String, Integer, List<TemplateHolder>> templatesByArchetypeTypeBiome = HashBasedTable.create();
    private static List<String> FOLDER_LOCATIONS = ImmutableList.of((Object)"surface", (Object)"subterranean", (Object)"submerged", (Object)"float", (Object)"wells");
    private Map<StructureMarkers, Block> waterMarkerMap;

    public TreasureTemplateManager(IMod mod, String resourceFolder, DataFixer fixer) {
        super(mod, resourceFolder, fixer);
        Treasure.logger.debug("creating a TreasureTemplateManager");
        this.waterMarkerMap = Maps.newHashMap(this.getMarkerMap());
        this.waterMarkerMap.put(StructureMarkers.NULL, Blocks.field_150350_a);
        for (StructureArchetype archetype : StructureArchetype.values()) {
            for (StructureType type : StructureType.values()) {
                this.templatesByArchetypeType.put((Object)archetype, (Object)type, new ArrayList(5));
            }
        }
        if (TreasureConfig.MOD.enableDefaultTemplatesCheck) {
            this.buildAndExpose(this.getBaseResourceFolder(), "treasure2", FOLDER_LOCATIONS);
        }
    }

    public void clear() {
        this.templatesByArchetypeTypeBiome.clear();
        this.templatesByArchetypeType.clear();
    }

    public void register(String modID) {
        for (String location : FOLDER_LOCATIONS) {
            Treasure.logger.debug("registering templates under location -> {}", (Object)location);
            List<ResourceLocation> locs = this.getResourceLocations(modID, location);
            for (ResourceLocation loc : locs) {
                Path path = Paths.get(loc.func_110623_a(), new String[0]);
                if (Treasure.logger.isDebugEnabled()) {
                    Treasure.logger.debug("path to template resource loc -> {}", (Object)path.toString());
                }
                ResourceLocation metaResourceLocation = new ResourceLocation(this.getMod().getId() + ":" + Treasure.META_MANAGER.getBaseResourceFolder() + "/" + modID + "/structures/" + path.getFileName().toString().replace(".nbt", ".json"));
                String key = metaResourceLocation.toString();
                Treasure.logger.debug("Using key to find meta -> {}", (Object)key);
                StructureMeta meta = (StructureMeta)Treasure.META_MANAGER.getMetaMap().get(key);
                if (meta == null) {
                    Treasure.logger.info("Unable to locate meta file for resource -> {}", (Object)key);
                    continue;
                }
                if (meta.getArchetypes() == null || meta.getArchetypes().isEmpty() || meta.getType() == null) {
                    Treasure.logger.info("Meta file not properly configured. -> {}", (Object)key);
                    continue;
                }
                Treasure.logger.debug("attempted to load custom template  with key -> {}", (Object)loc.toString());
                Template template = this.load(loc, this.getMarkerScanList(), this.getReplacementMap());
                if (template == null) continue;
                Treasure.logger.debug("loaded custom template  with key -> {}", (Object)loc.toString());
                ArrayList<ResourceLocation> decayRuleSetResourceLocation = new ArrayList<ResourceLocation>();
                if (meta.getDecayRuleSetName() != null && meta.getDecayRuleSetName().size() > 0) {
                    for (String ruleSetName : meta.getDecayRuleSetName()) {
                        ResourceLocation resourceLocation = new ResourceLocation(this.getMod().getId() + ":" + Treasure.DECAY_MANAGER.getBaseResourceFolder() + "/" + modID + "/" + ruleSetName + ".json");
                        decayRuleSetResourceLocation.add(resourceLocation);
                        Treasure.logger.debug("Using key to find decay ruleset -> {}", (Object)((Object)decayRuleSetResourceLocation).toString());
                    }
                }
                TemplateHolder holder = new TemplateHolder().setMetaLocation(metaResourceLocation).setLocation(loc).setDecayRuleSetLocation(decayRuleSetResourceLocation).setTemplate(template);
                this.getTemplatesByResourceLocationMap().put(loc, holder);
                for (IMetaArchetype archetype : meta.getArchetypes()) {
                    Treasure.logger.debug("Using meta to map archetype type -> {}", (Object)meta.toString());
                    if (!this.templatesByArchetypeType.contains((Object)archetype, (Object)meta.getType())) {
                        this.templatesByArchetypeType.put((Object)archetype, (Object)meta.getType(), new ArrayList(3));
                    }
                    ((List)this.templatesByArchetypeType.get((Object)archetype, (Object)meta.getType())).add(holder);
                    Treasure.logger.debug("Registered holder -> location -> {}, meta -> {}, decay -> {}", (Object)holder.getLocation(), (Object)holder.getMetaLocation(), holder.getDecayRuleSetLocation());
                    this.mapToTemplatesByArchetypeBiome(metaResourceLocation, loc, decayRuleSetResourceLocation, archetype, meta.getType(), template);
                }
            }
        }
        if (Treasure.logger.isDebugEnabled()) {
            this.dump();
        }
    }

    private void mapToTemplatesByArchetypeBiome(ResourceLocation metaResourceLocation, ResourceLocation location, List<ResourceLocation> decayResourceLocation, IMetaArchetype archetype, IMetaType type, Template template) {
        block10: {
            Integer biomeID;
            TemplateHolder holder;
            StructureMeta meta;
            String key;
            block11: {
                block9: {
                    key = archetype.getName() + ":" + type.getName();
                    meta = (StructureMeta)Treasure.META_MANAGER.getMetaMap().get(metaResourceLocation.toString());
                    holder = new TemplateHolder().setMetaLocation(metaResourceLocation).setDecayRuleSetLocation(decayResourceLocation).setLocation(location).setTemplate(template);
                    if (!meta.getBiomeWhiteList().contains("*") && (!meta.getBiomeWhiteList().isEmpty() || !meta.getBiomeBlackList().isEmpty())) break block9;
                    Set biomes = (Set)ForgeRegistries.BIOMES.getValuesCollection();
                    for (Biome biome : biomes) {
                        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
                        Integer biomeID2 = Biome.func_185362_a((Biome)biome);
                        if (!this.templatesByArchetypeTypeBiome.contains((Object)key, (Object)biomeID2)) {
                            this.templatesByArchetypeTypeBiome.put((Object)key, (Object)biomeID2, new ArrayList(3));
                        }
                        ((List)this.templatesByArchetypeTypeBiome.get((Object)key, (Object)biomeID2)).add(holder);
                    }
                    break block10;
                }
                if (meta.getBiomeWhiteList().isEmpty()) break block11;
                for (String b : meta.getBiomeWhiteList()) {
                    String biomeName = b.trim().toLowerCase();
                    Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(biomeName));
                    if (biome == null) {
                        Treasure.logger.debug("Unable to locate biome for name -> {}", (Object)biomeName);
                        continue;
                    }
                    if (biome == null || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
                    Integer biomeID3 = Biome.func_185362_a((Biome)biome);
                    if (!this.templatesByArchetypeTypeBiome.contains((Object)key, (Object)biomeID3)) {
                        this.templatesByArchetypeTypeBiome.put((Object)key, (Object)biomeID3, new ArrayList(3));
                    }
                    ((List)this.templatesByArchetypeTypeBiome.get((Object)key, (Object)biomeID3)).add(holder);
                }
                break block10;
            }
            if (meta.getBiomeBlackList().isEmpty()) break block10;
            ArrayList<Integer> blackListBiomeIDs = new ArrayList<Integer>();
            for (String b : meta.getBiomeBlackList()) {
                Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(b.trim().toLowerCase()));
                if (biome != null) {
                    biomeID = Biome.func_185362_a((Biome)biome);
                    if (biomeID == null) continue;
                    blackListBiomeIDs.add(biomeID);
                    continue;
                }
                Treasure.logger.debug("Unable to locate biome for name -> {}", (Object)b);
            }
            Set biomes = (Set)ForgeRegistries.BIOMES.getValuesCollection();
            for (Biome biome : biomes) {
                if (blackListBiomeIDs.contains(Biome.func_185362_a((Biome)biome)) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
                biomeID = Biome.func_185362_a((Biome)biome);
                if (!this.templatesByArchetypeTypeBiome.contains((Object)key, (Object)biomeID)) {
                    this.templatesByArchetypeTypeBiome.put((Object)key, (Object)biomeID, new ArrayList(3));
                }
                ((List)this.templatesByArchetypeTypeBiome.get((Object)key, (Object)biomeID)).add(holder);
            }
        }
    }

    public TemplateHolder getTemplate(World world, Random random, StructureArchetype archetype, StructureType type, Biome biome) {
        String key = archetype.getName() + ":" + type.getName();
        Integer biomeID = Biome.func_185362_a((Biome)biome);
        List templateHolders = (List)this.getTemplatesByArchetypeTypeBiomeTable().get((Object)key, (Object)biomeID);
        if (templateHolders == null || templateHolders.isEmpty()) {
            Treasure.logger.debug("could not find template holders for archetype:type, biome -> {} {}", (Object)key, (Object)biomeID);
            return null;
        }
        TemplateHolder holder = (TemplateHolder)templateHolders.get(random.nextInt(templateHolders.size()));
        if (holder == null) {
            Treasure.logger.debug("could not find random template holder.");
            return null;
        }
        Treasure.logger.debug("selected template holder -> {} : {}", (Object)holder.getLocation(), (Object)holder.getMetaLocation());
        return holder;
    }

    @Override
    public GottschTemplateManager loadAll(List<String> locations) {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean writeTemplate(@Nullable MinecraftServer server, ResourceLocation id) {
        boolean bl;
        String s = id.func_110623_a();
        if (server == null || !this.getTemplates().containsKey(s)) return false;
        File file1 = new File(this.getBaseResourceFolder());
        if (!file1.exists() ? !file1.mkdirs() : !file1.isDirectory()) {
            return false;
        }
        File file2 = new File(file1, s + ".nbt");
        Template template = this.getTemplates().get(s);
        FileOutputStream outputstream = null;
        try {
            NBTTagCompound nbttagcompound = template.func_189552_a(new NBTTagCompound());
            outputstream = new FileOutputStream(file2);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)outputstream);
            bl = true;
        }
        catch (Throwable var13) {
            try {
                boolean flag = false;
                return flag;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(outputstream);
            }
        }
        IOUtils.closeQuietly((OutputStream)outputstream);
        return bl;
    }

    public void dump() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyymmdd");
        String filename = String.format("treasure-template-mgr-%s.txt", formatter.format(new Date()));
        Path path = Paths.get(this.getMod().getConfig().getConfigFolder(), this.getMod().getId(), "dumps").toAbsolutePath();
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            Treasure.logger.error("Couldn't create directories for dump files:", (Throwable)e);
            return;
        }
        char[] chars = new char[75];
        Arrays.fill(chars, '*');
        String div = new String(chars) + "\n";
        StringBuilder sb = new StringBuilder();
        String format = "**    %1$-33s: %2$-30s  **\n";
        String format2 = "**    %1$-15s: %2$-15s: %3$-33s  **\n";
        String heading = "**  %1$-67s  **\n";
        sb.append(div).append(String.format("**  %-67s  **\n", "TEMPLATE MANAGER")).append(div).append(String.format(heading, "[Template By Type Map]"));
        for (Map.Entry<String, Template> entry : this.getTemplates().entrySet()) {
            sb.append(String.format(format, entry.getKey(), entry.getValue().func_186261_b()));
        }
        sb.append(div);
        sb.append(String.format(heading, "[Template by Archetype:Type | Biome]"));
        Map map = this.getTemplatesByArchetypeTypeBiomeTable().rowMap();
        if (map == null || map.isEmpty()) {
            Treasure.logger.debug("template biome map is null/empty");
        }
        Treasure.logger.debug("biome map.size -> {}", (Object)map.size());
        for (String row : map.keySet()) {
            Treasure.logger.debug("template biome row key -> {}", (Object)row);
            Map tmp = (Map)map.get(row);
            for (Map.Entry entry : tmp.entrySet()) {
                String templateNames = ((List)entry.getValue()).stream().map(a -> a.getLocation().toString()).collect(Collectors.joining(", "));
                Biome biome = Biome.func_150568_d((int)((Integer)entry.getKey()));
                String biomeName = "";
                biomeName = biome != null ? (WorldInfo.isClientSide() ? biome.func_185359_l() : String.valueOf(Biome.func_185362_a((Biome)biome))) : String.format("No biome for {}", entry.getKey());
                sb.append(String.format(format2, row, biomeName, templateNames));
            }
        }
        try {
            Files.write(Paths.get(path.toString(), filename), sb.toString().getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            Treasure.logger.error("Error writing TreasureTemplateManager to dump file", (Throwable)iOException);
        }
    }

    public Map<ResourceLocation, TemplateHolder> getTemplatesByResourceLocationMap() {
        return this.templatesByResourceLocation;
    }

    public Table<String, Integer, List<TemplateHolder>> getTemplatesByArchetypeTypeBiomeTable() {
        return this.templatesByArchetypeTypeBiome;
    }
}

