/*
 * Decompiled with CFR 0.152.
 */
package com.someguyssoftware.treasure2.worldgen;

import com.someguyssoftware.gottschcore.biome.BiomeHelper;
import com.someguyssoftware.gottschcore.positional.Coords;
import com.someguyssoftware.gottschcore.positional.ICoords;
import com.someguyssoftware.gottschcore.random.RandomHelper;
import com.someguyssoftware.gottschcore.random.RandomWeightedCollection;
import com.someguyssoftware.gottschcore.world.WorldInfo;
import com.someguyssoftware.treasure2.Treasure;
import com.someguyssoftware.treasure2.biome.TreasureBiomeHelper;
import com.someguyssoftware.treasure2.chest.ChestInfo;
import com.someguyssoftware.treasure2.config.IChestConfig;
import com.someguyssoftware.treasure2.config.TreasureConfig;
import com.someguyssoftware.treasure2.enums.Rarity;
import com.someguyssoftware.treasure2.generator.ChestGeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorData;
import com.someguyssoftware.treasure2.generator.GeneratorResult;
import com.someguyssoftware.treasure2.generator.chest.CauldronChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.CommonChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.EpicChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.GoldSkullChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.IChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.RareChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.ScarceChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.SkullChestGenerator;
import com.someguyssoftware.treasure2.generator.chest.UncommonChestGenerator;
import com.someguyssoftware.treasure2.generator.ruins.SubmergedRuinGenerator;
import com.someguyssoftware.treasure2.persistence.GenDataPersistence;
import com.someguyssoftware.treasure2.registry.ChestRegistry;
import com.someguyssoftware.treasure2.worldgen.ITreasureWorldGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;

public class SubmergedChestWorldGenerator
implements ITreasureWorldGenerator {
    private int chunksSinceLastChest;
    private Map<Rarity, Integer> chunksSinceLastRarityChest;
    private Map<Rarity, RandomWeightedCollection<IChestGenerator>> chestCollectionGeneratorsMap = new HashMap<Rarity, RandomWeightedCollection<IChestGenerator>>();
    private static final List<Rarity> RARITIES = new ArrayList<Rarity>();

    public SubmergedChestWorldGenerator() {
        try {
            this.init();
        }
        catch (Exception e) {
            Treasure.logger.error("Unable to instantiate SurfaceChestGenerator:", (Throwable)e);
        }
    }

    @Override
    public void init() {
        RARITIES.clear();
        this.chunksSinceLastChest = 0;
        this.chunksSinceLastRarityChest = new HashMap<Rarity, Integer>(Rarity.values().length);
        for (Rarity rarity : Rarity.values()) {
            this.chunksSinceLastRarityChest.put(rarity, 0);
        }
        if (TreasureConfig.CHESTS.submergedChests.configMap.get(Rarity.COMMON).isEnableChest()) {
            RARITIES.add(Rarity.COMMON);
            this.chestCollectionGeneratorsMap.put(Rarity.COMMON, new RandomWeightedCollection());
            this.chestCollectionGeneratorsMap.get(Rarity.COMMON).add(1, new CommonChestGenerator());
        }
        if (TreasureConfig.CHESTS.submergedChests.configMap.get(Rarity.UNCOMMON).isEnableChest()) {
            RARITIES.add(Rarity.UNCOMMON);
            this.chestCollectionGeneratorsMap.put(Rarity.UNCOMMON, new RandomWeightedCollection());
            this.chestCollectionGeneratorsMap.get(Rarity.UNCOMMON).add(1, new UncommonChestGenerator());
        }
        if (TreasureConfig.CHESTS.submergedChests.configMap.get(Rarity.SCARCE).isEnableChest()) {
            RARITIES.add(Rarity.SCARCE);
            this.chestCollectionGeneratorsMap.put(Rarity.SCARCE, new RandomWeightedCollection());
            this.chestCollectionGeneratorsMap.get(Rarity.SCARCE).add(75, new ScarceChestGenerator());
            this.chestCollectionGeneratorsMap.get(Rarity.SCARCE).add(25, new SkullChestGenerator());
        }
        if (TreasureConfig.CHESTS.submergedChests.configMap.get(Rarity.RARE).isEnableChest()) {
            RARITIES.add(Rarity.RARE);
            this.chestCollectionGeneratorsMap.put(Rarity.RARE, new RandomWeightedCollection());
            this.chestCollectionGeneratorsMap.get(Rarity.RARE).add(85, new RareChestGenerator());
            this.chestCollectionGeneratorsMap.get(Rarity.RARE).add(15, new GoldSkullChestGenerator());
        }
        if (TreasureConfig.CHESTS.submergedChests.configMap.get(Rarity.EPIC).isEnableChest()) {
            RARITIES.add(Rarity.EPIC);
            this.chestCollectionGeneratorsMap.put(Rarity.EPIC, new RandomWeightedCollection());
            this.chestCollectionGeneratorsMap.get(Rarity.EPIC).add(85, new EpicChestGenerator());
            this.chestCollectionGeneratorsMap.get(Rarity.EPIC).add(15, new CauldronChestGenerator());
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (TreasureConfig.WORLD_GEN.getGeneralProperties().getDimensionsWhiteList().contains(world.field_73011_w.getDimension())) {
            this.generate(world, random, chunkX, chunkZ);
        }
    }

    private void generate(World world, Random random, int chunkX, int chunkZ) {
        int xSpawn = chunkX * 16 + 8;
        int zSpawn = chunkZ * 16 + 8;
        Coords coords = new Coords(xSpawn, 0, zSpawn);
        Biome biome = world.func_180494_b(coords.toPos());
        if (biome != Biomes.field_76771_b && biome != Biomes.field_150575_M && biome != Biomes.field_76776_l && !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            return;
        }
        ++this.chunksSinceLastChest;
        for (Rarity rarity : RARITIES) {
            Integer i = this.chunksSinceLastRarityChest.get(rarity);
            i = i + 1;
            this.chunksSinceLastRarityChest.put(rarity, i);
        }
        if (this.chunksSinceLastChest > TreasureConfig.CHESTS.submergedChests.minChunksPerChest) {
            GenDataPersistence savedData;
            Rarity rarity;
            int ySpawn = world.func_72964_e(chunkX, chunkZ).func_76611_b(8, 8);
            coords = new Coords(xSpawn, ySpawn, zSpawn);
            rarity = RARITIES.get(random.nextInt(RARITIES.size()));
            IChestConfig chestConfig = TreasureConfig.CHESTS.submergedChests.configMap.get(rarity);
            if (chestConfig == null) {
                Treasure.logger.warn("Unable to locate a chest for rarity {}.", (Object)rarity);
                return;
            }
            if (this.chunksSinceLastRarityChest.get(rarity) >= chestConfig.getChunksPerChest()) {
                if (!RandomHelper.checkProbability(random, chestConfig.getGenProbability())) {
                    Treasure.logger.debug("Submerged chest does not meet generate probability.");
                    return;
                }
                TreasureBiomeHelper.Result biomeCheck = TreasureBiomeHelper.isBiomeAllowed(biome, chestConfig.getBiomeWhiteList(), chestConfig.getBiomeBlackList());
                if (biomeCheck == TreasureBiomeHelper.Result.BLACK_LISTED) {
                    if (WorldInfo.isClientSide(world)) {
                        Treasure.logger.debug("{} is not a valid biome @ {}", (Object)biome.func_185359_l(), (Object)coords.toShortString());
                    } else {
                        Treasure.logger.debug("Biome {} is not valid @ {}", (Object)rarity.getValue(), (Object)coords.toShortString());
                    }
                    return;
                }
                if (biomeCheck == TreasureBiomeHelper.Result.OK && !BiomeHelper.isBiomeAllowed(biome, chestConfig.getBiomeTypeWhiteList(), chestConfig.getBiomeTypeBlackList())) {
                    if (Treasure.logger.isDebugEnabled()) {
                        if (WorldInfo.isClientSide(world)) {
                            Treasure.logger.debug("{} is not a valid biome type @ {}", (Object)biome.func_185359_l(), (Object)coords.toShortString());
                        } else {
                            Treasure.logger.debug("Biome type of {} is not valid @ {}", (Object)rarity.getValue(), (Object)coords.toShortString());
                        }
                    }
                    return;
                }
                if (this.isRegisteredChestWithinDistance(world, coords, TreasureConfig.CHESTS.submergedChests.minDistancePerChest)) {
                    Treasure.logger.debug("The distance to the nearest treasure chest is less than the minimun required.");
                    return;
                }
                this.chunksSinceLastRarityChest.put(rarity, 0);
                Treasure.logger.debug("Attempting to generate pit/chest.");
                GeneratorResult<GeneratorData> result = null;
                result = this.generate(world, random, coords, rarity, this.chestCollectionGeneratorsMap.get(rarity).next(), TreasureConfig.CHESTS.submergedChests.configMap.get(rarity));
                if (result.isSuccess()) {
                    ChestRegistry.getInstance().register(coords.toShortString(), new ChestInfo(rarity, coords));
                    this.chunksSinceLastChest = 0;
                }
            }
            if ((savedData = GenDataPersistence.get(world)) != null) {
                savedData.func_76185_a();
            }
        }
    }

    public GeneratorResult<GeneratorData> generate(World world, Random random, ICoords coords, Rarity chestRarity, IChestGenerator chestSelector, IChestConfig config) {
        ICoords chestCoords = null;
        ICoords markerCoords = null;
        GeneratorResult<GeneratorData> result = new GeneratorResult<GeneratorData>(GeneratorData.class);
        GeneratorResult<ChestGeneratorData> genResult = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        ICoords surfaceCoords = WorldInfo.getOceanFloorSurfaceCoords(world, coords);
        Treasure.logger.debug("ocean floor surface coords -> {}", (Object)surfaceCoords.toShortString());
        if (!WorldInfo.isValidY(surfaceCoords)) {
            Treasure.logger.debug("ocean floor surface coords are invalid @ {}", (Object)surfaceCoords.toShortString());
            return result.fail();
        }
        markerCoords = surfaceCoords;
        genResult = this.generateSubmergedRuins(world, random, surfaceCoords, config);
        Treasure.logger.debug("submerged result -> {}", (Object)genResult.toString());
        if (!genResult.isSuccess()) {
            return result.fail();
        }
        if (genResult.getData().getChestContext() == null) {
            return result.fail();
        }
        chestCoords = genResult.getData().getChestContext().getCoords();
        if (chestCoords == null) {
            return result.fail();
        }
        markerCoords = genResult.getData().getSpawnCoords();
        if (markerCoords == null) {
            markerCoords = surfaceCoords;
        }
        Treasure.logger.debug("submerged spawn coords -> {}", (Object)markerCoords.toShortString());
        GeneratorResult<ChestGeneratorData> chestResult = chestSelector.generate(world, random, chestCoords, chestRarity, genResult.getData().getChestContext().getState());
        if (!chestResult.isSuccess()) {
            return result.fail();
        }
        Treasure.logger.info("CHEATER! {} chest at coords: {}", (Object)chestRarity, (Object)markerCoords.toShortString());
        result.setData(chestResult.getData());
        return result.success();
    }

    public GeneratorResult<ChestGeneratorData> generateSubmergedRuins(World world, Random random, ICoords spawnCoords, IChestConfig config) {
        GeneratorResult<ChestGeneratorData> result = new GeneratorResult<ChestGeneratorData>(ChestGeneratorData.class);
        result.getData().setSpawnCoords(spawnCoords);
        SubmergedRuinGenerator generator = new SubmergedRuinGenerator();
        GeneratorResult<ChestGeneratorData> genResult = generator.generate(world, random, spawnCoords);
        Treasure.logger.debug("submerged struct result -> {}", genResult);
        if (!genResult.isSuccess()) {
            return result.fail();
        }
        result.setData(genResult.getData());
        return result.success();
    }

    private void generateNether(World world, Random random, int i, int j) {
    }

    private void generateEnd(World world, Random random, int i, int j) {
    }

    public boolean isRegisteredChestWithinDistance(World world, ICoords coords, int minDistance) {
        double minDistanceSq = minDistance * minDistance;
        List<ChestInfo> infos = ChestRegistry.getInstance().getValues();
        if (infos == null || infos.size() == 0) {
            Treasure.logger.debug("Unable to locate the ChestConfig Registry or the Registry doesn't contain any values");
            return false;
        }
        for (ChestInfo info : infos) {
            double distance = coords.getDistanceSq(info.getCoords());
            if (!(distance < minDistanceSq)) continue;
            return true;
        }
        return false;
    }

    public int getChunksSinceLastChest() {
        return this.chunksSinceLastChest;
    }

    public void setChunksSinceLastChest(int chunksSinceLastChest) {
        this.chunksSinceLastChest = chunksSinceLastChest;
    }

    public Map<Rarity, Integer> getChunksSinceLastRarityChest() {
        return this.chunksSinceLastRarityChest;
    }

    public void setChunksSinceLastRarityChest(Map<Rarity, Integer> chunksSinceLastRarityChest) {
        this.chunksSinceLastRarityChest = chunksSinceLastRarityChest;
    }

    public Map<Rarity, RandomWeightedCollection<IChestGenerator>> getChestCollectionGeneratorsMap() {
        return this.chestCollectionGeneratorsMap;
    }

    public void setChestCollectionGeneratorsMap(Map<Rarity, RandomWeightedCollection<IChestGenerator>> chestCollectionGeneratorsMap) {
        this.chestCollectionGeneratorsMap = chestCollectionGeneratorsMap;
    }
}

