/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.registry;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.registry.ModFeature;
import com.brandon3055.brandonscore.utils.DataUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public class Feature {
    private final String modid;
    private final String name;
    private final ResourceLocation registryName;
    private final boolean canBeDisabled;
    private boolean isActive;
    private final boolean hasItemBlock;
    private final Class<? extends ItemBlock> itemBlockClass;
    private final Class<? extends TileEntity> tileClass;
    private final int creativeTab;
    private final String stateOverride;
    public final String[] rawVariantMap;
    private final Map<Integer, String> variantMap = new HashMap<Integer, String>();

    private Feature(String modid, ModFeature modFeature) {
        this.modid = modid;
        this.name = modFeature.name();
        this.registryName = new ResourceLocation(modid, this.name);
        this.canBeDisabled = modFeature.canBeDisabled();
        this.isActive = modFeature.isActive();
        this.creativeTab = modFeature.cTab();
        this.tileClass = modFeature.tileEntity();
        this.itemBlockClass = modFeature.itemBlock();
        this.stateOverride = modFeature.stateOverride();
        this.rawVariantMap = modFeature.variantMap();
        this.hasItemBlock = modFeature.hasItemBlock();
        DataUtils.forEach(this.rawVariantMap, s -> this.variantMap.put(Integer.parseInt(s.substring(0, s.indexOf(":"))), s.substring(s.indexOf(":") + 1)));
    }

    public String getModid() {
        return this.modid;
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        boolean isBC;
        this.isActive = active;
        boolean bl = isBC = Loader.instance().activeModContainer() != null && Loader.instance().activeModContainer().matches((Object)BrandonsCore.instance);
        if (!isBC || Loader.instance().getLoaderState() != LoaderState.PREINITIALIZATION) {
            throw new RuntimeException("Attempted to call Feature.setActive by another mod! This method should only be called by BrandonsCore during ore init! No touchy!");
        }
    }

    public boolean canBeDisabled() {
        return this.canBeDisabled;
    }

    public Map<Integer, String> variantMap() {
        return this.variantMap;
    }

    public String stateOverride() {
        return this.stateOverride;
    }

    public boolean hasItemBlock() {
        return this.hasItemBlock;
    }

    public Class<? extends ItemBlock> itemBlock() {
        return this.itemBlockClass;
    }

    public Class<? extends TileEntity> tileEntity() {
        return this.tileClass;
    }

    public int creativeTab() {
        return this.creativeTab;
    }

    public static Feature extract(String modid, ModFeature modFeature) {
        return new Feature(modid, modFeature);
    }
}

