/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.electroblob;

import codersafterdark.compatskills.utils.Utils;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.RequirementHolder;
import codersafterdark.reskillable.base.LevelLockHandler;
import electroblob.wizardry.event.SpellBindEvent;
import electroblob.wizardry.tileentity.ContainerArcaneWorkbench;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WizardyEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onSpellBind(SpellBindEvent event) {
        ContainerArcaneWorkbench workbench;
        if (event.isCanceled() || !(event.getContainer() instanceof ContainerArcaneWorkbench)) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        if (Utils.skipPlayer(player)) {
            return;
        }
        PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
        if (this.testSlot(data, player, (workbench = (ContainerArcaneWorkbench)event.getContainer()).func_75139_a(8), "compatskills.error.wizardry.crystal")) {
            event.setCanceled(true);
        } else if (this.testSlot(data, player, workbench.func_75139_a(9), "compatskills.error.wizardry.center")) {
            event.setCanceled(true);
        } else if (this.testSlot(data, player, workbench.func_75139_a(10), "compatskills.error.wizardry.upgrade")) {
            event.setCanceled(true);
        } else {
            for (int i = 0; i < 8; ++i) {
                Slot spellSlot = workbench.func_75139_a(i);
                if (spellSlot.field_75223_e == -999 || spellSlot.field_75221_f == -999 || !this.testSlot(data, player, spellSlot, "compatskills.error.wizardry.spell")) continue;
                event.setCanceled(true);
                break;
            }
        }
    }

    private boolean testSlot(PlayerData data, EntityPlayer player, Slot slot, String translationKeyError) {
        ItemStack stack = slot.func_75211_c();
        if (stack.func_190926_b()) {
            return false;
        }
        RequirementHolder requirementHolder = LevelLockHandler.getSkillLock((ItemStack)stack);
        if (!requirementHolder.equals(LevelLockHandler.EMPTY_LOCK) && !data.matchStats(requirementHolder)) {
            TextComponentTranslation error = new TextComponentTranslation(translationKeyError, new Object[0]);
            player.func_146105_b(Utils.getError(requirementHolder, data, error), false);
            return true;
        }
        return false;
    }
}

