/*
 * Decompiled with CFR 0.152.
 */
package codersafterdark.compatskills.common.compats.tinkersconstruct.commands;

import codersafterdark.compatskills.common.compats.tinkersconstruct.modifierlocks.ModifierLockKey;
import codersafterdark.reskillable.api.data.LockKey;
import codersafterdark.reskillable.base.LevelLockHandler;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.commands.SpecialMessagesChat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IToolMod;

public class ModifierDumpCommand
extends CraftTweakerCommand {
    public ModifierDumpCommand() {
        super("tinkersmodifiers");
    }

    protected void init() {
        this.setDescription(new ITextComponent[]{SpecialMessagesChat.getClickableCommandText((String)(TextFormatting.DARK_GREEN + "/ct tinkersmodifiers"), (String)"/ct tinkersmodifiers", (boolean)true), SpecialMessagesChat.getNormalMessage((String)(TextFormatting.DARK_AQUA + "Outputs a list of all modifier ids/names/descriptions in the game to the crafttweaker.log"))});
    }

    public void executeCommand(MinecraftServer server, ICommandSender sender, String[] args) {
        boolean filterLocked = args.length == 1 && args[0].equalsIgnoreCase("skipLocked");
        CraftTweakerAPI.logCommand((String)"##### Tinker's Construct Modifier Dump #####");
        Collection modifiers = TinkerRegistry.getAllModifiers();
        int size = 0;
        for (IModifier modifier : modifiers) {
            if (modifier.isHidden() || filterLocked && !LevelLockHandler.getLockByKey((LockKey)new ModifierLockKey((IToolMod)modifier)).equals(LevelLockHandler.EMPTY_LOCK)) continue;
            CraftTweakerAPI.logCommand((String)("## " + modifier.getLocalizedName()));
            CraftTweakerAPI.logCommand((String)("#  Identifier: " + modifier.getIdentifier()));
            CraftTweakerAPI.logCommand((String)("#  Localized:  " + modifier.getLocalizedName()));
            CraftTweakerAPI.logCommand((String)("#  Description:" + modifier.getLocalizedDesc()));
            CraftTweakerAPI.logCommand((String)"##");
            ++size;
        }
        CraftTweakerAPI.logCommand((String)"#########");
        sender.func_145747_a(SpecialMessagesChat.getNormalMessage((String)"List of Tinker's Modifiers Generated;"));
        sender.func_145747_a(SpecialMessagesChat.getLinkToCraftTweakerLog((String)("List Size: " + size + " Entries;"), (ICommandSender)sender));
    }

    public List<String> getSubSubCommand(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.singletonList("skipLocked");
    }
}

