/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonteam.thedragonlib.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemBlock;
import net.thedragonteam.thedragonlib.config.Feature;

public class FeatureWrapper {
    private final String name;
    private final boolean isActive;
    private final boolean isConfigurable;
    private final String[] variantMap;
    private final Class<? extends ItemBlock> itemBlockClass;
    public final Map<Integer, String> nameMap = new HashMap<Integer, String>();

    public FeatureWrapper(Feature feature) {
        this.name = feature.name();
        this.isActive = feature.isActive();
        this.isConfigurable = feature.isConfigurable();
        this.variantMap = feature.variantMap();
        this.itemBlockClass = feature.itemBlock();
        if (feature.variantMap().length > 0) {
            Arrays.stream(feature.variantMap()).forEachOrdered(s -> {
                int meta = Integer.parseInt(s.substring(0, s.indexOf(":")));
                this.nameMap.put(meta, s.substring(s.indexOf(":") + 1));
            });
        }
    }

    public String name() {
        return this.name;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isConfigurable() {
        return this.isConfigurable;
    }

    public String[] variantMap() {
        return this.variantMap;
    }

    public Class<? extends ItemBlock> getItemBlock() {
        return this.itemBlockClass;
    }
}

