/*
 * Decompiled with CFR 0.152.
 */
package ru.flametaichou.ordinarycoins;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ConfigHelper {
    private static Configuration config;
    public static int repairCost;
    public static int repairCoinType;
    public static int coinsStackSize;
    public static boolean repair;
    public static boolean drop;
    private static Map<Class, Integer> mobCoinAmounts;
    private static Map<Class, Integer> mobCoinTypes;

    public static void setConfiguration(Configuration configuration) {
        config = configuration;
    }

    public static void setupConfig() {
        try {
            config.load();
            ConfigHelper.loadEntitiesData(config);
            drop = config.get("Main", "drop", true, "Enable or disable coins drops from mobs").getBoolean(true);
            repair = config.get("Repairing", "repair", true, "Enable or disable repairing items by coins").getBoolean(true);
            repairCost = config.get("Repairing", "repairCost", 50, "How much does the item repairing?").getInt(50);
            repairCoinType = config.get("Repairing", "repairCoinType", 1, "Which coins use to repairing? (0 - bronze, 1 - silver, 2 - gold, 3 - platinum)").getInt(0);
            coinsStackSize = config.get("Main", "coinsStackSize", 100, "How many coins should be in a stack? (100 means that 1 silver coin = 100 bronze coins, 1 gold = 100 silver)").getInt(100);
        }
        catch (Exception e) {
            System.out.println("[Ordinary Coins] Error occurred on loading config file!");
            e.printStackTrace();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static void loadEntitiesData(Configuration config) {
        for (ResourceLocation resourceLocation : EntityList.func_180124_b()) {
            if (resourceLocation == EntityList.field_191307_a) continue;
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(resourceLocation);
            if (entry == null) {
                System.out.println("[Ordinary Coins] Can't find entityEntry for entity: " + resourceLocation.func_110623_a());
                continue;
            }
            String entityName = ConfigHelper.getEntityName(entry);
            Class entityClass = entry.getEntityClass();
            if (entityClass == null) {
                System.out.println("[Ordinary Coins] Can't find entityClass for entry: " + entityName);
                continue;
            }
            try {
                if (Modifier.isAbstract(entityClass.getModifiers()) || entityClass == EntityArmorStand.class || !ConfigHelper.isEntityLiving(entityClass)) continue;
                int defaultAmount = 0;
                if (entityClass == EntityZombie.class) {
                    defaultAmount = 3;
                } else if (entityClass == EntitySkeleton.class) {
                    defaultAmount = 3;
                } else if (entityClass == EntitySpider.class) {
                    defaultAmount = 5;
                } else if (entityClass == EntityEnderman.class) {
                    defaultAmount = 50;
                } else if (entityClass == EntityCreeper.class) {
                    defaultAmount = 5;
                } else if (entityClass == EntityWitch.class) {
                    defaultAmount = 50;
                }
                int amount = config.get("Drops Amount", "amount" + entityName, defaultAmount, "How many coins will drop from " + entityName.toLowerCase()).getInt(defaultAmount);
                mobCoinAmounts.put(entityClass, amount);
                int defaultCoinType = 0;
                int coinType = config.get("Coins Type", "coinType" + entityName, defaultCoinType, "Which coins use to drop from " + entityName.toLowerCase() + "? (0 - bronze, 1 - silver, 2 - gold, 3 - platinum)").getInt(defaultCoinType);
                mobCoinTypes.put(entityClass, coinType);
            }
            catch (Exception e) {
                System.out.println("[Ordinary Coins] Error occurred on configuring entity: " + entityClass.getName());
                e.printStackTrace();
            }
        }
    }

    public static int getCoinsAmount(Class entityClass) {
        return mobCoinAmounts.get(entityClass) != null ? mobCoinAmounts.get(entityClass) : 0;
    }

    public static int getCoinsType(Class entityClass) {
        return mobCoinTypes.get(entityClass) != null ? mobCoinTypes.get(entityClass) : 0;
    }

    private static boolean isEntityLiving(Class entityClass) {
        for (Class parent = entityClass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            if (EntityLivingBase.class == parent) {
                return true;
            }
            if (Entity.class != parent) continue;
            return false;
        }
        return false;
    }

    private static String getEntityName(EntityEntry entry) {
        String s = entry.getName();
        s = s.substring(0, 1).toUpperCase() + s.substring(1);
        s = s.replace(" ", "");
        return s;
    }

    static {
        mobCoinAmounts = new HashMap<Class, Integer>();
        mobCoinTypes = new HashMap<Class, Integer>();
    }
}

