/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.importers;

import betterquesting.api.questing.IQuestLine;
import betterquesting.api.questing.IQuestLineDatabase;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.SimpleDatabase;
import betterquesting.api2.utils.QuestLineSorter;
import betterquesting.questing.QuestLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ImportedQuestLines
extends SimpleDatabase<IQuestLine>
implements IQuestLineDatabase {
    private final List<Integer> lineOrder = new ArrayList<Integer>();
    private final QuestLineSorter SORTER = new QuestLineSorter(this);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrderIndex(int lineID) {
        List<Integer> list = this.lineOrder;
        synchronized (list) {
            if (this.getValue(lineID) == null) {
                return -1;
            }
            if (!this.lineOrder.contains(lineID)) {
                this.lineOrder.add(lineID);
            }
            return this.lineOrder.indexOf(lineID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOrderIndex(int lineID, int index) {
        List<Integer> list = this.lineOrder;
        synchronized (list) {
            this.lineOrder.remove((Object)lineID);
            this.lineOrder.add(index, lineID);
        }
    }

    @Override
    public List<DBEntry<IQuestLine>> getSortedEntries() {
        ArrayList<DBEntry<IQuestLine>> ary = new ArrayList<DBEntry<IQuestLine>>(this.getEntries());
        ary.sort(this.SORTER);
        return ary;
    }

    @Override
    public NBTTagList writeToNBT(NBTTagList json, List<Integer> subset) {
        for (DBEntry entry : this.getEntries()) {
            if (subset != null && !subset.contains(entry.getID())) continue;
            NBTTagCompound jObj = ((IQuestLine)entry.getValue()).writeToNBT(new NBTTagCompound(), null);
            jObj.func_74768_a("lineID", entry.getID());
            jObj.func_74768_a("order", this.getOrderIndex(entry.getID()));
            json.func_74742_a((NBTBase)jObj);
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromNBT(NBTTagList json, boolean merge) {
        this.reset();
        ArrayList<QuestLine> unassigned = new ArrayList<QuestLine>();
        HashMap<Integer, Integer> orderMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTTagCompound list = json.func_150305_b(i);
            int id = list.func_150297_b("lineID", 99) ? list.func_74762_e("lineID") : -1;
            int order = list.func_150297_b("order", 99) ? list.func_74762_e("order") : -1;
            QuestLine line = new QuestLine();
            line.readFromNBT(list, merge);
            if (id >= 0) {
                this.add(id, line);
            } else {
                unassigned.add(line);
            }
            if (order < 0) continue;
            orderMap.put(order, id);
        }
        for (IQuestLine iQuestLine : unassigned) {
            this.add(this.nextID(), iQuestLine);
        }
        ArrayList orderKeys = new ArrayList(orderMap.keySet());
        Collections.sort(orderKeys);
        List<Integer> list = this.lineOrder;
        synchronized (list) {
            this.lineOrder.clear();
            Iterator iterator = orderKeys.iterator();
            while (iterator.hasNext()) {
                int o = (Integer)iterator.next();
                this.lineOrder.add((Integer)orderMap.get(o));
            }
        }
    }

    @Override
    public void removeQuest(int questID) {
        for (DBEntry ql : this.getEntries()) {
            ((IQuestLine)ql.getValue()).removeID(questID);
        }
    }

    @Override
    public IQuestLine createNew(int id) {
        QuestLine ql = new QuestLine();
        this.add(id, ql);
        return ql;
    }
}

