/*
 * Decompiled with CFR 0.152.
 */
package panszelescik.morelibs.api;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class Helper {
    public static ItemStack get(String id, String name, int amount, int meta) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id + ":" + name));
        return item != null ? new ItemStack(item, amount, meta) : ItemStack.field_190927_a;
    }

    public static ItemStack get(String id, String name, int amount) {
        return Helper.get(id, name, amount, 0);
    }

    public static ItemStack get(String id, String name) {
        return Helper.get(id, name, 1, 0);
    }

    public static ItemStack get(Block block, int meta) {
        return block != null ? new ItemStack(block, 1, meta) : ItemStack.field_190927_a;
    }

    public static ItemStack get(Item item, int meta) {
        return item != null ? new ItemStack(item, 1, meta) : ItemStack.field_190927_a;
    }

    public static ItemStack get(Block block) {
        return Helper.get(block, 1);
    }

    public static ItemStack get(Item item) {
        return Helper.get(item, 1);
    }

    public static ItemStack get(String ore, int amount) {
        if (!Helper.oreNameExists(ore)) {
            return ItemStack.field_190927_a;
        }
        return Helper.cloneStack((ItemStack)OreDictionary.getOres((String)ore, (boolean)false).get(0), amount);
    }

    public static ItemStack get(String ore) {
        return Helper.get(ore, 1);
    }

    public static ItemStack cloneStack(ItemStack stack, int stackSize) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack retStack = stack.func_77946_l();
        retStack.func_190920_e(stackSize);
        return retStack;
    }

    public static boolean notNull(ItemStack stack) {
        return stack != ItemStack.field_190927_a && stack != null;
    }

    public static boolean notNull(String id, String input) {
        return Helper.notNull(id, input, 0);
    }

    public static boolean notNull(String id, String input, int meta) {
        return Helper.notNull(Helper.get(id, input, 1, meta));
    }

    public static boolean oreNameExists(String oreName) {
        return OreDictionary.doesOreNameExist((String)oreName) && OreDictionary.getOres((String)oreName, (boolean)false).size() > 0;
    }

    public static boolean isLoaded(String modid) {
        return Loader.isModLoaded((String)modid);
    }

    public static String getItemName(ItemStack stack) {
        return stack.func_77977_a();
    }

    public static String getItemName(String oreName) {
        return Helper.getItemName(Helper.get(oreName));
    }

    public static String getItemName(String id, String name, int amount, int meta) {
        return Helper.getItemName(Helper.get(id, name, amount, meta));
    }

    public static String getItemName(String id, String name) {
        return Helper.getItemName(id, name, 1, 0);
    }

    public static String getItemName(Item item) {
        return Helper.getItemName(Helper.get(item));
    }

    public static String translate(String key) {
        return I18n.func_74838_a((String)key);
    }
}

