/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.item;

import hellfirepvp.modularmachinery.common.CommonProxy;
import hellfirepvp.modularmachinery.common.machine.DynamicMachine;
import hellfirepvp.modularmachinery.common.machine.MachineRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlueprint
extends Item {
    public static final String DYNAMIC_MACHINE_NBT_KEY = "dynamicmachine";

    public ItemBlueprint() {
        this.func_77625_d(16);
        this.func_77637_a(CommonProxy.creativeTabModularMachinery);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (DynamicMachine machine : MachineRegistry.getRegistry()) {
                ItemStack i = new ItemStack((Item)this);
                ItemBlueprint.setAssociatedMachine(i, machine);
                items.add((Object)i);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        DynamicMachine machine = ItemBlueprint.getAssociatedMachine(stack);
        if (machine == null) {
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.machinery.empty", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.GRAY + machine.getLocalizedName());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K && ItemBlueprint.getAssociatedMachine(player.func_184586_b(hand)) != null) {
            player.openGui((Object)"modularmachinery", CommonProxy.GuiType.BLUEPRINT_PREVIEW.ordinal(), worldIn, hand == EnumHand.MAIN_HAND ? 0 : 1, 0, 0);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (worldIn.field_72995_K && ItemBlueprint.getAssociatedMachine(held) != null) {
            player.openGui((Object)"modularmachinery", CommonProxy.GuiType.BLUEPRINT_PREVIEW.ordinal(), worldIn, hand == EnumHand.MAIN_HAND ? 0 : 1, 0, 0);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)held);
    }

    @Nullable
    public static DynamicMachine getAssociatedMachine(ItemStack stack) {
        return MachineRegistry.getRegistry().getMachine(ItemBlueprint.getAssociatedMachineKey(stack));
    }

    @Nullable
    public static ResourceLocation getAssociatedMachineKey(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        if (!stack.func_77978_p().func_74764_b(DYNAMIC_MACHINE_NBT_KEY)) {
            return null;
        }
        return new ResourceLocation(stack.func_77978_p().func_74779_i(DYNAMIC_MACHINE_NBT_KEY));
    }

    public static void setAssociatedMachine(ItemStack stack, DynamicMachine machine) {
        ItemBlueprint.setAssociatedMachine(stack, machine.getRegistryName());
    }

    public static void setAssociatedMachine(ItemStack stack, ResourceLocation machineKey) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a(DYNAMIC_MACHINE_NBT_KEY, machineKey.toString());
    }
}

