/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.cables;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import zmaster587.advancedRocketry.cable.HandlerCableNetwork;
import zmaster587.advancedRocketry.cable.NetworkRegistry;

public class TilePipe
extends TileEntity {
    int networkID;
    boolean initialized = false;
    boolean destroyed = false;
    static boolean debug = false;
    boolean[] connectedSides = new boolean[6];

    public void initialize(int id) {
        this.networkID = id;
        this.initialized = true;
        this.getNetworkHandler().getNetwork(id).addPipeToNetwork(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.removePipeFromSystem();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.removePipeFromSystem();
    }

    public void removePipeFromSystem() {
        if (!this.isInitialized()) {
            return;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (tile == null) continue;
            this.getNetworkHandler().removeFromAllTypes(this, tile);
        }
        if (this.getNetworkHandler().getNetwork(this.networkID) != null) {
            this.getNetworkHandler().getNetwork(this.networkID).removePipeFromNetwork(this);
            this.getNetworkHandler().removeNetworkByID(this.networkID);
        }
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        byte sides = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.connectedSides[i]) continue;
            sides = (byte)(sides + (1 << i));
        }
        nbt.func_74774_a("conn", sides);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        byte sides = tag.func_74771_c("conn");
        for (int i = 0; i < 6; ++i) {
            this.connectedSides[i] = (sides & 1 << i) != 0;
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public void onPlaced() {
        for (EnumFacing dir : EnumFacing.values()) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (tile == null || !(tile instanceof TilePipe) || tile.getClass() != ((Object)((Object)this)).getClass()) continue;
            TilePipe pipe = (TilePipe)tile;
            if (this.destroyed) continue;
            if (this.isInitialized() && pipe.isInitialized() && pipe.getNetworkID() != this.networkID) {
                this.getNetworkHandler().mergeNetworks(this.networkID, pipe.getNetworkID());
            } else if (!this.isInitialized() && pipe.isInitialized()) {
                this.initialize(pipe.getNetworkID());
            }
            this.connectedSides[dir.ordinal()] = true;
        }
        if (!this.isInitialized()) {
            this.initialize(this.getNetworkHandler().getNewNetworkID());
        }
        this.linkSystems();
    }

    public void linkSystems() {
        for (EnumFacing dir : EnumFacing.values()) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
            if (tile == null) continue;
            this.attemptLink(dir, tile);
        }
    }

    protected void attemptLink(EnumFacing dir, TileEntity tile) {
        if (this.canExtract(dir, tile) && (this.field_145850_b.func_175687_A(this.field_174879_c) > 0 || this.field_145850_b.func_175676_y(this.field_174879_c) > 0)) {
            if (this.field_145850_b.field_72995_K) {
                this.connectedSides[dir.ordinal()] = true;
            } else {
                this.getNetworkHandler().removeFromAllTypes(this, tile);
                this.getNetworkHandler().addSource(this, tile, dir);
                this.connectedSides[dir.ordinal()] = true;
            }
        }
        if (this.canInject(dir, tile) && this.field_145850_b.func_175687_A(this.field_174879_c) == 0 && this.field_145850_b.func_175676_y(this.field_174879_c) == 0) {
            if (this.field_145850_b.field_72995_K) {
                this.connectedSides[dir.ordinal()] = true;
            } else {
                this.getNetworkHandler().removeFromAllTypes(this, tile);
                this.getNetworkHandler().addSink(this, tile, dir);
                this.connectedSides[dir.ordinal()] = true;
            }
        }
    }

    public int getNetworkID() {
        return this.networkID;
    }

    public boolean isInitialized() {
        return this.initialized && this.getNetworkHandler().doesNetworkExist(this.networkID);
    }

    public void onNeighborTileChange(BlockPos pos) {
        TileEntity tile = this.field_145850_b.func_175625_s(pos);
        if (!this.field_145850_b.field_72995_K && !this.getNetworkHandler().doesNetworkExist(this.networkID)) {
            this.initialized = false;
        }
        if (tile != null) {
            if (tile instanceof TilePipe && tile.getClass() == ((Object)((Object)this)).getClass()) {
                EnumFacing dir;
                TilePipe pipe = (TilePipe)tile;
                if (this.field_145850_b.field_72995_K) {
                    dir = null;
                    for (EnumFacing dir2 : EnumFacing.values()) {
                        if (this.func_174877_v().func_177972_a(dir2).compareTo((Vec3i)pos) != 0) continue;
                        dir = dir2;
                    }
                    if (dir != null) {
                        this.connectedSides[dir.ordinal()] = true;
                    }
                } else {
                    if (this.destroyed) {
                        return;
                    }
                    if (pipe.isInitialized()) {
                        if (!this.isInitialized()) {
                            this.initialize(pipe.getNetworkID());
                            this.linkSystems();
                            this.func_70296_d();
                            if (debug && !this.field_145850_b.field_72995_K) {
                                System.out.println(" pos1 " + this.func_174877_v());
                            }
                        } else if (pipe.getNetworkID() != this.networkID) {
                            this.mergeNetworks(pipe.getNetworkID(), this.networkID);
                        }
                    } else if (pipe.destroyed) {
                        this.getNetworkHandler().removeNetworkByID(pipe.networkID);
                        if (debug && !this.field_145850_b.field_72995_K) {
                            System.out.println(" pos2 " + this.func_174877_v());
                        }
                        this.onPlaced();
                        this.func_70296_d();
                    } else if (this.isInitialized()) {
                        if (debug && !this.field_145850_b.field_72995_K) {
                            System.out.println(" pos3 " + this.func_174877_v());
                        }
                        pipe.initialize(this.networkID);
                    } else {
                        if (debug && !this.field_145850_b.field_72995_K) {
                            System.out.println(" pos4 " + this.func_174877_v());
                        }
                        this.onPlaced();
                        this.func_70296_d();
                    }
                }
                dir = null;
                for (EnumFacing dir2 : EnumFacing.values()) {
                    if (this.func_174877_v().func_177972_a(dir2).compareTo((Vec3i)pos) != 0) continue;
                    this.connectedSides[dir2.ordinal()] = true;
                }
            } else {
                if (!this.field_145850_b.field_72995_K && !this.isInitialized()) {
                    this.networkID = this.getNetworkHandler().getNewNetworkID();
                    this.initialized = true;
                }
                EnumFacing dir = null;
                for (EnumFacing dir2 : EnumFacing.values()) {
                    if (this.func_174877_v().func_177972_a(dir2).compareTo((Vec3i)pos) != 0) continue;
                    dir = dir2;
                }
                if (dir != null) {
                    this.attemptLink(dir, tile);
                }
            }
        } else {
            EnumFacing dir = null;
            for (EnumFacing dir2 : EnumFacing.values()) {
                if (this.func_174877_v().func_177972_a(dir2).compareTo((Vec3i)pos) != 0) continue;
                dir = dir2;
            }
            if (dir != null) {
                this.connectedSides[dir.ordinal()] = false;
            }
        }
    }

    public HandlerCableNetwork getNetworkHandler() {
        return NetworkRegistry.liquidNetwork;
    }

    public boolean canConnect(int side) {
        return this.connectedSides[side];
    }

    public boolean canExtract(EnumFacing dir, TileEntity e) {
        return false;
    }

    public boolean canInject(EnumFacing dir, TileEntity e) {
        return false;
    }

    public void mergeNetworks(int a, int b) {
        this.networkID = this.getNetworkHandler().mergeNetworks(a, b);
        this.func_70296_d();
    }

    public String toString() {
        return "ID: " + this.networkID + "   " + this.getNetworkHandler().toString(this.networkID);
    }

    public void setDestroyed() {
        this.destroyed = true;
    }

    public void setInvalid() {
        this.initialized = false;
    }
}

