/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base;

import com.enderio.core.common.Lang;
import com.enderio.core.common.mixin.SimpleMixinLoader;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.util.stackable.Things;
import com.google.common.collect.ImmutableList;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import crazypants.enderio.api.addon.IEnderIOAddon;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.CapacitorKeyRegistry;
import crazypants.enderio.base.conduit.redstone.ConnectivityTool;
import crazypants.enderio.base.config.Config;
import crazypants.enderio.base.config.config.BaseConfig;
import crazypants.enderio.base.config.config.DiagnosticsConfig;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.config.config.TeleportConfig;
import crazypants.enderio.base.config.recipes.RecipeFactory;
import crazypants.enderio.base.config.recipes.RecipeLoader;
import crazypants.enderio.base.diagnostics.ProfilerAntiReactor;
import crazypants.enderio.base.diagnostics.ProfilerDebugger;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.fluid.FluidFuelRegister;
import crazypants.enderio.base.handler.ServerTickHandler;
import crazypants.enderio.base.init.CommonProxy;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.init.ModObjectRegistry;
import crazypants.enderio.base.integration.buildcraft.BuildcraftIntegration;
import crazypants.enderio.base.integration.railcraft.RailcraftUtil;
import crazypants.enderio.base.material.recipes.MaterialOredicts;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.paint.PaintSourceValidator;
import crazypants.enderio.base.recipe.alloysmelter.AlloyRecipeManager;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import crazypants.enderio.base.recipe.slicensplice.SliceAndSpliceRecipeManager;
import crazypants.enderio.base.recipe.soul.SoulBinderRecipeManager;
import crazypants.enderio.base.recipe.spawner.EntityDataRegistry;
import crazypants.enderio.base.recipe.vat.VatRecipeManager;
import crazypants.enderio.base.scheduler.Celeb;
import crazypants.enderio.base.scheduler.Scheduler;
import crazypants.enderio.base.transceiver.ServerChannelRegister;
import info.loenwind.autoconfig.factory.IRootFactory;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.server.permission.DefaultPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import org.apache.commons.lang3.tuple.Triple;

@Mod(modid="enderio", name="Ender IO", version="5.1.55", dependencies="after:baubles@[1.5.2,);after:buildcraft@[7.99.14,);required-after:endercore@[1.12.2-0.5.73,);required-after:forge@[14.23.5.2847,);after:jei@[4.14.1.234,);after:thaumcraft@[6.1.BETA13,)", guiFactory="crazypants.enderio.base.config.GUIFactory", acceptedMinecraftVersions="[1.12.2]")
public class EnderIO
implements IEnderIOAddon {
    @Nonnull
    public static final String MODID = "enderio";
    @Nonnull
    public static final String DOMAIN = "enderio";
    @Nonnull
    public static final String MOD_NAME = "Ender IO";
    @Nonnull
    public static final String VERSION = "5.1.55";
    @Nonnull
    private static final String DEFAULT_DEPENDENCIES = "after:endercore;after:hwyla;after:jei";
    @Nonnull
    public static final String DEPENDENCIES = "after:baubles@[1.5.2,);after:buildcraft@[7.99.14,);required-after:endercore@[1.12.2-0.5.73,);required-after:forge@[14.23.5.2847,);after:jei@[4.14.1.234,);after:thaumcraft@[6.1.BETA13,)";
    @Mod.Instance(value="enderio")
    public static EnderIO instance;
    @SidedProxy(clientSide="crazypants.enderio.base.init.ClientProxy", serverSide="crazypants.enderio.base.init.CommonProxy")
    public static CommonProxy proxy;
    @Nonnull
    public static final Lang lang;
    private static Config configHandler;

    @NetworkCheckHandler
    @SideOnly(value=Side.CLIENT)
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return modList.keySet().contains("enderio") && VERSION.equals(modList.get("enderio"));
    }

    public EnderIO() {
        SimpleMixinLoader.loadMixinSources((Object)this);
    }

    @Mod.EventHandler
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        Log.debug("PHASE PRE-INIT START");
        MinecraftForge.EVENT_BUS.post((Event)new EnderIOLifecycleEvent.Config.Pre());
        configHandler = new Config(event, (IRootFactory)BaseConfig.F, "enderio");
        MinecraftForge.EVENT_BUS.post((Event)new EnderIOLifecycleEvent.Config.Post());
        MinecraftForge.EVENT_BUS.post((Event)new EnderIOLifecycleEvent.PreInit());
        Log.debug("PHASE PRE-INIT END");
    }

    @Mod.EventHandler
    public void load(@Nonnull FMLInitializationEvent event) {
        Log.debug("PHASE INIT START");
        EnderIO.initCrashData();
        MinecraftForge.EVENT_BUS.post((Event)new EnderIOLifecycleEvent.Init.Pre(event));
        PacketHandler.init(event);
        MinecraftForge.EVENT_BUS.post((Event)new EnderIOLifecycleEvent.Init.Normal(event));
        MinecraftForge.EVENT_BUS.post((Event)new EnderIOLifecycleEvent.Init.Post(event));
        Log.debug("PHASE INIT END");
    }

    @Mod.EventHandler
    public void onImc(@Nonnull FMLInterModComms.IMCEvent event) {
        Log.debug("PHASE IMC START");
        this.processImc((ImmutableList<FMLInterModComms.IMCMessage>)event.getMessages());
        MaterialOredicts.init(event);
        MaterialOredicts.checkOreRegistrations();
        RecipeLoader.addRecipes();
        CapacitorKeyRegistry.validate();
        RailcraftUtil.registerFuels();
        Log.debug("PHASE IMC END");
    }

    @Mod.EventHandler
    public void postInit(@Nonnull FMLPostInitializationEvent event) {
        Log.debug("PHASE POST-INIT START");
        MinecraftForge.EVENT_BUS.post((Event)new EnderIOLifecycleEvent.PostInit.Pre());
        ModObjectRegistry.init(event);
        SagMillRecipeManager.getInstance().create();
        AlloyRecipeManager.getInstance().create();
        SliceAndSpliceRecipeManager.getInstance().create();
        VatRecipeManager.getInstance().create();
        PaintSourceValidator.instance.loadConfig();
        BuildcraftIntegration.init(event);
        Celeb.init(event);
        Scheduler.instance.start();
        MinecraftForge.EVENT_BUS.post((Event)new EnderIOLifecycleEvent.PostInit.Post());
        Log.debug("PHASE POST-INIT END");
    }

    @Mod.EventHandler
    public void loadComplete(@Nonnull FMLLoadCompleteEvent event) {
        Log.debug("PHASE LOAD COMPLETE START");
        this.processImc((ImmutableList<FMLInterModComms.IMCMessage>)FMLInterModComms.fetchRuntimeMessages((Object)this));
        Log.debug("PHASE LOAD COMPLETE END");
    }

    @Mod.EventHandler
    public void serverStopped(@Nonnull FMLServerStoppedEvent event) {
        ServerTickHandler.flush();
        ServerChannelRegister.instance.reset();
    }

    @Mod.EventHandler
    public static void onServerStart(FMLServerAboutToStartEvent event) {
        ServerChannelRegister.instance.reset();
    }

    void processImc(ImmutableList<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage msg : messages) {
            String key = msg.key;
            Log.info("Processing IMC message ", key, " from ", msg.getSender());
            try {
                String value;
                if ("enablePainting".equals(key)) {
                    PersonalConfig.TooltipPaintEnum.setPainterAvailable();
                    continue;
                }
                if (msg.isStringMessage()) {
                    value = msg.getStringValue();
                    if (value == null) {
                        return;
                    }
                    if ("recipe:xml".equals(key)) {
                        RecipeLoader.addIMCRecipe(msg.getSender(), false, value);
                        continue;
                    }
                    if ("recipe:xml:file".equals(key)) {
                        RecipeLoader.addIMCRecipe(msg.getSender(), true, value);
                        continue;
                    }
                    if ("teleport:blacklist:add".equals(key)) {
                        ((Things)TeleportConfig.blockBlacklist.get()).add(value);
                        continue;
                    }
                    if (!"redstone:connectable:add".equals(key)) continue;
                    ConnectivityTool.registerRedstoneAware(value);
                    continue;
                }
                if (msg.isResourceLocationMessage()) {
                    value = msg.getResourceLocationValue();
                    if ("soulVial:blacklist:add".equals(key)) {
                        EntityDataRegistry.getInstance().addToBlacklistSoulVial(null, arg_0 -> EnderIO.lambda$processImc$0((ResourceLocation)value, arg_0));
                        continue;
                    }
                    if (!"soulVial:unspawnablelist:add".equals(key)) continue;
                    EntityDataRegistry.getInstance().setNeedsCloning(null, arg_0 -> EnderIO.lambda$processImc$1((ResourceLocation)value, arg_0));
                    continue;
                }
                if (msg.isNBTMessage()) {
                    NBTTagCompound nbtValue = msg.getNBTValue();
                    if (nbtValue == null) {
                        return;
                    }
                    if ("recipe:soulbinder".equals(key)) {
                        SoulBinderRecipeManager.getInstance().addRecipeFromNBT(nbtValue);
                        continue;
                    }
                    if ("fluidFuel:add".equals(key)) {
                        FluidFuelRegister.instance.addFuel(nbtValue);
                        continue;
                    }
                    if (!"fluidCoolant:add".equals(key)) continue;
                    FluidFuelRegister.instance.addCoolant(nbtValue);
                    continue;
                }
                if (!msg.isItemStackMessage()) continue;
                if ("painter:whitelist:add".equals(key)) {
                    PaintSourceValidator.instance.addToWhitelist(msg.getItemStackValue());
                    continue;
                }
                if (!"painter:blacklist:add".equals(key)) continue;
                PaintSourceValidator.instance.addToBlacklist(msg.getItemStackValue());
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.error("Error occurred handling IMC message ", key, " from ", msg.getSender());
            }
        }
    }

    @Nonnull
    public static EnderIO getInstance() {
        return (EnderIO)NullHelper.notnullF((Object)instance, (String)"instance is missing");
    }

    @Override
    @Nonnull
    public Configuration getConfiguration() {
        return BaseConfig.F.getConfig();
    }

    @Nonnull
    public static Config getConfigHandler() {
        return (Config)((Object)NullHelper.notnull((Object)((Object)configHandler), (String)"Cannot access config before preInit phase"));
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        if (((Boolean)DiagnosticsConfig.debugProfilerTracer.get()).booleanValue()) {
            ProfilerDebugger.init(event);
        } else if (((Boolean)DiagnosticsConfig.debugProfilerAntiNuclearActivist.get()).booleanValue()) {
            ProfilerAntiReactor.init(event);
        }
        if (PermissionAPI.getPermissionHandler() == DefaultPermissionHandler.INSTANCE) {
            Log.info("Permission Handler is: (default)");
        } else {
            Log.info("Permission Handler is: " + PermissionAPI.getPermissionHandler());
        }
    }

    @Override
    @Nonnull
    public NNList<Triple<Integer, RecipeFactory, String>> getRecipeFiles() {
        return new NNList((Object[])new Triple[]{Triple.of((Object)0, null, (Object)"aliases"), Triple.of((Object)1, null, (Object)"materials"), Triple.of((Object)1, null, (Object)"items"), Triple.of((Object)1, null, (Object)"base"), Triple.of((Object)1, null, (Object)"balls"), Triple.of((Object)9, null, (Object)"misc"), Triple.of((Object)9, null, (Object)"capacitor"), Triple.of((Object)1, null, (Object)"hiding_base"), Triple.of((Object)1, null, (Object)"darksteel_upgrades"), Triple.of((Object)1, null, (Object)"fuels")});
    }

    @Override
    @Nonnull
    public NNList<String> getExampleFiles() {
        return new NNList((Object[])new String[]{"peaceful", "easy_recipes", "hard_recipes", "broken_spawner", "cheap_materials", "legacy_recipes", "strict_iron", "optional_tweaks", "unhide_base"});
    }

    static void initCrashData() {
        CrashReport crashreport = CrashReport.func_85055_a((Throwable)new RuntimeException(), (String)"Exception while updating neighbours");
        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being updated");
        crashreportcategory.func_189529_a("Source block type", (ICrashReportDetail)new ICrashReportDetail<String>(){

            public String call() throws Exception {
                return "foo";
            }
        });
        CrashReportCategory.func_175750_a((CrashReportCategory)crashreportcategory, (BlockPos)new BlockPos(0, 0, 0), (IBlockState)ModObject.block_machine_base.getBlockNN().func_176223_P());
    }

    private static /* synthetic */ boolean lambda$processImc$1(ResourceLocation value, ResourceLocation elem) {
        return value.equals((Object)elem);
    }

    private static /* synthetic */ boolean lambda$processImc$0(ResourceLocation value, ResourceLocation elem) {
        return value.equals((Object)elem);
    }

    static {
        lang = new Lang("enderio");
        FluidRegistry.enableUniversalBucket();
        if (MinecraftProfileTexture.Type.ELYTRA.getClass().toString().equals("force a classload real hard")) {
            // empty if block
        }
    }
}

