/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel.gui;

import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.base.block.darksteel.anvil.BlockDarkSteelAnvil;
import crazypants.enderio.base.config.config.BlockConfig;
import crazypants.enderio.base.handler.darksteel.gui.DSUContainer;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.util.FuncUtil;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class AnvilSubContainer {
    static final int ANVIL_Y_OFFSET = 10;
    private final DSUContainer parent;
    private final IInventory outputSlot = new InventoryCraftResult();
    final InventoryBasic inputSlots = new InventoryBasic("Repair", true, 2){

        public void func_70296_d() {
            super.func_70296_d();
            AnvilSubContainer.this.updateRepairOutput();
        }
    };
    private int maximumCost = 0;
    private int materialCost = 0;
    private String repairedItemName = "";
    final EntityPlayer player;

    AnvilSubContainer(DSUContainer parent, EntityPlayer player) {
        this.parent = parent;
        this.player = player;
    }

    void addSlots() {
        this.parent.func_75146_a((Slot)new HidingSlot((IInventory)this.inputSlots, 0, 27, 57));
        this.parent.func_75146_a((Slot)new HidingSlot((IInventory)this.inputSlots, 1, 76, 57));
        this.parent.func_75146_a((Slot)new OutputSlot(this.outputSlot, 2, 134, 57));
    }

    private boolean onAnvilChange(ItemStack left, ItemStack right, int baseCost) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, this.repairedItemName, baseCost);
        if (MinecraftForge.EVENT_BUS.post((Event)e)) {
            return false;
        }
        if (e.getOutput().func_190926_b()) {
            return true;
        }
        this.outputSlot.func_70299_a(0, e.getOutput());
        this.maximumCost = e.getCost();
        this.materialCost = e.getMaterialCost();
        return false;
    }

    public void updateRepairOutput() {
        ItemStack itemstack = this.inputSlots.func_70301_a(0);
        this.maximumCost = 1;
        int cost = 0;
        int baseCost = 0;
        int renamingCost = 0;
        if (itemstack.func_190926_b()) {
            this.abortCalculatingOutput();
        } else {
            ItemStack outputStack = itemstack.func_77946_l();
            ItemStack itemstack2 = this.inputSlots.func_70301_a(1);
            Map existingEnchantments = EnchantmentHelper.func_82781_a((ItemStack)outputStack);
            baseCost = baseCost + itemstack.func_82838_A() + (itemstack2.func_190926_b() ? 0 : itemstack2.func_82838_A());
            this.materialCost = 0;
            boolean applyingBook = false;
            if (!itemstack2.func_190926_b()) {
                if (!this.onAnvilChange(itemstack, itemstack2, baseCost)) {
                    return;
                }
                if (itemstack.func_190916_E() > 1) {
                    this.abortCalculatingOutput();
                    return;
                }
                boolean bl = applyingBook = itemstack2.func_77973_b() == Items.field_151134_bR && !ItemEnchantedBook.func_92110_g((ItemStack)itemstack2).func_82582_d();
                if (outputStack.func_77984_f() && outputStack.func_77973_b().func_82789_a(itemstack, itemstack2)) {
                    int itemDamageToRepair = Math.min(outputStack.func_77952_i(), outputStack.func_77958_k() / 4);
                    if (itemDamageToRepair <= 0) {
                        this.abortCalculatingOutput();
                        return;
                    }
                    this.materialCost = 0;
                    while (itemDamageToRepair > 0 && this.materialCost < itemstack2.func_190916_E()) {
                        outputStack.func_77964_b(outputStack.func_77952_i() - itemDamageToRepair);
                        ++cost;
                        itemDamageToRepair = Math.min(outputStack.func_77952_i(), outputStack.func_77958_k() / 4);
                        ++this.materialCost;
                    }
                } else {
                    if (!(applyingBook || outputStack.func_77973_b() == itemstack2.func_77973_b() && outputStack.func_77984_f())) {
                        this.abortCalculatingOutput();
                        return;
                    }
                    if (outputStack.func_77984_f() && !applyingBook) {
                        int l = itemstack.func_77958_k() - itemstack.func_77952_i();
                        int i1 = itemstack2.func_77958_k() - itemstack2.func_77952_i();
                        int j1 = i1 + outputStack.func_77958_k() * 12 / 100;
                        int k1 = l + j1;
                        int l1 = outputStack.func_77958_k() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < outputStack.func_77952_i()) {
                            outputStack.func_77964_b(l1);
                            cost += 2;
                        }
                    }
                    Map bookEnchants = EnchantmentHelper.func_82781_a((ItemStack)itemstack2);
                    boolean atLeastOneCanApply = false;
                    boolean atLeastOneCannotApply = false;
                    for (Enchantment enchantment : bookEnchants.keySet()) {
                        if (enchantment == null) continue;
                        int existingLevel = existingEnchantments.containsKey(enchantment) ? (Integer)existingEnchantments.get(enchantment) : 0;
                        int newLevel = (Integer)bookEnchants.get(enchantment);
                        newLevel = existingLevel == newLevel ? newLevel + 1 : Math.max(newLevel, existingLevel);
                        boolean canApply = enchantment.func_92089_a(itemstack);
                        if (this.player.field_71075_bZ.field_75098_d || itemstack.func_77973_b() == Items.field_151134_bR) {
                            canApply = true;
                        }
                        for (Enchantment existingEnchantment : existingEnchantments.keySet()) {
                            if (existingEnchantment == null || existingEnchantment == enchantment || enchantment.func_191560_c(existingEnchantment)) continue;
                            canApply = false;
                            ++cost;
                        }
                        if (!canApply) {
                            atLeastOneCannotApply = true;
                            continue;
                        }
                        atLeastOneCanApply = true;
                        if (newLevel > enchantment.func_77325_b()) {
                            newLevel = enchantment.func_77325_b();
                        }
                        existingEnchantments.put(enchantment, newLevel);
                        int multiplier = 0;
                        switch (enchantment.func_77324_c()) {
                            case COMMON: {
                                multiplier = 1;
                                break;
                            }
                            case UNCOMMON: {
                                multiplier = 2;
                                break;
                            }
                            case RARE: {
                                multiplier = 4;
                                break;
                            }
                            case VERY_RARE: {
                                multiplier = 8;
                            }
                        }
                        if (applyingBook) {
                            multiplier = Math.max(1, multiplier / 2);
                        }
                        cost += multiplier * newLevel;
                    }
                    if (atLeastOneCannotApply && !atLeastOneCanApply) {
                        this.abortCalculatingOutput();
                        return;
                    }
                }
            }
            if (StringUtils.isBlank((CharSequence)this.repairedItemName)) {
                if (itemstack.func_82837_s()) {
                    renamingCost = 1;
                    outputStack.func_135074_t();
                }
            } else if (!this.repairedItemName.equals(itemstack.func_82833_r())) {
                renamingCost = 1;
                outputStack.func_151001_c(this.repairedItemName);
            }
            if (applyingBook && !outputStack.func_77973_b().isBookEnchantable(outputStack, itemstack2)) {
                this.abortCalculatingOutput();
                return;
            }
            if (cost <= 0 && renamingCost <= 0) {
                this.abortCalculatingOutput();
                return;
            }
            this.maximumCost = baseCost + cost + renamingCost;
            if (cost == 0 && renamingCost > 0 && this.maximumCost >= AnvilSubContainer.getMaxCost()) {
                this.maximumCost = AnvilSubContainer.getMaxCost() - 1;
            }
            if (this.maximumCost >= AnvilSubContainer.getMaxCost() && !this.player.field_71075_bZ.field_75098_d) {
                outputStack = ItemStack.field_190927_a;
            }
            if (!outputStack.func_190926_b()) {
                int newRepairCost = outputStack.func_82838_A();
                if (!itemstack2.func_190926_b() && newRepairCost < itemstack2.func_82838_A()) {
                    newRepairCost = itemstack2.func_82838_A();
                }
                if (renamingCost != cost || renamingCost == 0) {
                    newRepairCost = newRepairCost * 2 + 1;
                }
                outputStack.func_82841_c(newRepairCost);
                EnchantmentHelper.func_82782_a((Map)existingEnchantments, (ItemStack)outputStack);
            }
            this.outputSlot.func_70299_a(0, outputStack);
            this.parent.func_75142_b();
        }
    }

    static int getMaxCost() {
        return (Integer)BlockConfig.dsaMaxCost.get();
    }

    private void abortCalculatingOutput() {
        this.outputSlot.func_70299_a(0, ItemStack.field_190927_a);
        this.maximumCost = 0;
    }

    public void addListener(IContainerListener listener) {
        listener.func_71112_a((Container)this.parent, 0, this.maximumCost);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int data) {
        if (id == 0) {
            this.maximumCost = data;
        }
    }

    public void onContainerClosed(EntityPlayer playerIn) {
        if (!this.player.field_70170_p.field_72995_K) {
            this.parent.func_193327_a(playerIn, this.player.field_70170_p, (IInventory)this.inputSlots);
        }
    }

    public void updateItemName(String newName) {
        this.repairedItemName = newName;
        if (!this.outputSlot.func_70301_a(0).func_190926_b()) {
            ItemStack itemstack = this.outputSlot.func_70301_a(0);
            if (StringUtils.isBlank((CharSequence)newName)) {
                itemstack.func_135074_t();
            } else {
                itemstack.func_151001_c(this.repairedItemName);
            }
        }
        this.updateRepairOutput();
    }

    public int getMaximumCost() {
        return this.maximumCost;
    }

    public void setMaximumCost(int maximumCost) {
        this.maximumCost = maximumCost;
    }

    private int handleAnvilDamage(ItemStack stack) {
        if (this.player.field_70170_p.field_72995_K) {
            return -1;
        }
        if (this.player.field_71075_bZ.field_75098_d) {
            return FuncUtil.runIfNN(this.parent.block, BlockDarkSteelAnvil::getUseEvent, 1030);
        }
        IBlockState iblockstate = this.parent.target.read();
        if (iblockstate.func_177230_c() == Blocks.field_150350_a) {
            return FuncUtil.runIfNN(this.parent.block, BlockDarkSteelAnvil::getUseEvent, 1030);
        }
        float breakChance = ForgeHooks.onAnvilRepair((EntityPlayer)this.player, (ItemStack)stack, (ItemStack)this.inputSlots.func_70301_a(0), (ItemStack)this.inputSlots.func_70301_a(1));
        breakChance /= 0.12f;
        float damageChance = FuncUtil.runIfNN(this.parent.block, BlockDarkSteelAnvil::getDamageChance, Float.valueOf(1.0f)).floatValue();
        if (this.player.func_70681_au().nextFloat() < breakChance * damageChance) {
            int l = (Integer)iblockstate.func_177229_b((IProperty)BlockAnvil.field_176505_b) + 1;
            if (l > 2) {
                if (iblockstate.func_177230_c() == ModObject.blockDarkSteelAnvil.getBlockNN()) {
                    this.parent.target.write(ModObject.blockBrokenAnvil.getBlockNN().func_176223_P().func_177226_a((IProperty)BlockAnvil.field_176506_a, iblockstate.func_177229_b((IProperty)BlockAnvil.field_176506_a)));
                } else {
                    this.parent.target.write(Blocks.field_150350_a.func_176223_P());
                }
                return FuncUtil.runIfNN(this.parent.block, BlockDarkSteelAnvil::getBreakEvent, 1029);
            }
            this.parent.target.write(iblockstate.func_177226_a((IProperty)BlockAnvil.field_176505_b, (Comparable)Integer.valueOf(l)));
            return FuncUtil.runIfNN(this.parent.block, BlockDarkSteelAnvil::getUseEvent, 1030);
        }
        return FuncUtil.runIfNN(this.parent.block, BlockDarkSteelAnvil::getUseEvent, 1030);
    }

    class HidingSlot
    extends ContainerEnder.BaseSlot {
        HidingSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_111238_b() {
            return ((AnvilSubContainer)AnvilSubContainer.this).parent.activeTab.isAnvil();
        }
    }

    class OutputSlot
    extends HidingSlot {
        OutputSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return false;
        }

        public boolean func_82869_a(@Nonnull EntityPlayer playerIn) {
            return (playerIn.field_71075_bZ.field_75098_d || playerIn.field_71068_ca >= AnvilSubContainer.this.getMaximumCost()) && AnvilSubContainer.this.getMaximumCost() > 0 && this.func_75216_d();
        }

        @Nonnull
        public ItemStack func_190901_a(@Nonnull EntityPlayer thePlayer, @Nonnull ItemStack stack) {
            if (!thePlayer.field_71075_bZ.field_75098_d) {
                thePlayer.func_82242_a(-AnvilSubContainer.this.getMaximumCost());
            }
            int effect = AnvilSubContainer.this.handleAnvilDamage(stack);
            AnvilSubContainer.this.inputSlots.func_70299_a(0, ItemStack.field_190927_a);
            if (AnvilSubContainer.this.materialCost > 0) {
                ItemStack itemstack = AnvilSubContainer.this.inputSlots.func_70301_a(1);
                itemstack.func_190918_g(AnvilSubContainer.this.materialCost);
                AnvilSubContainer.this.inputSlots.func_70299_a(1, itemstack);
            } else {
                AnvilSubContainer.this.inputSlots.func_70299_a(1, ItemStack.field_190927_a);
            }
            AnvilSubContainer.this.setMaximumCost(0);
            if (effect > 0) {
                thePlayer.field_70170_p.func_175718_b(effect, BlockCoord.get((Entity)thePlayer), 0);
            }
            return stack;
        }
    }
}

