/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item.tool;

import cofh.core.item.IAOEBreakItem;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstonearsenal.item.tool.ItemToolFlux;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ItemShovelFlux
extends ItemToolFlux
implements IAOEBreakItem {
    int range = 4;

    public ItemShovelFlux(Item.ToolMaterial toolMaterial) {
        super(-3.0f, toolMaterial);
        this.addToolClass("shovel");
        this.damage = 4;
        this.energyPerUseCharged = 800;
        this.field_150914_c.addAll((Collection)ItemSpade.field_150916_c);
        this.effectiveMaterials.add((Object)Material.field_151578_c);
        this.effectiveMaterials.add((Object)Material.field_151577_b);
        this.effectiveMaterials.add((Object)Material.field_151595_p);
        this.effectiveMaterials.add((Object)Material.field_151597_y);
        this.effectiveMaterials.add((Object)Material.field_151596_z);
        this.effectiveMaterials.add((Object)Material.field_151571_B);
    }

    protected boolean hoeBlock(World world, int x, int y, int z, int hitSide, EntityPlayer player) {
        if (hitSide == 0) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (ServerHelper.isServerWorld((World)world)) {
                    world.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
                }
                return true;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        if (ServerHelper.isServerWorld((World)world)) {
                            world.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
                        }
                        return true;
                    }
                    case COARSE_DIRT: {
                        if (ServerHelper.isServerWorld((World)world)) {
                            world.func_175656_a(pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected boolean makePath(World world, int x, int y, int z, int hitSide, EntityPlayer player) {
        if (hitSide == 0) {
            return false;
        }
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (world.func_175623_d(pos.func_177984_a()) && block == Blocks.field_150349_c) {
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (ServerHelper.isServerWorld((World)world)) {
                world.func_180501_a(pos, Blocks.field_185774_da.func_176223_P(), 11);
            }
            return true;
        }
        return false;
    }

    protected Block getBlockFromPos(World world, int x, int y, int z) {
        return world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getNoticeText((String)"info.redstonearsenal.tool.shovel"));
    }

    public boolean func_150897_b(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150431_aC || state.func_177230_c() == Blocks.field_150433_aE;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185887_b(world, pos) == 0.0f) {
            return false;
        }
        if (!this.canHarvestBlock(state, stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.isEmpowered(stack)) {
            EnumFacing horizontalFacing = player.func_174811_aO();
            switch (horizontalFacing) {
                case SOUTH: {
                    for (int k = ++z; k < z + this.range && this.harvestBlock(world, new BlockPos(x, y, k), player); ++k) {
                    }
                    break;
                }
                case WEST: {
                    for (int i = --x; i > x - this.range && this.harvestBlock(world, new BlockPos(i, y, z), player); --i) {
                    }
                    break;
                }
                case NORTH: {
                    for (int k = --z; k > z - this.range && this.harvestBlock(world, new BlockPos(x, y, k), player); --k) {
                    }
                    break;
                }
                case EAST: {
                    for (int i = ++x; i < x + this.range && this.harvestBlock(world, new BlockPos(i, y, z), player); ++i) {
                    }
                    break;
                }
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(stack, false);
        }
        return false;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult used;
        ItemStack stack;
        block26: {
            EnumFacing horizontalFacing;
            int effRange;
            int z;
            int y;
            int x;
            block25: {
                stack = player.func_184586_b(hand);
                if (!player.func_175151_a(pos, facing, stack) || !player.field_71075_bZ.field_75098_d && this.getEnergyStored(stack) < this.getEnergyPerUse(stack)) {
                    return EnumActionResult.FAIL;
                }
                used = EnumActionResult.FAIL;
                x = pos.func_177958_n();
                y = pos.func_177956_o();
                z = pos.func_177952_p();
                effRange = 1 + (this.isEmpowered(stack) ? this.range : 0);
                horizontalFacing = player.func_174811_aO();
                if (!player.func_70093_af()) break block25;
                UseHoeEvent event = new UseHoeEvent(player, stack, worldIn, pos);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                    return EnumActionResult.FAIL;
                }
                if (event.getResult() == Event.Result.ALLOW) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        this.useEnergy(stack, false);
                    }
                    return EnumActionResult.SUCCESS;
                }
                block0 : switch (horizontalFacing) {
                    case SOUTH: {
                        for (int k = z; k < z + effRange; ++k) {
                            if (!this.hoeBlock(worldIn, x, y, k, facing.ordinal(), player)) break block0;
                            used = EnumActionResult.SUCCESS;
                        }
                        break block26;
                    }
                    case WEST: {
                        for (int i = x; i > x - effRange; --i) {
                            if (!this.hoeBlock(worldIn, i, y, z, facing.ordinal(), player)) break block0;
                            used = EnumActionResult.SUCCESS;
                        }
                        break block26;
                    }
                    case NORTH: {
                        for (int k = z; k > z - effRange; --k) {
                            if (!this.hoeBlock(worldIn, x, y, k, facing.ordinal(), player)) break block0;
                            used = EnumActionResult.SUCCESS;
                        }
                        break block26;
                    }
                    case EAST: {
                        for (int i = x; i < x + effRange && this.hoeBlock(worldIn, i, y, z, facing.ordinal(), player); ++i) {
                            used = EnumActionResult.SUCCESS;
                        }
                        break;
                    }
                }
                break block26;
            }
            switch (horizontalFacing) {
                case SOUTH: {
                    for (int k = z; k < z + effRange && this.makePath(worldIn, x, y, k, facing.ordinal(), player); ++k) {
                        used = EnumActionResult.SUCCESS;
                    }
                    break;
                }
                case WEST: {
                    for (int i = x; i > x - effRange && this.makePath(worldIn, i, y, z, facing.ordinal(), player); --i) {
                        used = EnumActionResult.SUCCESS;
                    }
                    break;
                }
                case NORTH: {
                    for (int k = z; k > z - effRange && this.makePath(worldIn, x, y, k, facing.ordinal(), player); --k) {
                        used = EnumActionResult.SUCCESS;
                    }
                    break;
                }
                case EAST: {
                    for (int i = x; i < x + effRange && this.makePath(worldIn, i, y, z, facing.ordinal(), player); ++i) {
                        used = EnumActionResult.SUCCESS;
                    }
                    break;
                }
            }
        }
        if (used == EnumActionResult.SUCCESS && !player.field_71075_bZ.field_75098_d) {
            this.useEnergy(stack, false);
        }
        return used;
    }

    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, BlockPos pos, EntityPlayer player) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        if (!this.isEmpowered(stack) || !this.canHarvestBlock(world.func_180495_p(pos), stack)) {
            return ImmutableList.copyOf(area);
        }
        EnumFacing horizontalFacing = player.func_174811_aO();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int effRange = 1 + (this.isEmpowered(stack) ? this.range : 0);
        switch (horizontalFacing) {
            case SOUTH: {
                BlockPos harvestPos;
                for (int k = z; k < z + effRange && this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y, k)), stack); ++k) {
                    area.add(harvestPos);
                }
                break;
            }
            case WEST: {
                BlockPos harvestPos;
                for (int i = x; i > x - effRange && this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, y, z)), stack); --i) {
                    area.add(harvestPos);
                }
                break;
            }
            case NORTH: {
                BlockPos harvestPos;
                for (int k = z; k > z - effRange && this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, y, k)), stack); --k) {
                    area.add(harvestPos);
                }
                break;
            }
            case EAST: {
                BlockPos harvestPos;
                for (int i = x; i < x + effRange && this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, y, z)), stack); ++i) {
                    area.add(harvestPos);
                }
                break;
            }
        }
        return ImmutableList.copyOf(area);
    }
}

