/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile.energy;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.cap.ForgePowerCapability;
import zmaster587.libVulpes.cap.TeslaHandler;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.tile.IMultiblock;
import zmaster587.libVulpes.tile.TilePointer;
import zmaster587.libVulpes.util.UniversalBattery;

public abstract class TilePlugBase
extends TilePointer
implements IModularInventory,
IUniversalEnergy,
IMultiblock,
IInventory {
    protected UniversalBattery storage = new UniversalBattery(this.getMaxEnergy(0));
    protected int teir;

    public TilePlugBase() {
    }

    public TilePlugBase(int teir) {
        this.setTeir(teir);
    }

    public void setTeir(int teir) {
        this.teir = teir;
        this.storage.setMaxEnergyStored(this.getMaxEnergy(teir));
    }

    protected int getMaxEnergy(int teir) {
        return (int)Math.pow(10.0, teir) * 10000;
    }

    @Override
    public void setMaxEnergyStored(int max) {
        this.storage.setMaxEnergyStored(max);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || TeslaHandler.hasTeslaCapability((ICapabilityProvider)this, capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)new ForgePowerCapability(this);
        }
        if (TeslaHandler.hasTeslaCapability((ICapabilityProvider)this, capability)) {
            return (T)TeslaHandler.getHandler(this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    protected int getMaxDrainRate(int teir) {
        return 250 * (int)Math.pow(2.0, teir);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("teir", this.teir);
        this.storage.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.teir = nbt.func_74762_e("teir");
        this.storage = new UniversalBattery(this.getMaxEnergy(this.teir));
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void setEnergyStored(int amt) {
        this.storage.setEnergyStored(amt);
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public ItemStack func_70304_b(int index) {
        return null;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add(new ModulePower(18, 20, this));
        return modules;
    }

    @Override
    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @Override
    public int extractEnergy(int amt, boolean simulate) {
        return this.storage.extractEnergy(amt, simulate);
    }

    @Override
    public int getUniversalEnergyStored() {
        return this.storage.getUniversalEnergyStored();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public int acceptEnergy(int amt, boolean simulate) {
        return this.storage.acceptEnergy(amt, simulate);
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_191420_l() {
        return false;
    }
}

