/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability;

import gregtech.api.capability.IControllable;
import gregtech.api.capability.IElectricItem;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.tool.IScrewdriverItem;
import gregtech.api.capability.tool.ISoftHammerItem;
import gregtech.api.capability.tool.IWrenchItem;
import gregtech.api.cover.ICoverable;
import gregtech.api.worldgen.generator.GTWorldGenCapability;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;

public class SimpleCapabilityManager {
    public static <T> void registerCapabilityWithNoDefault(Class<T> capabilityClass) {
        CapabilityManager.INSTANCE.register(capabilityClass, new Capability.IStorage<T>(){

            public NBTBase writeNBT(Capability<T> capability, T instance, EnumFacing side) {
                throw new UnsupportedOperationException("Not supported");
            }

            public void readNBT(Capability<T> capability, T instance, EnumFacing side, NBTBase nbt) {
                throw new UnsupportedOperationException("Not supported");
            }
        }, () -> {
            throw new UnsupportedOperationException("This capability has no default implementation");
        });
    }

    public static void init() {
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IEnergyContainer.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IElectricItem.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IWorkable.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(ICoverable.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IControllable.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IWrenchItem.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(IScrewdriverItem.class);
        SimpleCapabilityManager.registerCapabilityWithNoDefault(ISoftHammerItem.class);
        CapabilityManager.INSTANCE.register(GTWorldGenCapability.class, GTWorldGenCapability.STORAGE, GTWorldGenCapability.FACTORY);
    }
}

