/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.multiblock;

import gregtech.api.multiblock.IPatternCenterPredicate;
import gregtech.api.multiblock.PatternMatchContext;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockWorldState {
    private World world;
    private BlockPos pos;
    private IBlockState state;
    private TileEntity tileEntity;
    private boolean tileEntityInitialized;
    private PatternMatchContext matchContext;
    private PatternMatchContext layerContext;

    public static IPatternCenterPredicate wrap(Predicate<BlockWorldState> predicate) {
        return predicate::test;
    }

    public void update(World worldIn, BlockPos posIn, PatternMatchContext matchContext, PatternMatchContext layerContext) {
        this.world = worldIn;
        this.pos = posIn;
        this.state = null;
        this.tileEntity = null;
        this.tileEntityInitialized = false;
        this.matchContext = matchContext;
        this.layerContext = layerContext;
    }

    public PatternMatchContext getMatchContext() {
        return this.matchContext;
    }

    public PatternMatchContext getLayerContext() {
        return this.layerContext;
    }

    public IBlockState getBlockState() {
        if (this.state == null) {
            this.state = this.world.func_180495_p(this.pos);
        }
        return this.state;
    }

    @Nullable
    public TileEntity getTileEntity() {
        if (this.tileEntity == null && !this.tileEntityInitialized) {
            this.tileEntity = this.world.func_175625_s(this.pos);
            this.tileEntityInitialized = true;
        }
        return this.tileEntity;
    }

    public BlockPos getPos() {
        return this.pos.func_185334_h();
    }

    public IBlockState getOffsetState(EnumFacing face) {
        if (this.pos instanceof BlockPos.MutableBlockPos) {
            ((BlockPos.MutableBlockPos)this.pos).func_189536_c(face);
            IBlockState blockState = this.world.func_180495_p(this.pos);
            ((BlockPos.MutableBlockPos)this.pos).func_189536_c(face.func_176734_d());
            return blockState;
        }
        return this.world.func_180495_p(this.pos.func_177972_a(face));
    }

    public World getWorld() {
        return this.world;
    }
}

