/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.render;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.render.Textures;
import gregtech.api.util.GTUtility;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class TankRenderer
implements TextureUtils.IIconRegister {
    private final String basePath;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite sideSprite;

    public TankRenderer(String basePath) {
        this.basePath = basePath;
        Textures.iconRegisters.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.sideSprite = textureMap.func_174942_a(new ResourceLocation("gregtech", "blocks/" + this.basePath));
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        return this.sideSprite;
    }

    public void render(CCRenderState renderState, Matrix4 translation, int baseColor, IVertexOperation[] pipeline, int capacity, FluidStack fluidStack) {
        IVertexOperation[] basePipeline = (IVertexOperation[])ArrayUtils.add((Object[])pipeline, (Object)new ColourMultiplier(baseColor));
        Cuboid6 fluidCuboid = null;
        IVertexOperation[] fluidPipeline = null;
        TextureAtlasSprite fluidSprite = null;
        if (fluidStack != null) {
            double fluidLevel = (double)fluidStack.amount / ((double)capacity * 1.0) * 0.98;
            fluidCuboid = fluidStack.getFluid().isGaseous(fluidStack) ? new Cuboid6(0.01, 0.99 - fluidLevel, 0.01, 0.99, 0.99, 0.99) : new Cuboid6(0.01, 0.01, 0.01, 0.99, 0.01 + fluidLevel, 0.99);
            ColourMultiplier multiplier = new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(fluidStack.getFluid().getColor(fluidStack)));
            fluidPipeline = new IVertexOperation[]{multiplier};
            fluidSprite = TextureUtils.getTexture((ResourceLocation)fluidStack.getFluid().getStill(fluidStack));
        }
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            Textures.renderFace(renderState, translation, basePipeline, renderSide, Cuboid6.full, this.sideSprite);
            Textures.renderFace(renderState, translation.copy().translate((double)renderSide.func_82601_c(), (double)renderSide.func_96559_d(), (double)renderSide.func_82599_e()), basePipeline, renderSide.func_176734_d(), Cuboid6.full, this.sideSprite);
            if (fluidStack == null) continue;
            Textures.renderFace(renderState, translation, fluidPipeline, renderSide, fluidCuboid, fluidSprite);
        }
    }
}

