/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.GregTechAPI;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.util.IBlockOre;
import gregtech.common.blocks.properties.PropertyStoneType;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockOre
extends BlockFalling
implements IBlockOre {
    public final PropertyStoneType STONE_TYPE;
    public final DustMaterial material;

    public BlockOre(DustMaterial material, StoneType[] allowedValues) {
        super(Material.field_151576_e);
        this.func_149663_c("ore_block");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.material = material;
        this.STONE_TYPE = PropertyStoneType.create("stone_type", allowedValues);
        this.initBlockState();
    }

    public Material func_149688_o(IBlockState state) {
        String harvestTool = this.getHarvestTool(state);
        if (harvestTool != null && harvestTool.equals("shovel")) {
            return Material.field_151578_c;
        }
        return Material.field_151576_e;
    }

    protected final BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    protected void initBlockState() {
        BlockStateContainer stateContainer = this.createStateContainer();
        ObfuscationReflectionHelper.setPrivateValue(Block.class, (Object)this, (Object)stateContainer, (int)21);
        this.func_180632_j(stateContainer.func_177621_b());
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        StoneType stoneType = (StoneType)state.func_177229_b((IProperty)this.STONE_TYPE);
        return stoneType.soundType;
    }

    public String getHarvestTool(IBlockState state) {
        StoneType stoneType = (StoneType)state.func_177229_b((IProperty)this.STONE_TYPE);
        return stoneType.harvestTool;
    }

    public int getHarvestLevel(IBlockState state) {
        StoneType stoneType = (StoneType)state.func_177229_b((IProperty)this.STONE_TYPE);
        if (this.material != null) {
            int toolQuality = this.material.harvestLevel;
            return Math.max(stoneType.stoneMaterial.harvestLevel, toolQuality > 1 ? toolQuality - 1 : toolQuality);
        }
        return 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.STONE_TYPE, (Comparable)this.STONE_TYPE.getAllowedValues().get(meta));
    }

    public int func_176201_c(IBlockState state) {
        return this.STONE_TYPE.getAllowedValues().indexOf((Object)state.func_177229_b((IProperty)this.STONE_TYPE));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ((StoneType)blockState.func_177229_b((IProperty)this.STONE_TYPE)).unbreakable ? -1.0f : this.field_149782_v;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return ((StoneType)world.func_180495_p((BlockPos)pos).func_177229_b((IProperty)this.STONE_TYPE)).unbreakable ? 1200000.0f : this.func_149638_a(exploder);
    }

    public ItemStack getItem(IBlockState blockState) {
        return new ItemStack((Block)this, 1, this.func_176201_c(blockState));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == CreativeTabs.field_78027_g) {
            this.field_176227_L.func_177619_a().forEach(blockState -> list.add((Object)this.getItem((IBlockState)blockState)));
        } else if (tab == GregTechAPI.TAB_GREGTECH_ORES) {
            list.add((Object)this.getItem(this.func_176223_P()));
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    private BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.STONE_TYPE});
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (((StoneType)state.func_177229_b((IProperty)this.STONE_TYPE)).affectedByGravity) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (((StoneType)state.func_177229_b((IProperty)this.STONE_TYPE)).affectedByGravity) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (((StoneType)state.func_177229_b((IProperty)this.STONE_TYPE)).affectedByGravity) {
            super.func_180650_b(worldIn, pos, state, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((StoneType)stateIn.func_177229_b((IProperty)this.STONE_TYPE)).affectedByGravity) {
            super.func_180655_c(stateIn, worldIn, pos, rand);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_189876_x(IBlockState state) {
        return this.material.materialRGB;
    }

    @Override
    public IBlockState getOreBlock(StoneType stoneType) {
        return this.func_176223_P().func_177226_a((IProperty)this.STONE_TYPE, (Comparable)stoneType);
    }
}

