/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.command.util;

import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import gregtech.api.items.materialitem.MaterialMetaItem;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.toolitem.IToolStats;
import gregtech.api.items.toolitem.ToolMetaItem;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CommandHand
extends CommandBase {
    public String func_71517_b() {
        return "hand";
    }

    public String func_71518_a(ICommandSender sender) {
        return "gregtech.command.util.hand.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            ItemStack stackInHand = player.field_71071_by.func_70448_g();
            if (stackInHand.func_190926_b()) {
                throw new CommandException("gregtech.command.util.hand.no_item", new Object[0]);
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.util.hand.item_id", new Object[]{stackInHand.func_77973_b().getRegistryName(), stackInHand.func_77952_i()}));
            IElectricItem electricItem = (IElectricItem)stackInHand.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)stackInHand.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (electricItem != null) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.util.hand.electric", new Object[]{electricItem.getCharge(), electricItem.getMaxCharge(), electricItem.getTier(), Boolean.toString(electricItem.canProvideChargeExternally())}));
            }
            if (fluidHandlerItem != null) {
                for (IFluidTankProperties properties : fluidHandlerItem.getTankProperties()) {
                    FluidStack contents = properties.getContents();
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.util.hand.fluid", new Object[]{contents == null ? "empty" : contents.getFluid().getName(), contents == null ? 0 : contents.amount, properties.getCapacity(), Boolean.toString(properties.canFill()), Boolean.toString(properties.canDrain())}));
                }
            }
            if (stackInHand.func_77973_b() instanceof MetaItem) {
                MetaItem metaItem = (MetaItem)stackInHand.func_77973_b();
                Object metaValueItem = metaItem.getItem(stackInHand);
                if (metaValueItem == null) {
                    if (metaItem instanceof MaterialMetaItem) {
                        Material material = ((MaterialMetaItem)metaItem).getMaterial(stackInHand);
                        OrePrefix orePrefix = ((MaterialMetaItem)metaItem).getOrePrefix(stackInHand);
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.util.hand.material_meta_item", new Object[]{orePrefix, material}));
                    }
                } else {
                    if (metaValueItem instanceof ToolMetaItem.MetaToolValueItem) {
                        IToolStats toolStats = ((ToolMetaItem.MetaToolValueItem)metaValueItem).getToolStats();
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.util.hand.tool_stats", new Object[]{toolStats.getClass().getName()}));
                    }
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.command.util.hand.meta_item", new Object[]{((MetaItem.MetaValueItem)metaValueItem).unlocalizedName, metaValueItem}));
                }
            }
        } else {
            throw new CommandException("gregtech.command.util.hand.not_a_player", new Object[0]);
        }
    }
}

