/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.cover.CoverBehavior;
import gregtech.api.cover.CoverWithUI;
import gregtech.api.cover.ICoverable;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SliderWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.render.Textures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CoverMachineController
extends CoverBehavior
implements CoverWithUI {
    private int minRedstoneStrength = 1;
    private boolean isInverted = false;
    private ControllerMode controllerMode;
    private final ItemStackHandler displayInventory = new ItemStackHandler(1);

    public CoverMachineController(ICoverable coverHolder, EnumFacing attachedSide) {
        super(coverHolder, attachedSide);
        this.controllerMode = ControllerMode.MACHINE;
    }

    public int getMinRedstoneStrength() {
        return this.minRedstoneStrength;
    }

    public ControllerMode getControllerMode() {
        return this.controllerMode;
    }

    public boolean isInverted() {
        return this.isInverted;
    }

    public void setMinRedstoneStrength(int minRedstoneStrength) {
        this.minRedstoneStrength = minRedstoneStrength;
        this.updateRedstoneStatus();
        this.coverHolder.markDirty();
    }

    public void setInverted(boolean inverted) {
        this.isInverted = inverted;
        this.updateRedstoneStatus();
        this.coverHolder.markDirty();
    }

    public void setControllerMode(ControllerMode controllerMode) {
        this.resetCurrentControllable();
        this.controllerMode = controllerMode;
        this.updateRedstoneStatus();
        this.updateDisplayInventory();
        this.coverHolder.markDirty();
    }

    private void cycleNextControllerMode() {
        List<ControllerMode> allowedModes = this.getAllowedModes();
        int nextIndex = allowedModes.indexOf((Object)this.controllerMode) + 1;
        if (!allowedModes.isEmpty()) {
            this.setControllerMode(allowedModes.get(nextIndex % allowedModes.size()));
        }
    }

    public List<ControllerMode> getAllowedModes() {
        ArrayList<ControllerMode> results = new ArrayList<ControllerMode>();
        for (ControllerMode controllerMode : ControllerMode.values()) {
            IControllable controllable = null;
            if (controllerMode.side == null) {
                controllable = this.coverHolder.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
            } else {
                CoverBehavior coverBehavior = this.coverHolder.getCoverAtSide(controllerMode.side);
                if (coverBehavior != null) {
                    controllable = coverBehavior.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
                }
            }
            if (controllable == null) continue;
            results.add(controllerMode);
        }
        return results;
    }

    @Override
    public boolean canAttach() {
        return !this.getAllowedModes().isEmpty();
    }

    @Override
    public EnumActionResult onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, CuboidRayTraceResult hitResult) {
        if (!this.coverHolder.getWorld().field_72995_K) {
            this.openUI((EntityPlayerMP)playerIn);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        this.updateDisplayInventory();
        return ModularUI.defaultBuilder().label(10, 5, "cover.machine_controller.name").widget(new SliderWidget("cover.machine_controller.redstone", 10, 20, 156, 20, 1.0f, 16.0f, this.minRedstoneStrength, it -> this.setMinRedstoneStrength((int)it))).widget(new ClickButtonWidget(10, 45, 126, 20, "", data -> this.cycleNextControllerMode())).widget(new SimpleTextWidget(68, 55, "", 0xFFFFFF, () -> this.getControllerMode().func_176610_l())).widget(new SlotWidget((IItemHandlerModifiable)this.displayInventory, 0, 141, 47, false, false).setBackgroundTexture(GuiTextures.SLOT)).widget(new CycleButtonWidget(10, 70, 75, 20, this::isInverted, this::setInverted, "cover.machine_controller.normal", "cover.machine_controller.inverted")).build(this, player);
    }

    @Override
    public void onAttached(ItemStack itemStack) {
        super.onAttached(itemStack);
        this.controllerMode = this.getAllowedModes().iterator().next();
        this.updateRedstoneStatus();
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.resetCurrentControllable();
    }

    @Override
    public void renderCover(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline, Cuboid6 plateBox) {
        Textures.MACHINE_CONTROLLER_OVERLAY.renderSided(this.attachedSide, plateBox, renderState, pipeline, translation);
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public void onRedstoneInputSignalChange(int newSignalStrength) {
        this.updateRedstoneStatus();
    }

    private void updateDisplayInventory() {
        CoverBehavior coverBehavior;
        EnumFacing controlledSide = this.getControllerMode().side;
        ItemStack resultStack = ItemStack.field_190927_a;
        if (controlledSide != null && (coverBehavior = this.coverHolder.getCoverAtSide(controlledSide)) != null) {
            resultStack = coverBehavior.getCoverDefinition().getDropItemStack();
        }
        this.displayInventory.setStackInSlot(0, resultStack);
    }

    private IControllable getControllable() {
        EnumFacing side = this.controllerMode.side;
        if (side == null) {
            return this.coverHolder.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
        }
        CoverBehavior coverBehavior = this.coverHolder.getCoverAtSide(side);
        if (coverBehavior == null) {
            return null;
        }
        return coverBehavior.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
    }

    private void resetCurrentControllable() {
        IControllable controllable = this.getControllable();
        if (controllable != null) {
            controllable.setWorkingEnabled(true);
        }
    }

    private void updateRedstoneStatus() {
        IControllable controllable;
        boolean shouldAllowWorking;
        boolean bl = shouldAllowWorking = this.getRedstoneSignalInput() < this.minRedstoneStrength;
        if (this.isInverted) {
            boolean bl2 = shouldAllowWorking = !shouldAllowWorking;
        }
        if ((controllable = this.getControllable()) != null) {
            controllable.setWorkingEnabled(shouldAllowWorking);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74768_a("MinRedstoneStrength", this.minRedstoneStrength);
        tagCompound.func_74757_a("Inverted", this.isInverted);
        tagCompound.func_74768_a("ControllerMode", this.controllerMode.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.minRedstoneStrength = tagCompound.func_74762_e("MinRedstoneStrength");
        this.isInverted = tagCompound.func_74767_n("Invalid");
        this.controllerMode = ControllerMode.values()[tagCompound.func_74762_e("ControllerMode")];
    }

    public static enum ControllerMode implements IStringSerializable
    {
        MACHINE("cover.machine_controller.mode.machine", null),
        COVER_UP("cover.machine_controller.mode.cover_up", EnumFacing.UP),
        COVER_DOWN("cover.machine_controller.mode.cover_down", EnumFacing.DOWN),
        COVER_NORTH("cover.machine_controller.mode.cover_north", EnumFacing.NORTH),
        COVER_SOUTH("cover.machine_controller.mode.cover_south", EnumFacing.SOUTH),
        COVER_EAST("cover.machine_controller.mode.cover_east", EnumFacing.EAST),
        COVER_WEST("cover.machine_controller.mode.cover_west", EnumFacing.WEST);

        public final String localeName;
        public final EnumFacing side;

        private ControllerMode(String localeName, EnumFacing side) {
            this.localeName = localeName;
            this.side = side;
        }

        public String func_176610_l() {
            return this.localeName;
        }
    }
}

