/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam;

import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.SteamMetaTileEntity;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.render.Textures;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class SteamAlloySmelter
extends SteamMetaTileEntity {
    public SteamAlloySmelter(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, RecipeMaps.ALLOY_SMELTER_RECIPES, Textures.ALLOY_SMELTER_OVERLAY, isHighPressure);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new SteamAlloySmelter(this.metaTileEntityId, this.isHighPressure);
    }

    @Override
    protected boolean isBrickedCasing() {
        return true;
    }

    @Override
    public IItemHandlerModifiable createImportItemHandler() {
        return new ItemStackHandler(2);
    }

    @Override
    public IItemHandlerModifiable createExportItemHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    public ModularUI createUI(EntityPlayer player) {
        TextureArea slotBackground = this.getFullGuiTexture("slot_%s_furnace_background");
        return this.createUITemplate(player).widget(new SlotWidget(this.importItems, 0, 60, 25).setBackgroundTexture(this.BRONZE_SLOT_BACKGROUND_TEXTURE, slotBackground)).widget(new SlotWidget(this.importItems, 1, 42, 25).setBackgroundTexture(this.BRONZE_SLOT_BACKGROUND_TEXTURE, slotBackground)).widget(new ProgressWidget(this.workableHandler::getProgressPercent, 82, 25, 20, 16).setProgressBar(this.getFullGuiTexture("progress_bar_%s_furnace"), this.getFullGuiTexture("progress_bar_%s_furnace_filled"), ProgressWidget.MoveType.HORIZONTAL)).widget(new SlotWidget(this.exportItems, 0, 107, 25, true, false).setBackgroundTexture(this.BRONZE_SLOT_BACKGROUND_TEXTURE)).build(this.getHolder(), player);
    }
}

