/*
 * Decompiled with CFR 0.152.
 */
package gregtech.integration.jei;

import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.capability.impl.FuelRecipeLogic;
import gregtech.api.gui.impl.ModularUIGuiHandler;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.machines.FuelRecipeMap;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.integration.jei.multiblock.MultiblockInfoCategory;
import gregtech.integration.jei.recipe.GTRecipeWrapper;
import gregtech.integration.jei.recipe.RecipeMapCategory;
import gregtech.integration.jei.recipe.fuel.FuelRecipeMapCategory;
import gregtech.integration.jei.recipe.fuel.GTFuelRecipeWrapper;
import gregtech.integration.jei.utils.CustomItemReturnRecipeWrapper;
import gregtech.integration.jei.utils.MetadataAwareFluidHandlerSubtype;
import gregtech.loaders.recipe.CustomItemReturnShapedOreRecipeRecipe;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

@JEIPlugin
public class GTJeiPlugin
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        MetadataAwareFluidHandlerSubtype subtype = new MetadataAwareFluidHandlerSubtype();
        for (MetaItem<?> metaItem : MetaItems.ITEMS) {
            subtypeRegistry.registerSubtypeInterpreter(metaItem, (ISubtypeRegistry.ISubtypeInterpreter)subtype);
        }
        subtypeRegistry.registerSubtypeInterpreter(Item.func_150898_a((Block)MetaBlocks.MACHINE), (ISubtypeRegistry.ISubtypeInterpreter)subtype);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new MultiblockInfoCategory(registry.getJeiHelpers())});
        for (RecipeMap<?> recipeMap : RecipeMap.getRecipeMaps()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new RecipeMapCategory(recipeMap, registry.getJeiHelpers().getGuiHelper())});
        }
        for (FuelRecipeMap fuelRecipeMap : FuelRecipeMap.getRecipeMaps()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new FuelRecipeMapCategory(fuelRecipeMap, registry.getJeiHelpers().getGuiHelper())});
        }
    }

    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        MultiblockInfoCategory.registerRecipes(registry);
        registry.handleRecipes(CustomItemReturnShapedOreRecipeRecipe.class, recipe -> new CustomItemReturnRecipeWrapper(jeiHelpers, (CustomItemReturnShapedOreRecipeRecipe)((Object)((Object)recipe))), "minecraft.crafting");
        ModularUIGuiHandler modularUIGuiHandler = new ModularUIGuiHandler();
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{modularUIGuiHandler});
        registry.addGhostIngredientHandler(modularUIGuiHandler.getGuiContainerClass(), (IGhostIngredientHandler)modularUIGuiHandler);
        for (RecipeMap<?> recipeMap : RecipeMap.getRecipeMaps()) {
            List recipesList = recipeMap.getRecipeList().stream().filter(recipe -> !recipe.isHidden() && recipe.hasValidInputsForDisplay()).map(r -> new GTRecipeWrapper(recipeMap, (Recipe)r)).collect(Collectors.toList());
            registry.addRecipes(recipesList, "gregtech:" + recipeMap.unlocalizedName);
        }
        for (FuelRecipeMap fuelRecipeMap : FuelRecipeMap.getRecipeMaps()) {
            List recipeList = fuelRecipeMap.getRecipeList().stream().map(GTFuelRecipeWrapper::new).collect(Collectors.toList());
            registry.addRecipes(recipeList, "gregtech:" + fuelRecipeMap.unlocalizedName);
        }
        for (ResourceLocation metaTileEntityId : GregTechAPI.META_TILE_ENTITY_REGISTRY.func_148742_b()) {
            Object recipeMap;
            MetaTileEntity metaTileEntity = (MetaTileEntity)GregTechAPI.META_TILE_ENTITY_REGISTRY.func_82594_a(metaTileEntityId);
            if (metaTileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null) == null) continue;
            IControllable iControllable = metaTileEntity.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
            if (iControllable instanceof AbstractRecipeLogic) {
                recipeMap = ((AbstractRecipeLogic)iControllable).recipeMap;
                registry.addRecipeCatalyst((Object)metaTileEntity.getStackForm(), new String[]{"gregtech:" + ((RecipeMap)recipeMap).unlocalizedName});
                continue;
            }
            if (!(iControllable instanceof FuelRecipeLogic)) continue;
            recipeMap = ((FuelRecipeLogic)iControllable).recipeMap;
            registry.addRecipeCatalyst((Object)metaTileEntity.getStackForm(), new String[]{"gregtech:" + ((FuelRecipeMap)recipeMap).unlocalizedName});
        }
        for (Iterator<Object> iterator : MetaTileEntities.BREWERY) {
            registry.addRecipeCatalyst((Object)((MetaTileEntity)((Object)iterator)).getStackForm(), new String[]{"minecraft.brewing"});
        }
        String semiFluidMapId = "gregtech:" + RecipeMaps.SEMI_FLUID_GENERATOR_FUELS.getUnlocalizedName();
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_BRONZE_BOILER.getStackForm(), new String[]{semiFluidMapId});
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_STEEL_BOILER.getStackForm(), new String[]{semiFluidMapId});
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_TITANIUM_BOILER.getStackForm(), new String[]{semiFluidMapId});
        registry.addRecipeCatalyst((Object)MetaTileEntities.LARGE_TUNGSTENSTEEL_BOILER.getStackForm(), new String[]{semiFluidMapId});
    }
}

